/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.crend.dynamiccrosshair.AutoHudCompat;
import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshair.component.CrosshairComponent;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import mod.crend.dynamiccrosshair.style.CrosshairStyledPart;
import mod.crend.libbamboo.render.CustomFramebufferRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class CrosshairRenderer {
    public static boolean autoHudCompat = false;

    private static void setColor(int argb, boolean enableBlend) {
        RenderSystem.setShaderColor((float)((float)(argb >> 16 & 0xFF) / 255.0f), (float)((float)(argb >> 8 & 0xFF) / 255.0f), (float)((float)(argb & 0xFF) / 255.0f), (float)((float)(argb >> 24 & 0xFF) / 255.0f));
        if (!enableBlend || autoHudCompat) {
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
    }

    public static void preRender() {
        CrosshairStyle defaultStyle = CrosshairHandler.getDefaultCrosshair();
        CrosshairRenderer.setColor(defaultStyle.color(), defaultStyle.enableBlend());
    }

    public static void fixCenteredCrosshairPre(GuiGraphics context, int x, int y) {
        Window window = Minecraft.getInstance().getWindow();
        double scale = window.getGuiScale();
        double i = (double)window.getWidth() / scale;
        double j = (double)window.getHeight() / scale;
        double dx = (i - 15.0) / 2.0 - (double)x;
        double dy = (j - 15.0) / 2.0 - (double)y;
        context.pose().pushPose();
        context.pose().translate(dx, dy, 0.0);
    }

    public static void fixCenteredCrosshairPost(GuiGraphics context) {
        context.pose().popPose();
    }

    public static void renderCrosshair(GuiGraphics context, ResourceLocation style, int x, int y) {
        CrosshairStyleManager.INSTANCE.get(style).draw(context, x, y);
    }

    public static void renderCrosshair(GuiGraphics context, CrosshairStyle style, int x, int y) {
        CrosshairRenderer.setColor(style.color(), style.enableBlend());
        CrosshairRenderer.renderCrosshair(context, style.identifier(), x, y);
    }

    private static void preRenderHalf() {
        RenderSystem.defaultBlendFunc();
        CustomFramebufferRenderer.init();
    }

    private static void postRenderHalf(GuiGraphics context, boolean blend) {
        RenderSystem.enableBlend();
        if (blend) {
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        } else {
            RenderSystem.defaultBlendFunc();
        }
        CustomFramebufferRenderer.draw((GuiGraphics)context);
    }

    private static void renderStyles(GuiGraphics context, int x, int y, List<CrosshairStyledPart> styles) {
        for (CrosshairStyledPart part : styles) {
            if (autoHudCompat) {
                AutoHudCompat.renderCrosshair(context, part.part(), part.style(), x, y);
                continue;
            }
            CrosshairRenderer.renderCrosshair(context, part.style(), x, y);
        }
    }

    public static void render(GuiGraphics context, int x, int y) {
        context.flush();
        CrosshairComponent crosshair = CrosshairHandler.getActiveCrosshair();
        CrosshairRenderer.preRenderHalf();
        CrosshairRenderer.renderStyles(context, x, y, crosshair.getStylesWithBlend());
        CrosshairRenderer.postRenderHalf(context, true);
        CrosshairRenderer.preRenderHalf();
        CrosshairRenderer.renderStyles(context, x, y, crosshair.getStylesWithoutBlend());
        CrosshairRenderer.postRenderHalf(context, false);
    }

    public static void postRender() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void wrapRender(GuiGraphics context, int x, int y, Runnable originalRenderCall, Runnable noBlendRenderCall) {
        if (!CrosshairHandler.forceShowCrosshair && !CrosshairHandler.shouldShowCrosshair()) {
            return;
        }
        CrosshairRenderer.preRender();
        if (DynamicCrosshairMod.config.isFixCenteredCrosshair()) {
            CrosshairRenderer.fixCenteredCrosshairPre(context, x, y);
        }
        if (DynamicCrosshairMod.config.isDynamicCrosshairStyle()) {
            CrosshairRenderer.render(context, x, y);
        } else if (!CrosshairHandler.getDefaultCrosshair().enableBlend()) {
            noBlendRenderCall.run();
            context.flush();
        } else {
            originalRenderCall.run();
        }
        if (DynamicCrosshairMod.config.isFixCenteredCrosshair()) {
            CrosshairRenderer.fixCenteredCrosshairPost(context);
        }
        CrosshairRenderer.postRender();
    }
}

