/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.gui;

import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.config.LightSourceSettingEntry;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.background.EmptyBackground;
import dev.lambdaurora.spruceui.background.SimpleColorBackground;
import dev.lambdaurora.spruceui.navigation.NavigationDirection;
import dev.lambdaurora.spruceui.navigation.NavigationUtils;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.WithBackground;
import dev.lambdaurora.spruceui.widget.container.SpruceEntryListWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class LightSourceListWidget
extends SpruceEntryListWidget<LightSourceEntry> {
    private static final Background HIGHLIGHT_BACKGROUND = new SimpleColorBackground(128, 128, 128, 24);
    private int lastIndex = 0;

    public LightSourceListWidget(Position position, int width, int height) {
        super(position, width, height, 4, LightSourceEntry.class);
    }

    public int addEntry(DynamicLightHandlerHolder<?> holder) {
        if (holder.lambdynlights$getSetting() != null) {
            LightSourceEntry entry = LightSourceEntry.create(this, holder);
            int index = this.addEntry(entry);
            if (index % 2 != 0) {
                entry.setBackground(HIGHLIGHT_BACKGROUND);
            }
            return index;
        }
        return -1;
    }

    public void addAll(List<DynamicLightHandlerHolder<?>> types) {
        for (DynamicLightHandlerHolder<?> type : types) {
            this.addEntry(type);
        }
    }

    public void updateNarration(NarrationElementOutput builder) {
        this.children().stream().filter(AbstractSpruceWidget::isMouseHovered).findFirst().ifPresentOrElse(hoveredEntry -> {
            hoveredEntry.updateNarration(builder.nest());
            this.appendPositionNarrations(builder, (SpruceEntryListWidget.Entry)hoveredEntry);
        }, () -> {
            LightSourceEntry focusedEntry = (LightSourceEntry)this.getFocused();
            if (focusedEntry != null) {
                focusedEntry.updateNarration(builder.nest());
                this.appendPositionNarrations(builder, focusedEntry);
            }
        });
        builder.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
    }

    public static class LightSourceEntry
    extends SpruceEntryListWidget.Entry
    implements SpruceParentWidget<SpruceWidget>,
    WithBackground {
        private final List<SpruceWidget> children = new ArrayList<SpruceWidget>();
        private final LightSourceListWidget parent;
        @Nullable
        private SpruceWidget focused;
        private boolean dragging;
        private Background background = EmptyBackground.EMPTY_BACKGROUND;

        private LightSourceEntry(LightSourceListWidget parent) {
            this.parent = parent;
        }

        public static LightSourceEntry create(LightSourceListWidget parent, DynamicLightHandlerHolder<?> option) {
            LightSourceEntry entry = new LightSourceEntry(parent);
            LightSourceSettingEntry setting = option.lambdynlights$getSetting();
            entry.children.add((SpruceWidget)new SpruceLabelWidget(Position.of((SprucePositioned)entry, (int)(entry.getWidth() / 2 - 155), (int)7), option.lambdynlights$getName(), 175));
            entry.children.add(setting.getOption().createWidget(Position.of((SprucePositioned)entry, (int)(entry.getWidth() / 2 + 60), (int)2), 75));
            return entry;
        }

        public int getWidth() {
            return this.parent.getWidth() - this.parent.getBorder().getThickness() * 2;
        }

        public int getHeight() {
            return this.children.stream().mapToInt(SpruceWidget::getHeight).reduce(Integer::max).orElse(0) + 4;
        }

        public List<SpruceWidget> children() {
            return this.children;
        }

        @Nullable
        public SpruceWidget getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable SpruceWidget focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.setFocused(false);
            }
            this.focused = focused;
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (!focused) {
                this.setFocused(null);
            }
        }

        public Background getBackground() {
            return this.background;
        }

        public void setBackground(Background background) {
            this.background = background;
        }

        protected boolean onMouseClick(double mouseX, double mouseY, int button) {
            SpruceWidget element;
            Iterator it = this.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!(element = (SpruceWidget)it.next()).mouseClicked(mouseX, mouseY, button));
            this.setFocused(element);
            if (button == 0) {
                this.dragging = true;
            }
            return true;
        }

        protected boolean onMouseRelease(double mouseX, double mouseY, int button) {
            this.dragging = false;
            return this.hoveredElement(mouseX, mouseY).filter(element -> element.mouseReleased(mouseX, mouseY, button)).isPresent();
        }

        protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.getFocused() != null && this.dragging && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
            return this.focused != null && this.focused.keyPressed(keyCode, scanCode, modifiers);
        }

        protected boolean onKeyRelease(int keyCode, int scanCode, int modifiers) {
            return this.focused != null && this.focused.keyReleased(keyCode, scanCode, modifiers);
        }

        protected boolean onCharTyped(char chr, int keyCode) {
            return this.focused != null && this.focused.charTyped(chr, keyCode);
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.forEach(widget -> widget.render(graphics, mouseX, mouseY, delta));
        }

        protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.background.render(graphics, (SpruceWidget)this, 0, mouseX, mouseY, delta);
        }

        public void updateNarration(NarrationElementOutput builder) {
            SpruceWidget focused = this.getFocused();
            if (focused != null) {
                focused.updateNarration(builder);
            }
        }

        public boolean onNavigation(NavigationDirection direction, boolean tab) {
            if (this.requiresCursor()) {
                return false;
            }
            if (!tab && direction.isVertical()) {
                if (this.isFocused()) {
                    this.setFocused(null);
                    return false;
                }
                int lastIndex = this.parent.lastIndex;
                if (lastIndex >= this.children.size()) {
                    lastIndex = this.children.size() - 1;
                }
                if (!this.children.get(lastIndex).onNavigation(direction, tab)) {
                    return false;
                }
                this.setFocused(this.children.get(lastIndex));
                return true;
            }
            boolean result = NavigationUtils.tryNavigate((NavigationDirection)direction, (boolean)tab, this.children, (SpruceWidget)this.focused, this::setFocused, (boolean)true);
            if (result) {
                this.setFocused(true);
                if (direction.isHorizontal() && this.getFocused() != null) {
                    this.parent.lastIndex = this.children.indexOf(this.getFocused());
                }
            }
            return result;
        }
    }
}

