/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.compat;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.compat.AccessoriesCompat;
import dev.lambdaurora.lambdynlights.compat.CuriosCompat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompatLayer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|CompatLayer");
    public static final List<CompatLayer> LAYERS = CompatLayer.initLayers();

    public @Range(from=0L, to=15L) int getLivingEntityLuminanceFromItems(LivingEntity var1, boolean var2);

    private static List<CompatLayer> initLayers() {
        ArrayList<CompatLayer> layers = new ArrayList<CompatLayer>();
        try {
            if (ModList.get().isLoaded("accessories")) {
                layers.add(new AccessoriesCompat());
            } else if (ModList.get().isLoaded("curios")) {
                layers.add(new CuriosCompat());
            }
        }
        catch (LinkageError e) {
            LambDynLights.error(LOGGER, "Could not load a compatibility layer: THIS IS VERY WRONG, PLEASE REPORT THIS ERROR TO LAMBDYNAMICLIGHTS' AUTHOR ASAP.", e);
        }
        return layers;
    }
}

