/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Brightness;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Range;

public sealed interface ItemLuminance {
    public static final Codec<ItemLuminance> CODEC = Codec.withAlternative((Codec)Type.CODEC.dispatch(ItemLuminance::type, Type::codec), Value.DIRECT_CODEC);

    public Type type();

    public @Range(from=0L, to=15L) int getLuminance(ItemStack var1);

    public static enum Type {
        VALUE("value", Value.CODEC),
        BLOCK_REFERENCE("block", BlockReference.CODEC),
        BLOCK_SELF("block_self", BlockSelf.CODEC);

        private static final Map<String, Type> BY_NAME;
        public static final Codec<Type> CODEC;
        private final String name;
        private final MapCodec<? extends ItemLuminance> codec;

        private Type(String name, MapCodec<? extends ItemLuminance> codec) {
            this.name = name;
            this.codec = codec;
        }

        public String getName() {
            return this.name;
        }

        public MapCodec<? extends ItemLuminance> codec() {
            return this.codec;
        }

        public static Type byName(String name) {
            return BY_NAME.get(name);
        }

        static {
            BY_NAME = (Map)Util.make(() -> Stream.of(Type.values()).collect(HashMap::new, (map, type) -> map.put(type.getName(), type), HashMap::putAll));
            CODEC = Codec.stringResolver(Type::getName, Type::byName);
        }
    }

    public record Value(@Range(from=0L, to=15L) int luminance) implements ItemLuminance
    {
        public static final Codec<Value> DIRECT_CODEC = Brightness.LIGHT_VALUE_CODEC.xmap(Value::new, Value::luminance);
        public static final MapCodec<Value> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Brightness.LIGHT_VALUE_CODEC.fieldOf("value").forGetter(Value::luminance)).apply((Applicative)instance, Value::new));

        @Override
        public Type type() {
            return Type.VALUE;
        }

        @Override
        public @Range(from=0L, to=15L) int getLuminance(ItemStack stack) {
            return this.luminance;
        }
    }

    public static final class BlockSelf
    implements ItemLuminance {
        public static final BlockSelf INSTANCE = new BlockSelf();
        public static final MapCodec<BlockSelf> CODEC = MapCodec.unit((Object)INSTANCE);

        private BlockSelf() {
        }

        @Override
        public Type type() {
            return Type.BLOCK_SELF;
        }

        @Override
        public @Range(from=0L, to=15L) int getLuminance(ItemStack stack) {
            return Block.byItem((Item)stack.getItem()).defaultBlockState().getLightEmission();
        }
    }

    public record BlockReference(Block block) implements ItemLuminance
    {
        public static final MapCodec<BlockReference> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(BlockReference::blockHolder)).apply((Applicative)instance, BlockReference::new));

        public BlockReference(Holder<Block> block) {
            this((Block)block.value());
        }

        public Holder<Block> blockHolder() {
            return this.block.builtInRegistryHolder();
        }

        @Override
        public Type type() {
            return Type.BLOCK_REFERENCE;
        }

        @Override
        public @Range(from=0L, to=15L) int getLuminance(ItemStack stack) {
            return this.block.defaultBlockState().getLightEmission();
        }
    }
}

