/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import dev.lambdaurora.lambdynlights.config.LightSourceSettingEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class DynamicLightHandlers {
    private DynamicLightHandlers() {
        throw new UnsupportedOperationException("DynamicLightHandlers only contains static definitions.");
    }

    public static void registerDefaultHandlers() {
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.ALLAY, allay -> 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.BLAZE, DynamicLightHandler.makeHandler(blaze -> 10, blaze -> true));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.CREEPER, DynamicLightHandler.makeCreeperEntityHandler(null));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.ENDERMAN, entity -> {
            int luminance = 0;
            if (entity.getCarriedBlock() != null) {
                luminance = entity.getCarriedBlock().getLightEmission();
            }
            return luminance;
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.ITEM, entity -> LambDynLights.getLuminanceFromItemStack(entity.getItem(), entity.isUnderWater()));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.ITEM_FRAME, entity -> {
            Level world = entity.level();
            return LambDynLights.getLuminanceFromItemStack(entity.getItem(), !world.getFluidState(entity.blockPosition()).isEmpty());
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.GLOW_ITEM_FRAME, entity -> {
            Level world = entity.level();
            return Math.max(14, LambDynLights.getLuminanceFromItemStack(entity.getItem(), !world.getFluidState(entity.blockPosition()).isEmpty()));
        });
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.MAGMA_CUBE, entity -> (double)entity.squish > 0.6 ? 11 : 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.SPECTRAL_ARROW, entity -> 8);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.GLOW_SQUID, entity -> (int)Mth.clampedLerp((float)0.0f, (float)12.0f, (float)(1.0f - (float)entity.getDarkTicksRemaining() / 10.0f)));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.FIREBALL, DynamicLightHandler.makeHandler(ball -> 14, ball -> true));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.SMALL_FIREBALL, DynamicLightHandler.makeHandler(ball -> 12, ball -> true));
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.DRAGON_FIREBALL, ball -> 14);
        DynamicLightHandlers.registerDynamicLightHandler(EntityType.WITHER_SKULL, ball -> 12);
    }

    public static <T extends Entity> void registerDynamicLightHandler(EntityType<T> type, DynamicLightHandler<T> handler) {
        DynamicLightHandlers.register((DynamicLightHandlerHolder)type, handler);
    }

    private static <T> void register(DynamicLightHandlerHolder<T> holder, DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = holder.lambdynlights$getDynamicLightHandler();
        if (registeredHandler != null) {
            DynamicLightHandler<Object> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            holder.lambdynlights$setDynamicLightHandler(newHandler);
        } else {
            holder.lambdynlights$setDynamicLightHandler(handler);
        }
    }

    @Nullable
    public static <T extends Entity> DynamicLightHandler<T> getDynamicLightHandler(EntityType<T> type) {
        return DynamicLightHandlerHolder.cast(type).lambdynlights$getDynamicLightHandler();
    }

    public static <T extends Entity> boolean canLightUp(T entity) {
        if (entity == Minecraft.getInstance().player ? (Boolean)LambDynLights.get().config.getSelfLightSource().get() == false : (Boolean)LambDynLights.get().config.getEntitiesLightSource().get() == false) {
            return false;
        }
        LightSourceSettingEntry setting = DynamicLightHandlerHolder.cast(entity.getType()).lambdynlights$getSetting();
        return setting != null && (Boolean)setting.get() != false;
    }

    public static <T extends Entity> int getLuminanceFrom(T entity) {
        if (!((Boolean)LambDynLights.get().config.getEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        if (entity == Minecraft.getInstance().player && !((Boolean)LambDynLights.get().config.getSelfLightSource().get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.getType());
        if (handler == null) {
            return 0;
        }
        if (!DynamicLightHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && !entity.level().getFluidState(BlockPos.containing((double)entity.getX(), (double)entity.getEyeY(), (double)entity.getZ())).isEmpty()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }
}

