/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api;

import dev.lambdaurora.lambdynlights.LambDynLights;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DynamicLightHandler<T> {
    public int getLuminance(T var1);

    default public boolean isWaterSensitive(T lightSource) {
        return false;
    }

    @NotNull
    public static <T extends Entity> DynamicLightHandler<T> makeHandler(final Function<T, Integer> luminance, final Function<T, Boolean> waterSensitive) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T lightSource) {
                return (Integer)luminance.apply(lightSource);
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return (Boolean)waterSensitive.apply(lightSource);
            }
        };
    }

    @NotNull
    public static <T extends LivingEntity> DynamicLightHandler<T> makeLivingEntityHandler(@NotNull DynamicLightHandler<T> handler) {
        return entity -> {
            int luminance = 0;
            for (ItemStack equipped : entity.getAllSlots()) {
                luminance = Math.max(luminance, LambDynLights.getLuminanceFromItemStack(equipped, entity.isUnderWater()));
            }
            return Math.max(luminance, handler.getLuminance(entity));
        };
    }

    @NotNull
    public static <T extends Creeper> DynamicLightHandler<T> makeCreeperEntityHandler(final @Nullable DynamicLightHandler<T> handler) {
        return new DynamicLightHandler<T>(){

            @Override
            public int getLuminance(T entity) {
                int luminance = 0;
                if ((double)entity.getSwelling(0.0f) > 0.001) {
                    switch (LambDynLights.get().config.getCreeperLightingMode()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case OFF: {
                            int n = 0;
                            break;
                        }
                        case SIMPLE: {
                            int n = 10;
                            break;
                        }
                        case FANCY: {
                            int n = luminance = (int)((double)entity.getSwelling(0.0f) * 10.0);
                        }
                    }
                }
                if (handler != null) {
                    luminance = Math.max(luminance, handler.getLuminance(entity));
                }
                return luminance;
            }

            @Override
            public boolean isWaterSensitive(T lightSource) {
                return true;
            }
        };
    }
}

