/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.config.BooleanSettingEntry;
import dev.lambdaurora.lambdynlights.config.SettingEntry;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLightsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|Config");
    private static final DynamicLightsMode DEFAULT_DYNAMIC_LIGHTS_MODE = DynamicLightsMode.FANCY;
    private static final boolean DEFAULT_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_SELF_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_BLOCK_ENTITIES_LIGHT_SOURCE = true;
    private static final boolean DEFAULT_WATER_SENSITIVE_CHECK = true;
    private static final ExplosiveLightingMode DEFAULT_CREEPER_LIGHTING_MODE = ExplosiveLightingMode.SIMPLE;
    private static final ExplosiveLightingMode DEFAULT_TNT_LIGHTING_MODE = ExplosiveLightingMode.OFF;
    public static final Path CONFIG_FILE_PATH = FMLPaths.CONFIGDIR.get().resolve("lambdynlights.toml");
    protected final FileConfig config;
    private final LambDynLights mod;
    private DynamicLightsMode dynamicLightsMode;
    private final BooleanSettingEntry entitiesLightSource;
    private final BooleanSettingEntry selfLightSource;
    private final BooleanSettingEntry waterSensitiveCheck;
    private ExplosiveLightingMode creeperLightingMode;
    private ExplosiveLightingMode tntLightingMode;
    public final SpruceOption dynamicLightsModeOption = new SpruceCyclingOption("lambdynlights.option.mode", amount -> this.setDynamicLightsMode(this.dynamicLightsMode.next()), option -> option.getDisplayText(this.dynamicLightsMode.getTranslatedText()), (Component)Component.translatable((String)"lambdynlights.tooltip.mode.1").append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"lambdynlights.tooltip.mode.2", (Object[])new Object[]{DynamicLightsMode.FASTEST.getTranslatedText(), DynamicLightsMode.FAST.getTranslatedText()})).append((Component)Component.literal((String)"\n")).append((Component)Component.translatable((String)"lambdynlights.tooltip.mode.3", (Object[])new Object[]{DynamicLightsMode.FANCY.getTranslatedText()})));

    public DynamicLightsConfig(@NotNull LambDynLights mod) {
        this.mod = mod;
        this.config = FileConfig.builder((Path)CONFIG_FILE_PATH).defaultData(DynamicLightsConfig.class.getResource("/lambdynlights.toml")).autosave().writingMode(WritingMode.REPLACE_ATOMIC).build();
        this.entitiesLightSource = new BooleanSettingEntry("light_sources.entities", true, (Config)this.config, (Component)Component.translatable((String)"lambdynlights.tooltip.entities")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeEntitiesLightSource();
            }
        });
        this.selfLightSource = new BooleanSettingEntry("light_sources.self", true, (Config)this.config, (Component)Component.translatable((String)"lambdynlights.tooltip.self_light_source")).withOnSet(value -> {
            if (!value.booleanValue()) {
                this.mod.removeLightSources(source -> source instanceof LocalPlayer && source == Minecraft.getInstance().player);
            }
        });
        this.waterSensitiveCheck = new BooleanSettingEntry("light_sources.water_sensitive_check", true, (Config)this.config, (Component)Component.translatable((String)"lambdynlights.tooltip.water_sensitive"));
    }

    public void load() {
        this.config.load();
        String dynamicLightsModeValue = (String)this.config.getOrElse("mode", (Object)DEFAULT_DYNAMIC_LIGHTS_MODE.getName());
        this.dynamicLightsMode = DynamicLightsMode.byId(dynamicLightsModeValue).orElse(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.entitiesLightSource.load((Config)this.config);
        this.selfLightSource.load((Config)this.config);
        this.waterSensitiveCheck.load((Config)this.config);
        this.creeperLightingMode = ExplosiveLightingMode.byId((String)this.config.getOrElse("light_sources.creeper", (Object)DEFAULT_CREEPER_LIGHTING_MODE.getName())).orElse(DEFAULT_CREEPER_LIGHTING_MODE);
        this.tntLightingMode = ExplosiveLightingMode.byId((String)this.config.getOrElse("light_sources.tnt", (Object)DEFAULT_TNT_LIGHTING_MODE.getName())).orElse(DEFAULT_TNT_LIGHTING_MODE);
        LambDynLights.log(LOGGER, "Configuration loaded.");
    }

    public void load(SettingEntry<?> settingEntry) {
        settingEntry.load((Config)this.config);
    }

    public void save() {
        this.config.save();
    }

    public void reset() {
        this.setDynamicLightsMode(DEFAULT_DYNAMIC_LIGHTS_MODE);
        this.getEntitiesLightSource().set(true);
        this.getSelfLightSource().set(true);
        this.getWaterSensitiveCheck().set(true);
        this.setCreeperLightingMode(DEFAULT_CREEPER_LIGHTING_MODE);
        this.setTntLightingMode(DEFAULT_TNT_LIGHTING_MODE);
    }

    public DynamicLightsMode getDynamicLightsMode() {
        return this.dynamicLightsMode;
    }

    public void setDynamicLightsMode(@NotNull DynamicLightsMode mode) {
        if (!mode.isEnabled()) {
            this.mod.clearLightSources();
        }
        this.dynamicLightsMode = mode;
        this.config.set("mode", (Object)mode.getName());
    }

    public BooleanSettingEntry getEntitiesLightSource() {
        return this.entitiesLightSource;
    }

    public BooleanSettingEntry getSelfLightSource() {
        return this.selfLightSource;
    }

    public BooleanSettingEntry getWaterSensitiveCheck() {
        return this.waterSensitiveCheck;
    }

    public ExplosiveLightingMode getCreeperLightingMode() {
        return this.creeperLightingMode;
    }

    public void setCreeperLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.creeperLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeCreeperLightSources();
        }
        this.config.set("light_sources.creeper", (Object)lightingMode.getName());
    }

    public ExplosiveLightingMode getTntLightingMode() {
        return this.tntLightingMode;
    }

    public void setTntLightingMode(@NotNull ExplosiveLightingMode lightingMode) {
        this.tntLightingMode = lightingMode;
        if (!lightingMode.isEnabled()) {
            this.mod.removeTntLightSources();
        }
        this.config.set("light_sources.tnt", (Object)lightingMode.getName());
    }
}

