/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.world.item.trading.shop;

import com.cobblemon.mod.common.api.text.TextKt;
import fr.harmex.cobbledollars.common.utils.CobbleDollarsPlayer;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!J\u001a\u0010#\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b%\u0010&R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010)R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010\r\u00a8\u0006."}, d2={"Lfr/harmex/cobbledollars/common/world/item/trading/shop/Offer;", "", "Lnet/minecraft/world/item/ItemStack;", "item", "Ljava/math/BigInteger;", "price", "<init>", "(Lnet/minecraft/world/item/ItemStack;Ljava/math/BigInteger;)V", "", "(Lnet/minecraft/world/item/ItemStack;I)V", "newPrice", "", "updatePrice", "(Ljava/math/BigInteger;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/network/chat/Component;", "getHoverName", "(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/network/chat/Component;", "Lnet/minecraft/network/chat/MutableComponent;", "getDisplayName", "(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/client/Minecraft;", "minecraft", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "mouseX", "mouseY", "renderTooltip", "(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/GuiGraphics;II)V", "itemStack", "", "isItem", "(Lnet/minecraft/world/item/ItemStack;)Z", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Lnet/minecraft/world/item/ItemStack;", "getItem", "()Lnet/minecraft/world/item/ItemStack;", "Ljava/math/BigInteger;", "getPrice", "()Ljava/math/BigInteger;", "setPrice", "cobbledollars-common"})
public final class Offer {
    @NotNull
    private final ItemStack item;
    @NotNull
    private BigInteger price;

    public Offer(@NotNull ItemStack item, @NotNull BigInteger price) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)price, (String)"price");
        this.item = item;
        this.price = price;
    }

    @NotNull
    public final ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public final BigInteger getPrice() {
        return this.price;
    }

    public final void setPrice(@NotNull BigInteger bigInteger) {
        Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"<set-?>");
        this.price = bigInteger;
    }

    public Offer(@NotNull ItemStack item, int price) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        BigInteger bigInteger = BigInteger.valueOf(price);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(item, bigInteger);
    }

    public final void updatePrice(@NotNull BigInteger newPrice) {
        Intrinsics.checkNotNullParameter((Object)newPrice, (String)"newPrice");
        this.price = newPrice;
    }

    @NotNull
    public final Component getHoverName(@Nullable Player player) {
        ChatFormatting color = ChatFormatting.GREEN;
        if (player instanceof CobbleDollarsPlayer) {
            color = ((CobbleDollarsPlayer)player).cobbleDollars$getCobbleDollars().compareTo(this.price) >= 0 ? ChatFormatting.GREEN : ChatFormatting.RED;
        }
        MutableComponent mutableComponent = Component.empty().append(this.item.getHoverName()).append((Component)Component.literal((String)" ")).append((Component)BigIntegerExtensionsKt.formatFull$default(this.price, false, 1, null).withStyle(color));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"append(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public final MutableComponent getDisplayName(@Nullable Player player) {
        MutableComponent mutableComponent = ComponentUtils.wrapInSquareBrackets((Component)((Component)this.item.getHoverName().copy().append((Component)MiscUtilsKt.toComponent(" ")).append((Component)TextKt.green((MutableComponent)BigIntegerExtensionsKt.format$default(this.price, false, 1, null)))));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"wrapInSquareBrackets(...)");
        return TextKt.onHover((MutableComponent)mutableComponent, (Component)this.getHoverName(player));
    }

    public final void renderTooltip(@NotNull Minecraft minecraft, @NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        LocalPlayer localPlayer = minecraft.player;
        List tooltipLines = this.item.getTooltipLines(Item.TooltipContext.of((Level)(localPlayer != null ? localPlayer.level() : null)), (Player)minecraft.player, (TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
        tooltipLines.set(0, this.getHoverName((Player)minecraft.player));
        guiGraphics.renderTooltip(minecraft.font, tooltipLines, Optional.empty(), mouseX, mouseY);
    }

    public final boolean isItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return MiscUtilsKt.isSame(this.item, itemStack);
    }

    public boolean equals(@Nullable Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        int result = ItemStack.hashItemAndComponents((ItemStack)this.item);
        result = 31 * result + this.price.hashCode();
        return result;
    }
}

