/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.world.entity;

import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import fr.harmex.cobbledollars.common.CobbleDollars;
import fr.harmex.cobbledollars.common.utils.extensions.CompoundTagExtensionKt;
import fr.harmex.cobbledollars.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobbledollars.common.world.entity.CobbleDollarsEntities;
import fr.harmex.cobbledollars.common.world.entity.villager.CobbleDollarsProfessions;
import fr.harmex.cobbledollars.common.world.item.trading.ICobbleMerchant;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Category;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Offer;
import fr.harmex.cobbledollars.common.world.item.trading.shop.Shop;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001AB\u001f\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020#H\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010*\u001a\u00020)H\u0014\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010.\u001a\u00020)2\u0006\u0010-\u001a\u00020,H\u0014\u00a2\u0006\u0004\b.\u0010/J\u0011\u00100\u001a\u0004\u0018\u00010)H\u0014\u00a2\u0006\u0004\b0\u0010+J3\u00108\u001a\u0004\u0018\u0001062\u0006\u0010\b\u001a\u0002012\u0006\u00103\u001a\u0002022\u0006\u00105\u001a\u0002042\b\u00107\u001a\u0004\u0018\u000106H\u0016\u00a2\u0006\u0004\b8\u00109R\"\u0010;\u001a\u00020:8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@\u00a8\u0006B"}, d2={"Lfr/harmex/cobbledollars/common/world/entity/CobbleMerchant;", "Lnet/minecraft/world/entity/PathfinderMob;", "Lfr/harmex/cobbledollars/common/world/item/trading/ICobbleMerchant;", "Lnet/minecraft/world/entity/npc/VillagerDataHolder;", "Lnet/minecraft/world/entity/npc/Npc;", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "level", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "", "registerGoals", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResult;", "mobInteract", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "builder", "defineSynchedData", "(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V", "Lnet/minecraft/nbt/CompoundTag;", "compound", "addAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "readAdditionalSaveData", "", "distanceToClosestPlayer", "", "removeWhenFarAway", "(D)Z", "Lnet/minecraft/world/entity/npc/VillagerData;", "getVillagerData", "()Lnet/minecraft/world/entity/npc/VillagerData;", "villagerData", "setVillagerData", "(Lnet/minecraft/world/entity/npc/VillagerData;)V", "Lnet/minecraft/sounds/SoundEvent;", "getAmbientSound", "()Lnet/minecraft/sounds/SoundEvent;", "Lnet/minecraft/world/damagesource/DamageSource;", "damageSource", "getHurtSound", "(Lnet/minecraft/world/damagesource/DamageSource;)Lnet/minecraft/sounds/SoundEvent;", "getDeathSound", "Lnet/minecraft/world/level/ServerLevelAccessor;", "Lnet/minecraft/world/DifficultyInstance;", "difficulty", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnType", "Lnet/minecraft/world/entity/SpawnGroupData;", "spawnGroupData", "finalizeSpawn", "(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "shop", "Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "getShop", "()Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;", "setShop", "(Lfr/harmex/cobbledollars/common/world/item/trading/shop/Shop;)V", "Companion", "cobbledollars-common"})
public final class CobbleMerchant
extends PathfinderMob
implements ICobbleMerchant,
VillagerDataHolder,
Npc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Shop shop;
    @NotNull
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA;

    public CobbleMerchant(@NotNull EntityType<CobbleMerchant> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.shop = new Shop();
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        PathNavigation pathNavigation = this.getNavigation();
        Intrinsics.checkNotNull((Object)pathNavigation, (String)"null cannot be cast to non-null type net.minecraft.world.entity.ai.navigation.GroundPathNavigation");
        ((GroundPathNavigation)pathNavigation).setCanOpenDoors(true);
    }

    public /* synthetic */ CobbleMerchant(EntityType entityType, Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            entityType = CobbleDollarsEntities.COBBLE_MERCHANT;
        }
        this(entityType, level);
    }

    @Override
    @NotNull
    public Shop getShop() {
        return this.shop;
    }

    @Override
    public void setShop(@NotNull Shop shop) {
        Intrinsics.checkNotNullParameter((Object)shop, (String)"<set-?>");
        this.shop = shop;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((TagKey)CobblemonItemTags.POKE_BALLS), false));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        if (this.isAlive() && !this.level().isClientSide) {
            if (player.isShiftKeyDown()) {
                PlayerExtensionKt.openBank(player);
            } else {
                PlayerExtensionKt.openShop(player, this);
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_VILLAGER_DATA, (Object)new VillagerData(VillagerType.PLAINS, CobbleDollarsProfessions.COBBLE_MERCHANT, 1));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        VillagerData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getVillagerData()).resultOrPartial(arg_0 -> ((Logger)CobbleDollars.INSTANCE.getLOGGER()).error(arg_0)).ifPresent(arg_0 -> CobbleMerchant.addAdditionalSaveData$lambda$1(arg_0 -> CobbleMerchant.addAdditionalSaveData$lambda$0(compound, arg_0), arg_0));
        Shop shop = this.getShop();
        RegistryAccess registryAccess = this.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        CompoundTagExtensionKt.putShop(compound, shop, registryAccess);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        if (compound.contains("VillagerData", 10)) {
            VillagerData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("VillagerData")).resultOrPartial(arg_0 -> ((Logger)CobbleDollars.INSTANCE.getLOGGER()).error(arg_0)).ifPresent(arg_0 -> CobbleMerchant.readAdditionalSaveData$lambda$2((Function1)new Function1<VillagerData, Unit>((Object)this){

                public final void invoke(VillagerData p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((CobbleMerchant)this.receiver).setVillagerData(p0);
                }
            }, arg_0));
        }
        if (compound.contains("CobbleMerchantShop", 9)) {
            RegistryAccess registryAccess = this.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            this.setShop(CompoundTagExtensionKt.getShop(compound, registryAccess));
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @NotNull
    public VillagerData getVillagerData() {
        Object object = this.entityData.get(DATA_VILLAGER_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (VillagerData)object;
    }

    public void setVillagerData(@NotNull VillagerData villagerData) {
        Intrinsics.checkNotNullParameter((Object)villagerData, (String)"villagerData");
        this.entityData.set(DATA_VILLAGER_DATA, (Object)villagerData);
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.VILLAGER_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"VILLAGER_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        SoundEvent soundEvent = SoundEvents.VILLAGER_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"VILLAGER_HURT");
        return soundEvent;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        if (spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.SPAWNER || spawnType == MobSpawnType.DISPENSER || spawnType == MobSpawnType.STRUCTURE) {
            this.setVillagerData(this.getVillagerData().setType(VillagerType.byBiome((Holder)level.getBiome(this.blockPosition()))).setProfession(CobbleDollarsProfessions.COBBLE_MERCHANT));
            if ((double)this.random.nextFloat() < 2.0E-4) {
                Shop easterEggShop = new Shop();
                Category easterEggCategory = new Category("Easter Egg", new ArrayList<Offer>());
                ItemStack authorPlayerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                authorPlayerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(new GameProfile(UUID.fromString("15c43c0b-bd8a-4637-a9ac-682ec8240b97"), "Harmex")));
                easterEggCategory.getOffers().add(new Offer(authorPlayerHead, 1000000));
                easterEggShop.add(easterEggCategory);
                this.setShop(easterEggShop);
            }
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    private static final Unit addAdditionalSaveData$lambda$0(CompoundTag $compound, Tag it) {
        Intrinsics.checkNotNullParameter((Object)$compound, (String)"$compound");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $compound.put("VillagerData", it);
        return Unit.INSTANCE;
    }

    private static final void addAdditionalSaveData$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void readAdditionalSaveData$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(CobbleMerchant.class, (EntityDataSerializer)EntityDataSerializers.VILLAGER_DATA);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_VILLAGER_DATA = entityDataAccessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lfr/harmex/cobbledollars/common/world/entity/CobbleMerchant$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "createAttributes", "()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/world/entity/npc/VillagerData;", "DATA_VILLAGER_DATA", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "getDATA_VILLAGER_DATA", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "cobbledollars-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<VillagerData> getDATA_VILLAGER_DATA() {
            return DATA_VILLAGER_DATA;
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = PathfinderMob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

