/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.world;

import com.cobblemon.mod.common.world.CobblemonStructures;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000e\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR8\u0010\u0012\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\f0\f \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\f0\f\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001f\u0010\u0018\u001a\n \u0011*\u0004\u0018\u00010\u00170\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001f\u0010\u001c\u001a\n \u0011*\u0004\u0018\u00010\u00170\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u001bR\u001f\u0010\u001e\u001a\n \u0011*\u0004\u0018\u00010\u00170\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001f\u0010\u001bR\u001f\u0010 \u001a\n \u0011*\u0004\u0018\u00010\u00170\u00178\u0006\u00a2\u0006\f\n\u0004\b \u0010\u0019\u001a\u0004\b!\u0010\u001bR\u001f\u0010\"\u001a\n \u0011*\u0004\u0018\u00010\u00170\u00178\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u0019\u001a\u0004\b#\u0010\u001b\u00a8\u0006$"}, d2={"Lfr/harmex/cobbledollars/common/world/CobbleDollarsStructures;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "register", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;", "templatePoolRegistry", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureProcessorList;", "processorListRegistry", "addCobbleMerchants", "(Lnet/minecraft/core/Registry;Lnet/minecraft/core/Registry;)V", "Lnet/minecraft/resources/ResourceKey;", "kotlin.jvm.PlatformType", "EMPTY_PROCESSOR_LIST_KEY", "Lnet/minecraft/resources/ResourceKey;", "", "COBBLE_MERCHANT_WEIGHT", "I", "Lnet/minecraft/resources/ResourceLocation;", "desertVillagersPoolLocation", "Lnet/minecraft/resources/ResourceLocation;", "getDesertVillagersPoolLocation", "()Lnet/minecraft/resources/ResourceLocation;", "plainsVillagersPoolLocation", "getPlainsVillagersPoolLocation", "savannaVillagersPoolLocation", "getSavannaVillagersPoolLocation", "snowyVillagersPoolLocation", "getSnowyVillagersPoolLocation", "taigaVillagersPoolLocation", "getTaigaVillagersPoolLocation", "cobbledollars-common"})
public final class CobbleDollarsStructures {
    @NotNull
    public static final CobbleDollarsStructures INSTANCE = new CobbleDollarsStructures();
    private static final ResourceKey<StructureProcessorList> EMPTY_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty"));
    private static final int COBBLE_MERCHANT_WEIGHT = 1;
    private static final ResourceLocation desertVillagersPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/desert/villagers");
    private static final ResourceLocation plainsVillagersPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/plains/villagers");
    private static final ResourceLocation savannaVillagersPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/savanna/villagers");
    private static final ResourceLocation snowyVillagersPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/snowy/villagers");
    private static final ResourceLocation taigaVillagersPoolLocation = ResourceLocation.withDefaultNamespace((String)"village/taiga/villagers");

    private CobbleDollarsStructures() {
    }

    public final ResourceLocation getDesertVillagersPoolLocation() {
        return desertVillagersPoolLocation;
    }

    public final ResourceLocation getPlainsVillagersPoolLocation() {
        return plainsVillagersPoolLocation;
    }

    public final ResourceLocation getSavannaVillagersPoolLocation() {
        return savannaVillagersPoolLocation;
    }

    public final ResourceLocation getSnowyVillagersPoolLocation() {
        return snowyVillagersPoolLocation;
    }

    public final ResourceLocation getTaigaVillagersPoolLocation() {
        return taigaVillagersPoolLocation;
    }

    public final void register(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Registry templatePoolRegistry = server.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        Registry processorListRegistry = server.registryAccess().registryOrThrow(Registries.PROCESSOR_LIST);
        Intrinsics.checkNotNull((Object)templatePoolRegistry);
        Intrinsics.checkNotNull((Object)processorListRegistry);
        this.addCobbleMerchants((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry);
    }

    private final void addCobbleMerchants(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry) {
        ResourceLocation resourceLocation = plainsVillagersPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"plainsVillagersPoolLocation");
        ResourceLocation resourceLocation2 = MiscUtilsKt.cobbleDollarsResource("cobble_merchant");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"cobbleDollarsResource(...)");
        ResourceKey<StructureProcessorList> resourceKey = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default((CobblemonStructures)CobblemonStructures.INSTANCE, templatePoolRegistry, processorListRegistry, (ResourceLocation)resourceLocation, (ResourceLocation)resourceLocation2, (int)1, (StructureTemplatePool.Projection)StructureTemplatePool.Projection.RIGID, resourceKey, (boolean)false, (int)128, null);
        ResourceLocation resourceLocation3 = desertVillagersPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"desertVillagersPoolLocation");
        ResourceLocation resourceLocation4 = MiscUtilsKt.cobbleDollarsResource("cobble_merchant");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"cobbleDollarsResource(...)");
        ResourceKey<StructureProcessorList> resourceKey2 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey2, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default((CobblemonStructures)CobblemonStructures.INSTANCE, templatePoolRegistry, processorListRegistry, (ResourceLocation)resourceLocation3, (ResourceLocation)resourceLocation4, (int)1, (StructureTemplatePool.Projection)StructureTemplatePool.Projection.RIGID, resourceKey2, (boolean)false, (int)128, null);
        ResourceLocation resourceLocation5 = savannaVillagersPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation5, (String)"savannaVillagersPoolLocation");
        ResourceLocation resourceLocation6 = MiscUtilsKt.cobbleDollarsResource("cobble_merchant");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"cobbleDollarsResource(...)");
        ResourceKey<StructureProcessorList> resourceKey3 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey3, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default((CobblemonStructures)CobblemonStructures.INSTANCE, templatePoolRegistry, processorListRegistry, (ResourceLocation)resourceLocation5, (ResourceLocation)resourceLocation6, (int)1, (StructureTemplatePool.Projection)StructureTemplatePool.Projection.RIGID, resourceKey3, (boolean)false, (int)128, null);
        ResourceLocation resourceLocation7 = snowyVillagersPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation7, (String)"snowyVillagersPoolLocation");
        ResourceLocation resourceLocation8 = MiscUtilsKt.cobbleDollarsResource("cobble_merchant");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation8, (String)"cobbleDollarsResource(...)");
        ResourceKey<StructureProcessorList> resourceKey4 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey4, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default((CobblemonStructures)CobblemonStructures.INSTANCE, templatePoolRegistry, processorListRegistry, (ResourceLocation)resourceLocation7, (ResourceLocation)resourceLocation8, (int)1, (StructureTemplatePool.Projection)StructureTemplatePool.Projection.RIGID, resourceKey4, (boolean)false, (int)128, null);
        ResourceLocation resourceLocation9 = taigaVillagersPoolLocation;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation9, (String)"taigaVillagersPoolLocation");
        ResourceLocation resourceLocation10 = MiscUtilsKt.cobbleDollarsResource("cobble_merchant");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation10, (String)"cobbleDollarsResource(...)");
        ResourceKey<StructureProcessorList> resourceKey5 = EMPTY_PROCESSOR_LIST_KEY;
        Intrinsics.checkNotNullExpressionValue(resourceKey5, (String)"EMPTY_PROCESSOR_LIST_KEY");
        CobblemonStructures.addBuildingToPool$default((CobblemonStructures)CobblemonStructures.INSTANCE, templatePoolRegistry, processorListRegistry, (ResourceLocation)resourceLocation9, (ResourceLocation)resourceLocation10, (int)1, (StructureTemplatePool.Projection)StructureTemplatePool.Projection.RIGID, resourceKey5, (boolean)false, (int)128, null);
    }
}

