/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.utils.extensions;

import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.s2c.SyncShopPacket;
import fr.harmex.cobbledollars.common.utils.CobbleDollarsPlayer;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.world.entity.ClientSideCobbleMerchant;
import fr.harmex.cobbledollars.common.world.inventory.BankMenu;
import fr.harmex.cobbledollars.common.world.inventory.ShopMenu;
import fr.harmex.cobbledollars.common.world.item.trading.ICobbleMerchant;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.OptionalInt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0019\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0019\u0010\b\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\u0007\u001a\u0019\u0010\n\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001b\u0010\u000e\u001a\u00020\r*\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0019\u0010\u0013\u001a\u00020\u0012*\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001b\u0010\u0017\u001a\u00020\u0005*\u00020\u00002\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0019\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019*\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lnet/minecraft/world/entity/player/Player;", "Ljava/math/BigInteger;", "getCobbleDollars", "(Lnet/minecraft/world/entity/player/Player;)Ljava/math/BigInteger;", "amount", "", "setCobbleDollars", "(Lnet/minecraft/world/entity/player/Player;Ljava/math/BigInteger;)V", "addCobbleDollars", "unitPrice", "getMaxAmountPurchasable", "(Lnet/minecraft/world/entity/player/Player;Ljava/math/BigInteger;)Ljava/math/BigInteger;", "price", "", "canBuy", "(Lnet/minecraft/world/entity/player/Player;Ljava/math/BigInteger;)Z", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "", "getMaxAmountObtainable", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)I", "Lfr/harmex/cobbledollars/common/world/item/trading/ICobbleMerchant;", "cobbleMerchant", "openShop", "(Lnet/minecraft/world/entity/player/Player;Lfr/harmex/cobbledollars/common/world/item/trading/ICobbleMerchant;)V", "Ljava/util/OptionalInt;", "kotlin.jvm.PlatformType", "openBank", "(Lnet/minecraft/world/entity/player/Player;)Ljava/util/OptionalInt;", "cobbledollars-common"})
public final class PlayerExtensionKt {
    @NotNull
    public static final BigInteger getCobbleDollars(@NotNull Player $this$getCobbleDollars) {
        Intrinsics.checkNotNullParameter((Object)$this$getCobbleDollars, (String)"<this>");
        return ((CobbleDollarsPlayer)$this$getCobbleDollars).cobbleDollars$getCobbleDollars();
    }

    public static final void setCobbleDollars(@NotNull Player $this$setCobbleDollars, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$setCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        ((CobbleDollarsPlayer)$this$setCobbleDollars).cobbleDollars$setCobbleDollars(amount);
    }

    public static final void addCobbleDollars(@NotNull Player $this$addCobbleDollars, @NotNull BigInteger amount) {
        Intrinsics.checkNotNullParameter((Object)$this$addCobbleDollars, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        ((CobbleDollarsPlayer)$this$addCobbleDollars).cobbleDollars$addCobbleDollars(amount);
    }

    @NotNull
    public static final BigInteger getMaxAmountPurchasable(@NotNull Player $this$getMaxAmountPurchasable, @NotNull BigInteger unitPrice) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$getMaxAmountPurchasable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unitPrice, (String)"unitPrice");
        if (Intrinsics.areEqual((Object)unitPrice, (Object)BigInteger.ZERO)) {
            bigInteger = new BigInteger("9999");
        } else {
            BigInteger bigInteger2 = PlayerExtensionKt.getCobbleDollars($this$getMaxAmountPurchasable).divide(unitPrice);
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"divide(...)");
        }
        return bigInteger;
    }

    public static final boolean canBuy(@NotNull Player $this$canBuy, @Nullable BigInteger price) {
        Intrinsics.checkNotNullParameter((Object)$this$canBuy, (String)"<this>");
        return price != null && PlayerExtensionKt.getCobbleDollars($this$canBuy).compareTo(price) >= 0;
    }

    public static final int getMaxAmountObtainable(@NotNull Player $this$getMaxAmountObtainable, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxAmountObtainable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int spaceAvailable = 0;
        Iterator iterator = $this$getMaxAmountObtainable.getInventory().items.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ItemStack slotStack = (ItemStack)iterator2.next();
            if (Intrinsics.areEqual((Object)slotStack, (Object)ItemStack.EMPTY)) {
                spaceAvailable += itemStack.getMaxStackSize();
            }
            if (!Intrinsics.areEqual((Object)slotStack.getItem(), (Object)itemStack.getItem()) || !Intrinsics.areEqual((Object)slotStack.getComponents(), (Object)itemStack.getComponents())) continue;
            spaceAvailable += itemStack.getMaxStackSize() - slotStack.getCount();
        }
        return spaceAvailable;
    }

    public static final void openShop(@NotNull Player $this$openShop, @NotNull ICobbleMerchant cobbleMerchant) {
        Intrinsics.checkNotNullParameter((Object)$this$openShop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cobbleMerchant, (String)"cobbleMerchant");
        $this$openShop.openMenu((MenuProvider)new SimpleMenuProvider((arg_0, arg_1, arg_2) -> PlayerExtensionKt.openShop$lambda$0(cobbleMerchant, arg_0, arg_1, arg_2), (Component)MiscUtilsKt.cobbleDollarsScreen("shop"))).ifPresent(arg_0 -> PlayerExtensionKt.openShop$lambda$1($this$openShop, cobbleMerchant, arg_0));
    }

    public static /* synthetic */ void openShop$default(Player player, ICobbleMerchant iCobbleMerchant, int n, Object object) {
        if ((n & 1) != 0) {
            iCobbleMerchant = new ClientSideCobbleMerchant();
        }
        PlayerExtensionKt.openShop(player, iCobbleMerchant);
    }

    public static final OptionalInt openBank(@NotNull Player $this$openBank) {
        Intrinsics.checkNotNullParameter((Object)$this$openBank, (String)"<this>");
        return $this$openBank.openMenu((MenuProvider)new SimpleMenuProvider(BankMenu::new, (Component)MiscUtilsKt.cobbleDollarsScreen("bank")));
    }

    private static final AbstractContainerMenu openShop$lambda$0(ICobbleMerchant $cobbleMerchant, int containerId, Inventory playerInventory, Player player) {
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        Intrinsics.checkNotNull((Object)playerInventory);
        return new ShopMenu(containerId, playerInventory, null, $cobbleMerchant, 4, null);
    }

    private static final void openShop$lambda$1(Player $this_openShop, ICobbleMerchant $cobbleMerchant, int it) {
        Intrinsics.checkNotNullParameter((Object)$this_openShop, (String)"$this_openShop");
        Intrinsics.checkNotNullParameter((Object)$cobbleMerchant, (String)"$cobbleMerchant");
        CobbleDollarsNetwork.INSTANCE.sendPacket((ServerPlayer)$this_openShop, new SyncShopPacket(it, $cobbleMerchant.getShop()));
    }
}

