/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.utils.extensions.BigIntegerExtensionsKt;
import java.math.BigInteger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001f\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "Lcom/mojang/brigadier/arguments/ArgumentType;", "Ljava/math/BigInteger;", "min", "max", "<init>", "(Ljava/math/BigInteger;Ljava/math/BigInteger;)V", "Lcom/mojang/brigadier/StringReader;", "reader", "parse", "(Lcom/mojang/brigadier/StringReader;)Ljava/math/BigInteger;", "", "", "getExamples", "()Ljava/util/Collection;", "Ljava/math/BigInteger;", "getMin", "()Ljava/math/BigInteger;", "getMax", "Companion", "cobbledollars-common"})
public final class BigIntegerArgumentType
implements ArgumentType<BigInteger> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BigInteger min;
    @Nullable
    private final BigInteger max;
    @NotNull
    private static final Collection<String> EXAMPLES;
    @NotNull
    private static final Dynamic2CommandExceptionType BIG_INT_TOO_SMALL;
    @NotNull
    private static final Dynamic2CommandExceptionType BIG_INT_TOO_BIG;

    public BigIntegerArgumentType(@Nullable BigInteger min, @Nullable BigInteger max) {
        this.min = min;
        this.max = max;
    }

    public /* synthetic */ BigIntegerArgumentType(BigInteger bigInteger, BigInteger bigInteger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bigInteger = null;
        }
        if ((n & 2) != 0) {
            bigInteger2 = null;
        }
        this(bigInteger, bigInteger2);
    }

    @Nullable
    public final BigInteger getMin() {
        return this.min;
    }

    @Nullable
    public final BigInteger getMax() {
        return this.max;
    }

    @NotNull
    public BigInteger parse(@NotNull StringReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        int start = reader.getCursor();
        BigInteger bigInteger = BigIntegerExtensionsKt.readBigInt(reader);
        Intrinsics.checkNotNull((Object)bigInteger);
        BigInteger result = bigInteger;
        if (this.min != null && result.compareTo(this.min) < 0) {
            reader.setCursor(start);
            throw BIG_INT_TOO_SMALL.createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.min);
        }
        if (this.max != null && result.compareTo(this.max) > 0) {
            reader.setCursor(start);
            throw BIG_INT_TOO_BIG.createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.max);
        }
        return result;
    }

    @NotNull
    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static final Message BIG_INT_TOO_SMALL$lambda$0(Object result, Object min) {
        Object[] objectArray = new Object[]{min, result};
        return (Message)MiscUtilsKt.cobbleDollarsArgument("big_integer.low", objectArray);
    }

    private static final Message BIG_INT_TOO_BIG$lambda$1(Object result, Object max) {
        Object[] objectArray = new Object[]{max, result};
        return (Message)MiscUtilsKt.cobbleDollarsArgument("big_integer.big", objectArray);
    }

    public BigIntegerArgumentType() {
        this(null, null, 3, null);
    }

    static {
        Object[] objectArray = new String[]{"0", "123456789", "-987654321"};
        EXAMPLES = CollectionsKt.listOf((Object[])objectArray);
        BIG_INT_TOO_SMALL = new Dynamic2CommandExceptionType(BigIntegerArgumentType::BIG_INT_TOO_SMALL$lambda$0);
        BIG_INT_TOO_BIG = new Dynamic2CommandExceptionType(BigIntegerArgumentType::BIG_INT_TOO_BIG$lambda$1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\rJ\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\u000eJ\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u000fJ\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u0010J)\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00070\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!\u00a8\u0006$"}, d2={"Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType$Companion;", "", "<init>", "()V", "Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "bigInt", "()Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "Ljava/math/BigInteger;", "min", "(Ljava/math/BigInteger;)Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "", "(I)Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "max", "(Ljava/math/BigInteger;Ljava/math/BigInteger;)Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "(ILjava/math/BigInteger;)Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "(Ljava/math/BigInteger;I)Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "(II)Lfr/harmex/cobbledollars/common/command/arguments/BigIntegerArgumentType;", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "name", "kotlin.jvm.PlatformType", "getBigInteger", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/math/BigInteger;", "", "EXAMPLES", "Ljava/util/Collection;", "getEXAMPLES", "()Ljava/util/Collection;", "Lcom/mojang/brigadier/exceptions/Dynamic2CommandExceptionType;", "BIG_INT_TOO_SMALL", "Lcom/mojang/brigadier/exceptions/Dynamic2CommandExceptionType;", "getBIG_INT_TOO_SMALL", "()Lcom/mojang/brigadier/exceptions/Dynamic2CommandExceptionType;", "BIG_INT_TOO_BIG", "getBIG_INT_TOO_BIG", "cobbledollars-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Collection<String> getEXAMPLES() {
            return EXAMPLES;
        }

        @NotNull
        public final Dynamic2CommandExceptionType getBIG_INT_TOO_SMALL() {
            return BIG_INT_TOO_SMALL;
        }

        @NotNull
        public final Dynamic2CommandExceptionType getBIG_INT_TOO_BIG() {
            return BIG_INT_TOO_BIG;
        }

        @NotNull
        public final BigIntegerArgumentType bigInt() {
            return new BigIntegerArgumentType(null, null, 3, null);
        }

        @NotNull
        public final BigIntegerArgumentType bigInt(@NotNull BigInteger min) {
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            return new BigIntegerArgumentType(min, null, 2, null);
        }

        @NotNull
        public final BigIntegerArgumentType bigInt(int min) {
            BigInteger bigInteger = BigInteger.valueOf(min);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            return this.bigInt(bigInteger);
        }

        @NotNull
        public final BigIntegerArgumentType bigInt(@NotNull BigInteger min, @NotNull BigInteger max) {
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            return new BigIntegerArgumentType(min, max);
        }

        @NotNull
        public final BigIntegerArgumentType bigInt(int min, @NotNull BigInteger max) {
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            BigInteger bigInteger = BigInteger.valueOf(min);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            return this.bigInt(bigInteger, max);
        }

        @NotNull
        public final BigIntegerArgumentType bigInt(@NotNull BigInteger min, int max) {
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            BigInteger bigInteger = BigInteger.valueOf(max);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            return this.bigInt(min, bigInteger);
        }

        @NotNull
        public final BigIntegerArgumentType bigInt(int min, int max) {
            BigInteger bigInteger = BigInteger.valueOf(min);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            BigInteger bigInteger2 = BigInteger.valueOf(max);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
            return this.bigInt(bigInteger, bigInteger2);
        }

        public final BigInteger getBigInteger(@NotNull CommandContext<?> context, @NotNull String name) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return (BigInteger)context.getArgument(name, BigInteger.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

