/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobbledollars.common.client.gui.screen;

import fr.harmex.cobbledollars.common.client.gui.screen.widget.SellButton;
import fr.harmex.cobbledollars.common.client.utils.Context;
import fr.harmex.cobbledollars.common.client.utils.GuiUtilsKt;
import fr.harmex.cobbledollars.common.network.CobbleDollarsNetwork;
import fr.harmex.cobbledollars.common.network.packets.c2s.SellPacket;
import fr.harmex.cobbledollars.common.utils.MiscUtilsKt;
import fr.harmex.cobbledollars.common.world.inventory.BankMenu;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\rJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001f\u0010\rJ\u0017\u0010\"\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u001f\u0010&\u001a\n %*\u0004\u0018\u00010$0$8\u0006\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\"\u0010*\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010+\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\"\u00104\u001a\u0002038\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b4\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109R.\u0010<\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00140:8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR*\u0010C\u001a\n %*\u0004\u0018\u00010B0B8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010D\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\u00a8\u0006I"}, d2={"Lfr/harmex/cobbledollars/common/client/gui/screen/BankScreen;", "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;", "Lfr/harmex/cobbledollars/common/world/inventory/BankMenu;", "Lnet/minecraft/world/ContainerListener;", "menu", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "Lnet/minecraft/network/chat/Component;", "title", "<init>", "(Lfr/harmex/cobbledollars/common/world/inventory/BankMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "", "init", "()V", "sell", "", "canSell", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "mouseX", "mouseY", "renderLabels", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "", "partialTick", "renderBg", "(Lnet/minecraft/client/gui/GuiGraphics;FII)V", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "onClose", "Lnet/minecraft/world/Container;", "container", "containerChanged", "(Lnet/minecraft/world/Container;)V", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "bgLocation", "Lnet/minecraft/resources/ResourceLocation;", "getBgLocation", "()Lnet/minecraft/resources/ResourceLocation;", "x", "I", "getX", "()I", "setX", "(I)V", "y", "getY", "setY", "Lfr/harmex/cobbledollars/common/client/gui/screen/widget/SellButton;", "sellButton", "Lfr/harmex/cobbledollars/common/client/gui/screen/widget/SellButton;", "getSellButton", "()Lfr/harmex/cobbledollars/common/client/gui/screen/widget/SellButton;", "setSellButton", "(Lfr/harmex/cobbledollars/common/client/gui/screen/widget/SellButton;)V", "", "Lnet/minecraft/world/item/ItemStack;", "itemsToSell", "Ljava/util/Map;", "getItemsToSell", "()Ljava/util/Map;", "setItemsToSell", "(Ljava/util/Map;)V", "Ljava/math/BigInteger;", "sellPrice", "Ljava/math/BigInteger;", "getSellPrice", "()Ljava/math/BigInteger;", "setSellPrice", "(Ljava/math/BigInteger;)V", "cobbledollars-common"})
public final class BankScreen
extends AbstractContainerScreen<BankMenu>
implements ContainerListener {
    private final ResourceLocation bgLocation;
    private int x;
    private int y;
    public SellButton sellButton;
    @NotNull
    private Map<ItemStack, Integer> itemsToSell;
    private BigInteger sellPrice;

    public BankScreen(@NotNull BankMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.bgLocation = MiscUtilsKt.cobbleDollarsResource("textures/gui/bank/bank_base.png");
        this.itemsToSell = new HashMap();
        this.sellPrice = BigInteger.ZERO;
        this.imageWidth = 170;
        this.imageHeight = 204;
        menu.getBankContainer().addListener((ContainerListener)this);
    }

    public final ResourceLocation getBgLocation() {
        return this.bgLocation;
    }

    public final int getX() {
        return this.x;
    }

    public final void setX(int n) {
        this.x = n;
    }

    public final int getY() {
        return this.y;
    }

    public final void setY(int n) {
        this.y = n;
    }

    @NotNull
    public final SellButton getSellButton() {
        SellButton sellButton = this.sellButton;
        if (sellButton != null) {
            return sellButton;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sellButton");
        return null;
    }

    public final void setSellButton(@NotNull SellButton sellButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)sellButton), (String)"<set-?>");
        this.sellButton = sellButton;
    }

    @NotNull
    public final Map<ItemStack, Integer> getItemsToSell() {
        return this.itemsToSell;
    }

    public final void setItemsToSell(@NotNull Map<ItemStack, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.itemsToSell = map;
    }

    public final BigInteger getSellPrice() {
        return this.sellPrice;
    }

    public final void setSellPrice(BigInteger bigInteger) {
        this.sellPrice = bigInteger;
    }

    protected void init() {
        this.x = (this.width - this.imageWidth) / 2;
        this.y = (this.height - this.imageHeight) / 2;
        this.setSellButton(new SellButton(this.x + this.imageWidth / 2 - 43, this.y + 1, this, arg_0 -> BankScreen.init$lambda$0(this, arg_0)));
        this.addRenderableWidget((GuiEventListener)this.getSellButton());
        super.init();
    }

    public final void sell() {
        if (this.canSell()) {
            BigInteger bigInteger = this.sellPrice;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"sellPrice");
            CobbleDollarsNetwork.INSTANCE.sendToServer(new SellPacket(this.itemsToSell, bigInteger));
        }
    }

    public final boolean canSell() {
        return !Intrinsics.areEqual((Object)this.sellPrice, (Object)BigInteger.ZERO);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        this.x = (this.width - this.imageWidth) / 2;
        this.y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.bgLocation, this.x, this.y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        GuiUtilsKt.renderCobbleDollarsElement$default(guiGraphics, this.x + this.imageWidth / 2 - 27, this.y + this.imageHeight - 15, null, false, null, 20, null);
        int n = this.x + this.imageWidth / 2 - 11;
        BigInteger bigInteger = this.sellPrice;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"sellPrice");
        GuiUtilsKt.renderCobbleDollarsElement$default(guiGraphics, n, this.y + 1, bigInteger, false, Context.BANK, 8, null);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void onClose() {
        ((BankMenu)this.menu).getBankContainer().removeListener((ContainerListener)this);
        super.onClose();
    }

    public void containerChanged(@NotNull Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        SimpleContainer cfr_ignored_0 = (SimpleContainer)container;
        this.itemsToSell = MiscUtilsKt.getItemsToSell((SimpleContainer)container);
        this.sellPrice = MiscUtilsKt.getTotalBankPrice((SimpleContainer)container);
    }

    private static final void init$lambda$0(BankScreen this$0, Button it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sell();
    }
}

