/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderRegistry;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinEditBox;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorHistory;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.formattingrules.TextEditorFormattingRules;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollbar.ScrollBar;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class TextEditorScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final CharacterFilter characterFilter;
    protected final Consumer<String> callback;
    protected List<TextEditorLine> textFieldLines = new ArrayList<TextEditorLine>();
    protected ScrollBar verticalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    protected ScrollBar horizontalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    protected ScrollBar verticalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    protected ScrollBar horizontalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    protected ContextMenu rightClickContextMenu;
    protected ExtendedButton cancelButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton placeholderButton;
    protected int lastCursorPosSetByUser = 0;
    protected boolean justSwitchedLineByWordDeletion = false;
    protected boolean triggeredFocusedLineWasTooHighInCursorPosMethod = false;
    protected int headerHeight = 50;
    protected int footerHeight = 50;
    protected int borderLeft = 40;
    protected int borderRight = 20;
    protected int lineHeight = 14;
    protected Color screenBackgroundColor;
    protected Color editorAreaBorderColor;
    protected Color editorAreaBackgroundColor;
    protected Color textColor;
    protected Color focusedLineColor;
    protected Color scrollGrabberIdleColor;
    protected Color scrollGrabberHoverColor;
    protected Color sideBarColor;
    protected Color lineNumberTextColorNormal;
    protected Color lineNumberTextColorFocused;
    protected Color multilineNotSupportedNotificationColor;
    protected Color placeholderEntryBackgroundColorIdle;
    protected Color placeholderEntryBackgroundColorHover;
    protected Color placeholderEntryDotColorPlaceholder;
    protected Color placeholderEntryDotColorCategory;
    protected Color placeholderEntryLabelColor;
    protected Color placeholderEntryBackToCategoriesLabelColor;
    protected int currentLineWidth;
    protected int lastTickFocusedLineIndex;
    protected TextEditorLine startHighlightLine;
    protected int startHighlightLineIndex;
    protected int endHighlightLineIndex;
    protected int overriddenTotalScrollHeight;
    protected List<Runnable> lineNumberRenderQueue;
    public List<TextEditorFormattingRule> formattingRules;
    protected int currentRenderCharacterIndexTotal;
    protected static boolean extendedPlaceholderMenu = false;
    protected int placeholderMenuWidth;
    protected int placeholderMenuEntryHeight;
    protected List<PlaceholderMenuEntry> placeholderMenuEntries;
    protected boolean multilineMode;
    protected boolean allowPlaceholders;
    protected long multilineNotSupportedNotificationDisplayStart;
    protected boolean boldTitle;
    protected ConsumingSupplier<TextEditorScreen, Boolean> textValidator;
    protected Tooltip textValidatorFeedbackTooltip;
    protected boolean selectedHoveredOnRightClickMenuOpen;
    protected final TextEditorHistory history;

    @NotNull
    public static TextEditorScreen build(@Nullable Component title, @Nullable CharacterFilter characterFilter, @NotNull Consumer<String> callback) {
        return new TextEditorScreen(title, characterFilter, callback);
    }

    public TextEditorScreen(@Nullable CharacterFilter characterFilter, @NotNull Consumer<String> callback) {
        this(null, characterFilter, callback);
    }

    public TextEditorScreen(@Nullable Component title, @Nullable CharacterFilter characterFilter, @NotNull Consumer<String> callback) {
        super((Component)(title != null ? title : Component.literal((String)"")));
        this.screenBackgroundColor = UIBase.getUIColorTheme().screen_background_color.getColor();
        this.editorAreaBorderColor = UIBase.getUIColorTheme().element_border_color_normal.getColor();
        this.editorAreaBackgroundColor = UIBase.getUIColorTheme().area_background_color.getColor();
        this.textColor = UIBase.getUIColorTheme().text_editor_text_color.getColor();
        this.focusedLineColor = UIBase.getUIColorTheme().list_entry_color_selected_hovered.getColor();
        this.scrollGrabberIdleColor = UIBase.getUIColorTheme().scroll_grabber_color_normal.getColor();
        this.scrollGrabberHoverColor = UIBase.getUIColorTheme().scroll_grabber_color_hover.getColor();
        this.sideBarColor = UIBase.getUIColorTheme().text_editor_sidebar_color.getColor();
        this.lineNumberTextColorNormal = UIBase.getUIColorTheme().text_editor_line_number_text_color_normal.getColor();
        this.lineNumberTextColorFocused = UIBase.getUIColorTheme().text_editor_line_number_text_color_selected.getColor();
        this.multilineNotSupportedNotificationColor = UIBase.getUIColorTheme().error_text_color.getColor();
        this.placeholderEntryBackgroundColorIdle = UIBase.getUIColorTheme().area_background_color.getColor();
        this.placeholderEntryBackgroundColorHover = UIBase.getUIColorTheme().list_entry_color_selected_hovered.getColor();
        this.placeholderEntryDotColorPlaceholder = UIBase.getUIColorTheme().listing_dot_color_1.getColor();
        this.placeholderEntryDotColorCategory = UIBase.getUIColorTheme().listing_dot_color_2.getColor();
        this.placeholderEntryLabelColor = UIBase.getUIColorTheme().description_area_text_color.getColor();
        this.placeholderEntryBackToCategoriesLabelColor = UIBase.getUIColorTheme().warning_text_color.getColor();
        this.lastTickFocusedLineIndex = -1;
        this.startHighlightLine = null;
        this.startHighlightLineIndex = -1;
        this.endHighlightLineIndex = -1;
        this.overriddenTotalScrollHeight = -1;
        this.lineNumberRenderQueue = new ArrayList<Runnable>();
        this.formattingRules = new ArrayList<TextEditorFormattingRule>();
        this.currentRenderCharacterIndexTotal = 0;
        this.placeholderMenuWidth = 120;
        this.placeholderMenuEntryHeight = 16;
        this.placeholderMenuEntries = new ArrayList<PlaceholderMenuEntry>();
        this.multilineMode = true;
        this.allowPlaceholders = true;
        this.multilineNotSupportedNotificationDisplayStart = -1L;
        this.boldTitle = true;
        this.textValidator = null;
        this.textValidatorFeedbackTooltip = null;
        this.selectedHoveredOnRightClickMenuOpen = false;
        this.history = new TextEditorHistory(this);
        this.minecraft = Minecraft.getInstance();
        this.font = Minecraft.getInstance().font;
        this.characterFilter = characterFilter;
        this.callback = callback;
        this.addLine();
        this.getLine(0).setFocused(true);
        this.verticalScrollBar.setScrollWheelAllowed(true);
        this.verticalScrollBarPlaceholderMenu.setScrollWheelAllowed(true);
        this.formattingRules.addAll(TextEditorFormattingRules.getRules());
        this.updatePlaceholderEntries(null, true, true);
        this.updateCurrentLineWidth();
    }

    public void init() {
        this.updateRightClickContextMenu();
        this.addWidget(this.rightClickContextMenu);
        this.verticalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.verticalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.verticalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - 2;
        this.verticalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - this.horizontalScrollBar.grabberHeight - 2;
        this.horizontalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.horizontalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.horizontalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - this.verticalScrollBar.grabberWidth - 2;
        this.horizontalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - 1;
        int placeholderAreaX = this.width - this.borderRight - this.placeholderMenuWidth;
        int placeholderAreaY = this.getEditorAreaY();
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - 2;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - this.horizontalScrollBarPlaceholderMenu.grabberHeight - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - this.verticalScrollBarPlaceholderMenu.grabberWidth - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - 1;
        this.verticalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.verticalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.cancelButton = new ExtendedButton(this.width - this.borderRight - 100 - 5 - 100, this.height - 35, 100, 20, I18n.get((String)"fancymenu.guicomponents.cancel", (Object[])new Object[0]), button -> this.onClose());
        this.addWidget((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.doneButton = new ExtendedButton(this.width - this.borderRight - 100, this.height - 35, 100, 20, I18n.get((String)"fancymenu.guicomponents.done", (Object[])new Object[0]), button -> {
            if (this.isTextValid()) {
                this.callback.accept(this.getText());
            }
        });
        this.addWidget((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        if (this.allowPlaceholders) {
            this.placeholderButton = new ExtendedButton(this.width - this.borderRight - 100, this.headerHeight / 2 - 10, 100, 20, I18n.get((String)"fancymenu.ui.text_editor.placeholders", (Object[])new Object[0]), button -> {
                extendedPlaceholderMenu = !extendedPlaceholderMenu;
                this.rebuildWidgets();
            }).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.dynamicvariabletextfield.variables.desc", new String[0])).setDefaultStyle());
            this.addWidget((GuiEventListener)this.placeholderButton);
            UIBase.applyDefaultWidgetSkinTo(this.placeholderButton);
            if (extendedPlaceholderMenu) {
                this.placeholderButton.setBackgroundColor(UIBase.getUIColorTheme().element_background_color_normal, UIBase.getUIColorTheme().element_background_color_hover, UIBase.getUIColorTheme().element_background_color_normal, DrawableColor.of(this.editorAreaBorderColor), DrawableColor.of(this.editorAreaBorderColor), DrawableColor.of(this.editorAreaBorderColor));
                ((IMixinAbstractWidget)((Object)this.placeholderButton)).setHeightFancyMenu(this.getEditorAreaY() - (this.headerHeight / 2 - 10));
            }
        } else {
            this.placeholderButton = null;
            extendedPlaceholderMenu = false;
        }
    }

    public void updateRightClickContextMenu() {
        if (this.rightClickContextMenu != null) {
            this.rightClickContextMenu.closeMenu();
        }
        this.rightClickContextMenu = new ContextMenu();
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("copy", (Component)Component.translatable((String)"fancymenu.ui.text_editor.copy"), (menu, entry) -> {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlightedText());
            menu.closeMenu();
        }).setIsActiveSupplier((menu, entry) -> {
            if (!menu.isOpen()) {
                return false;
            }
            return this.selectedHoveredOnRightClickMenuOpen;
        })).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.copy"))).setIcon(ContextMenu.IconFactory.getIcon("copy"));
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("paste", (Component)Component.translatable((String)"fancymenu.ui.text_editor.paste"), (menu, entry) -> {
            this.pasteText(Minecraft.getInstance().keyboardHandler.getClipboard());
            menu.closeMenu();
        }).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.paste"))).setIcon(ContextMenu.IconFactory.getIcon("paste"));
        this.rightClickContextMenu.addSeparatorEntry("separator_after_paste");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("cut", (Component)Component.translatable((String)"fancymenu.ui.text_editor.cut"), (menu, entry) -> {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.cutHighlightedText());
            menu.closeMenu();
        }).setIsActiveSupplier((menu, entry) -> {
            if (!menu.isOpen()) {
                return false;
            }
            return this.selectedHoveredOnRightClickMenuOpen;
        })).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.cut"))).setIcon(ContextMenu.IconFactory.getIcon("cut"));
        this.rightClickContextMenu.addSeparatorEntry("separator_after_cut");
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("select_all", (Component)Component.translatable((String)"fancymenu.ui.text_editor.select_all"), (menu, entry) -> {
            for (TextEditorLine t : this.textFieldLines) {
                t.setHighlightPos(0);
                t.setCursorPosition(t.getValue().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            menu.closeMenu();
        }).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.select_all"))).setIcon(ContextMenu.IconFactory.getIcon("select"));
        this.rightClickContextMenu.addSeparatorEntry("separator_after_select_all");
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("undo", (Component)Component.translatable((String)"fancymenu.editor.edit.undo"), (menu, entry) -> this.history.stepBack()).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.undo"))).setIcon(ContextMenu.IconFactory.getIcon("undo"));
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("redo", (Component)Component.translatable((String)"fancymenu.editor.edit.redo"), (menu, entry) -> this.history.stepForward()).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.redo"))).setIcon(ContextMenu.IconFactory.getIcon("redo"));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.currentLineWidth <= this.getEditorAreaWidth()) {
            this.horizontalScrollBar.setScroll(0.0f);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
        this.justSwitchedLineByWordDeletion = false;
        this.updateCurrentLineWidth();
        this.verticalScrollBar.setWheelScrollSpeed(1.0f / ((float)this.getTotalScrollHeight() / 500.0f));
        this.renderScreenBackground(graphics);
        this.renderEditorAreaBackground(graphics);
        Window win = Minecraft.getInstance().getWindow();
        double scale = win.getGuiScale();
        int sciBottom = this.height - this.footerHeight;
        RenderSystem.enableScissor((int)((int)((double)this.borderLeft * scale)), (int)((int)((double)win.getHeight() - (double)sciBottom * scale)), (int)((int)((double)this.getEditorAreaWidth() * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
        this.formattingRules.forEach(rule -> rule.resetRule(this));
        this.currentRenderCharacterIndexTotal = 0;
        this.lineNumberRenderQueue.clear();
        this.updateLines(line -> {
            if (line.isInEditorArea()) {
                this.lineNumberRenderQueue.add(() -> this.renderLineNumber(graphics, (TextEditorLine)((Object)line)));
            }
            line.render(graphics, mouseX, mouseY, partial);
        });
        RenderSystem.disableScissor();
        this.renderLineNumberBackground(graphics, this.borderLeft);
        RenderSystem.enableScissor((int)0, (int)((int)((double)win.getHeight() - (double)sciBottom * scale)), (int)((int)((double)this.borderLeft * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
        for (Runnable r : this.lineNumberRenderQueue) {
            r.run();
        }
        RenderSystem.disableScissor();
        this.lastTickFocusedLineIndex = this.getFocusedLineIndex();
        this.triggeredFocusedLineWasTooHighInCursorPosMethod = false;
        UIBase.renderBorder(graphics, this.borderLeft - 1, this.headerHeight - 1, this.getEditorAreaX() + this.getEditorAreaWidth(), this.height - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
        this.verticalScrollBar.render(graphics);
        this.horizontalScrollBar.render(graphics);
        this.renderPlaceholderMenu(graphics, mouseX, mouseY, partial);
        this.cancelButton.render(graphics, mouseX, mouseY, partial);
        this.doneButton.active = this.isTextValid();
        this.doneButton.setTooltip(this.textValidatorFeedbackTooltip);
        this.doneButton.render(graphics, mouseX, mouseY, partial);
        this.renderMultilineNotSupportedNotification(graphics, mouseX, mouseY, partial);
        this.rightClickContextMenu.render(graphics, mouseX, mouseY, partial);
        this.tickMouseHighlighting();
        MutableComponent t = this.title.copy();
        t.setStyle(t.getStyle().withBold(Boolean.valueOf(this.boldTitle)));
        int n = this.headerHeight / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, (Component)t, this.borderLeft, n - 9 / 2, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
    }

    protected void renderMultilineNotSupportedNotification(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        long now = System.currentTimeMillis();
        if (!this.multilineMode && this.multilineNotSupportedNotificationDisplayStart + 3000L >= now) {
            int a = 255;
            int diff = (int)(this.multilineNotSupportedNotificationDisplayStart + 3000L - now);
            if (diff <= 1000) {
                float f = (float)diff / 1000.0f;
                a = Math.max(10, (int)(255.0f * f));
            }
            Color c = new Color(this.multilineNotSupportedNotificationColor.getRed(), this.multilineNotSupportedNotificationColor.getGreen(), this.multilineNotSupportedNotificationColor.getBlue(), a);
            String string = I18n.get((String)"fancymenu.ui.text_editor.error.multiline_support", (Object[])new Object[0]);
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, string, this.borderLeft, this.headerHeight - 9 - 5, c.getRGB(), false);
        }
    }

    protected void renderPlaceholderMenu(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (extendedPlaceholderMenu) {
            if (this.getTotalPlaceholderEntriesWidth() <= this.placeholderMenuWidth) {
                this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            if (this.getTotalPlaceholderEntriesHeight() <= this.getEditorAreaHeight()) {
                this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            graphics.fill(this.width - this.borderRight - this.placeholderMenuWidth, this.getEditorAreaY(), this.width - this.borderRight, this.getEditorAreaY() + this.getEditorAreaHeight(), this.editorAreaBackgroundColor.getRGB());
            Window win = Minecraft.getInstance().getWindow();
            double scale = win.getGuiScale();
            int sciBottom = this.height - this.footerHeight;
            RenderSystem.enableScissor((int)((int)((double)(this.width - this.borderRight - this.placeholderMenuWidth) * scale)), (int)((int)((double)win.getHeight() - (double)sciBottom * scale)), (int)((int)((double)this.placeholderMenuWidth * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
            ArrayList<PlaceholderMenuEntry> entries = new ArrayList<PlaceholderMenuEntry>();
            entries.addAll(this.placeholderMenuEntries);
            int index = 0;
            for (PlaceholderMenuEntry e : entries) {
                e.x = this.width - this.borderRight - this.placeholderMenuWidth + this.getPlaceholderEntriesRenderOffsetX();
                e.y = this.getEditorAreaY() + this.placeholderMenuEntryHeight * index + this.getPlaceholderEntriesRenderOffsetY();
                e.render(graphics, mouseX, mouseY, partial);
                ++index;
            }
            RenderSystem.disableScissor();
            UIBase.renderBorder(graphics, this.width - this.borderRight - this.placeholderMenuWidth - 1, this.headerHeight - 1, this.width - this.borderRight, this.height - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
            this.verticalScrollBarPlaceholderMenu.render(graphics);
            this.horizontalScrollBarPlaceholderMenu.render(graphics);
        }
        if (this.placeholderButton != null) {
            this.placeholderButton.render(graphics, mouseX, mouseY, partial);
        }
    }

    public int getTotalPlaceholderEntriesHeight() {
        return this.placeholderMenuEntryHeight * this.placeholderMenuEntries.size();
    }

    public int getTotalPlaceholderEntriesWidth() {
        int i = this.placeholderMenuWidth;
        for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
            if (e.getWidth() <= i) continue;
            i = e.getWidth();
        }
        return i;
    }

    public int getPlaceholderEntriesRenderOffsetX() {
        int totalScrollWidth = Math.max(0, this.getTotalPlaceholderEntriesWidth() - this.placeholderMenuWidth);
        return -((int)((float)totalScrollWidth / 100.0f * (this.horizontalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public int getPlaceholderEntriesRenderOffsetY() {
        int totalScrollHeight = Math.max(0, this.getTotalPlaceholderEntriesHeight() - this.getEditorAreaHeight());
        return -((int)((float)totalScrollHeight / 100.0f * (this.verticalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public void updatePlaceholderEntries(@Nullable String category, boolean clearList, boolean addBackButton) {
        List<Placeholder> otherCategory;
        Map<String, List<Placeholder>> categories;
        if (clearList) {
            this.placeholderMenuEntries.clear();
        }
        if (!(categories = this.getPlaceholdersOrderedByCategories()).isEmpty() && (otherCategory = categories.get(I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.other", (Object[])new Object[0]))) != null) {
            if (category == null) {
                for (Map.Entry<String, List<Placeholder>> m : categories.entrySet()) {
                    if (m.getValue() == otherCategory) continue;
                    PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, this, (Component)Component.literal((String)((String)m.getKey())), () -> this.updatePlaceholderEntries((String)m.getKey(), true, true));
                    entry.dotColor = this.placeholderEntryDotColorCategory;
                    entry.entryLabelColor = this.placeholderEntryLabelColor;
                    this.placeholderMenuEntries.add(entry);
                }
                this.updatePlaceholderEntries(I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.other", (Object[])new Object[0]), false, false);
            } else {
                List<Placeholder> placeholders;
                if (addBackButton) {
                    PlaceholderMenuEntry backToCategoriesEntry = new PlaceholderMenuEntry(this, this, (Component)Component.literal((String)I18n.get((String)"fancymenu.ui.text_editor.placeholders.back_to_categories", (Object[])new Object[0])), () -> this.updatePlaceholderEntries(null, true, true));
                    backToCategoriesEntry.dotColor = this.placeholderEntryDotColorCategory;
                    backToCategoriesEntry.entryLabelColor = this.placeholderEntryBackToCategoriesLabelColor;
                    this.placeholderMenuEntries.add(backToCategoriesEntry);
                }
                if ((placeholders = categories.get(category)) != null) {
                    for (Placeholder p : placeholders) {
                        PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, this, (Component)Component.literal((String)p.getDisplayName()), () -> this.pasteText(p.getDefaultPlaceholderString().toString()));
                        List<String> desc = p.getDescription();
                        if (desc != null) {
                            entry.setDescription(desc.toArray(new String[0]));
                        }
                        entry.dotColor = this.placeholderEntryDotColorPlaceholder;
                        entry.entryLabelColor = this.placeholderEntryLabelColor;
                        this.placeholderMenuEntries.add(entry);
                    }
                }
            }
            for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
                e.backgroundColorIdle = this.placeholderEntryBackgroundColorIdle;
                e.backgroundColorHover = this.placeholderEntryBackgroundColorHover;
            }
            this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
        }
    }

    protected Map<String, List<Placeholder>> getPlaceholdersOrderedByCategories() {
        LinkedHashMap<String, List<Placeholder>> categories = new LinkedHashMap<String, List<Placeholder>>();
        for (Placeholder p : PlaceholderRegistry.getPlaceholders()) {
            ArrayList<Placeholder> l;
            if (!p.shouldShowUpInPlaceholderMenu(LayoutEditorScreen.getCurrentInstance())) continue;
            String cat = p.getCategory();
            if (cat == null) {
                cat = I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.other", (Object[])new Object[0]);
            }
            if ((l = (ArrayList<Placeholder>)categories.get(cat)) == null) {
                l = new ArrayList<Placeholder>();
                categories.put(cat, l);
            }
            l.add(p);
        }
        List otherCategory = (List)categories.get(I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.other", (Object[])new Object[0]));
        if (otherCategory != null) {
            categories.remove(I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.other", (Object[])new Object[0]));
            categories.put(I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.other", (Object[])new Object[0]), otherCategory);
        }
        return categories;
    }

    protected void renderLineNumberBackground(GuiGraphics graphics, int width) {
        graphics.fill(this.getEditorAreaX(), this.getEditorAreaY() - 1, this.getEditorAreaX() - width - 1, this.getEditorAreaY() + this.getEditorAreaHeight() + 1, this.sideBarColor.getRGB());
    }

    protected void renderLineNumber(GuiGraphics graphics, TextEditorLine line) {
        String lineNumberString = "" + (line.lineIndex + 1);
        int lineNumberWidth = this.font.width(lineNumberString);
        int n = this.getEditorAreaX() - 3 - lineNumberWidth;
        int n2 = line.getY() + line.getHeight() / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, lineNumberString, n, n2 - 9 / 2, line.isFocused() ? this.lineNumberTextColorFocused.getRGB() : this.lineNumberTextColorNormal.getRGB(), false);
    }

    protected void renderEditorAreaBackground(GuiGraphics graphics) {
        graphics.fill(this.getEditorAreaX(), this.getEditorAreaY(), this.getEditorAreaX() + this.getEditorAreaWidth(), this.getEditorAreaY() + this.getEditorAreaHeight(), this.editorAreaBackgroundColor.getRGB());
    }

    protected void renderScreenBackground(GuiGraphics graphics) {
        graphics.fill(0, 0, this.width, this.height, this.screenBackgroundColor.getRGB());
    }

    protected void tickMouseHighlighting() {
        TextEditorLine focused;
        if (!MouseInput.isLeftMouseDown()) {
            this.startHighlightLine = null;
            for (TextEditorLine t : this.textFieldLines) {
                t.isInMouseHighlightingMode = false;
            }
            return;
        }
        if (this.isInMouseHighlightingMode()) {
            float f;
            int mX = MouseInput.getMouseX();
            int mY = MouseInput.getMouseY();
            float speedMult = 0.008f;
            if (mX < this.borderLeft) {
                f = Math.max(0.01f, (float)(this.borderLeft - mX) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() - f);
            } else if (mX > this.getEditorAreaX() + this.getEditorAreaWidth()) {
                f = Math.max(0.01f, (float)(mX - (this.getEditorAreaX() + this.getEditorAreaWidth())) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() + f);
            }
            if (mY < this.headerHeight) {
                f = Math.max(0.01f, (float)(this.headerHeight - mY) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() - f);
            } else if (mY > this.height - this.footerHeight) {
                f = Math.max(0.01f, (float)(mY - (this.height - this.footerHeight)) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() + f);
            }
        }
        if (!this.isMouseInsideEditorArea()) {
            return;
        }
        TextEditorLine first = this.startHighlightLine;
        TextEditorLine hovered = this.getHoveredLine();
        if (hovered != null && !hovered.isFocused() && first != null) {
            boolean firstIsAfterHovered;
            int firstIndex = this.getLineIndex(first);
            int hoveredIndex = this.getLineIndex(hovered);
            boolean firstIsBeforeHovered = hoveredIndex > firstIndex;
            boolean bl = firstIsAfterHovered = hoveredIndex < firstIndex;
            if (first.isInMouseHighlightingMode) {
                if (firstIsAfterHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.moveCursorTo(hovered.getValue().length(), false);
                    }
                } else if (firstIsBeforeHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.moveCursorTo(0, false);
                    }
                } else if (first == hovered) {
                    this.setFocusedLine(this.getLineIndex(first));
                }
            }
            int startIndex = Math.min(hoveredIndex, firstIndex);
            int endIndex = Math.max(hoveredIndex, firstIndex);
            int index = 0;
            for (TextEditorLine t : this.textFieldLines) {
                if (t != hovered && t != first) {
                    if (index > startIndex && index < endIndex) {
                        if (firstIsAfterHovered) {
                            t.setCursorPosition(0);
                            t.setHighlightPos(t.getValue().length());
                        } else if (firstIsBeforeHovered) {
                            t.setCursorPosition(t.getValue().length());
                            t.setHighlightPos(0);
                        }
                    } else {
                        t.moveCursorTo(0, false);
                        t.isInMouseHighlightingMode = false;
                    }
                }
                ++index;
            }
            this.startHighlightLineIndex = startIndex;
            this.endHighlightLineIndex = endIndex;
            if (first != hovered) {
                if (firstIsAfterHovered) {
                    first.moveCursorTo(0, true);
                } else if (firstIsBeforeHovered) {
                    first.moveCursorTo(first.getValue().length(), true);
                }
            }
        }
        if ((focused = this.getFocusedLine()) != null && focused.isInMouseHighlightingMode) {
            if (this.startHighlightLineIndex == -1 && this.endHighlightLineIndex == -1) {
                this.endHighlightLineIndex = this.startHighlightLineIndex = this.getLineIndex(focused);
            }
            int i = Mth.floor((float)MouseInput.getMouseX()) - focused.getX();
            if (focused.getAsAccessor().getBorderedFancyMenu()) {
                i -= 4;
            }
            String s = this.font.plainSubstrByWidth(focused.getValue().substring(focused.getAsAccessor().getDisplayPosFancyMenu()), focused.getInnerWidth());
            focused.moveCursorTo(this.font.plainSubstrByWidth(s, i).length() + focused.getAsAccessor().getDisplayPosFancyMenu(), true);
            if (focused.getAsAccessor().getHighlightPosFancyMenu() == focused.getCursorPosition() && this.startHighlightLineIndex == this.endHighlightLineIndex) {
                this.resetHighlighting();
            }
        }
    }

    public void updateLines(@Nullable Consumer<TextEditorLine> doAfterEachLineUpdate) {
        try {
            int index = 0;
            for (TextEditorLine line : this.textFieldLines) {
                line.lineIndex = index;
                line.setY(this.headerHeight + this.lineHeight * index + this.getLineRenderOffsetY());
                line.setX(this.borderLeft + this.getLineRenderOffsetX());
                line.setWidth(this.currentLineWidth);
                ((IMixinAbstractWidget)((Object)line)).setHeightFancyMenu(this.lineHeight);
                line.getAsAccessor().setDisplayPosFancyMenu(0);
                if (doAfterEachLineUpdate != null) {
                    doAfterEachLineUpdate.accept(line);
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCurrentLineWidth() {
        int longestTextWidth = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.textWidth <= longestTextWidth) continue;
            longestTextWidth = f.textWidth;
        }
        this.currentLineWidth = longestTextWidth + 30;
    }

    public int getLineRenderOffsetX() {
        return -((int)((float)this.getTotalScrollWidth() / 100.0f * (this.horizontalScrollBar.getScroll() * 100.0f)));
    }

    public int getLineRenderOffsetY() {
        return -((int)((float)this.getTotalScrollHeight() / 100.0f * (this.verticalScrollBar.getScroll() * 100.0f)));
    }

    public int getTotalLineHeight() {
        return this.lineHeight * this.textFieldLines.size();
    }

    @Nullable
    public TextEditorLine addLineAtIndex(int index) {
        TextEditorLine before;
        if (!this.multilineMode && this.getLineCount() > 0) {
            this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            return null;
        }
        TextEditorLine f = new TextEditorLine(Minecraft.getInstance().font, 0, 0, 50, this.lineHeight, false, this.characterFilter, this);
        f.setMaxLength(Integer.MAX_VALUE);
        f.lineIndex = index;
        if (index > 0 && (before = this.getLine(index - 1)) != null) {
            f.setY(before.getY() + this.lineHeight);
        }
        this.textFieldLines.add(index, f);
        return f;
    }

    @Nullable
    public TextEditorLine addLine() {
        return this.addLineAtIndex(this.getLineCount());
    }

    public void removeLineAtIndex(int index) {
        if (index < 1) {
            return;
        }
        if (index <= this.getLineCount() - 1) {
            this.textFieldLines.remove(index);
        }
    }

    public void removeLastLine() {
        this.removeLineAtIndex(this.getLineCount() - 1);
    }

    public int getLineCount() {
        return this.textFieldLines.size();
    }

    @Nullable
    public TextEditorLine getLine(int index) {
        return this.textFieldLines.get(index);
    }

    public void setFocusedLine(int index) {
        if (index <= this.getLineCount() - 1) {
            for (TextEditorLine f : this.textFieldLines) {
                f.setFocused(false);
            }
            this.getLine(index).setFocused(true);
        }
    }

    public int getFocusedLineIndex() {
        int index = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.isFocused()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Nullable
    public TextEditorLine getFocusedLine() {
        int index = this.getFocusedLineIndex();
        if (index != -1) {
            return this.getLine(index);
        }
        return null;
    }

    public boolean isLineFocused() {
        return this.getFocusedLineIndex() > -1;
    }

    @Nullable
    public TextEditorLine getLineAfter(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > -1 && index < this.getLineCount() - 1) {
            return this.getLine(index + 1);
        }
        return null;
    }

    @Nullable
    public TextEditorLine getLineBefore(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > 0) {
            return this.getLine(index - 1);
        }
        return null;
    }

    public boolean isAtLeastOneLineInHighlightMode() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.isInMouseHighlightingMode) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public List<TextEditorLine> getLinesBetweenIndexes(int startIndex, int endIndex) {
        startIndex = Math.min(Math.max(startIndex, 0), this.textFieldLines.size() - 1);
        endIndex = Math.min(Math.max(endIndex, 0), this.textFieldLines.size() - 1);
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        l.addAll(this.textFieldLines.subList(startIndex, endIndex));
        if (!l.isEmpty()) {
            l.remove(0);
        }
        return l;
    }

    @Nullable
    public TextEditorLine getHoveredLine() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.isHovered()) continue;
            return t;
        }
        return null;
    }

    public int getLineIndex(TextEditorLine inputBox) {
        return this.textFieldLines.indexOf((Object)inputBox);
    }

    public void goUpLine() {
        int current;
        if (this.isLineFocused() && (current = Math.max(0, this.getFocusedLineIndex())) > 0) {
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current - 1);
            if (currentLine != null) {
                this.getFocusedLine().moveCursorTo(this.lastCursorPosSetByUser, false);
            }
        }
    }

    public void goDownLine(boolean isNewLine) {
        if (this.isLineFocused()) {
            int current = Math.max(0, this.getFocusedLineIndex());
            if (isNewLine) {
                this.addLineAtIndex(current + 1);
            }
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current + 1);
            if (currentLine != null) {
                TextEditorLine nextLine = this.getFocusedLine();
                if (isNewLine) {
                    String textBeforeCursor = currentLine.getValue().substring(0, currentLine.getCursorPosition());
                    String textAfterCursor = currentLine.getValue().substring(currentLine.getCursorPosition());
                    currentLine.setValue(textBeforeCursor);
                    nextLine.setValue(textAfterCursor);
                    nextLine.moveCursorTo(0, false);
                    if (textBeforeCursor.startsWith(" ")) {
                        int spaces = 0;
                        for (char c : textBeforeCursor.toCharArray()) {
                            if (!String.valueOf(c).equals(" ")) break;
                            ++spaces;
                        }
                        nextLine.setValue(textBeforeCursor.substring(0, spaces) + nextLine.getValue());
                        nextLine.moveCursorTo(spaces, false);
                    }
                } else {
                    nextLine.moveCursorTo(this.lastCursorPosSetByUser, false);
                }
            }
        }
    }

    public List<TextEditorLine> getCopyOfLines() {
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        for (TextEditorLine t : this.textFieldLines) {
            TextEditorLine n = new TextEditorLine(this.font, 0, 0, 0, 0, false, this.characterFilter, this);
            n.setValue(t.getValue());
            n.setFocused(t.isFocused());
            n.moveCursorTo(t.getCursorPosition(), false);
            l.add(n);
        }
        return l;
    }

    public List<TextEditorLine> getLines() {
        return this.textFieldLines;
    }

    public boolean isTextHighlighted() {
        return this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1;
    }

    public boolean isHighlightedTextHovered() {
        if (this.isTextHighlighted()) {
            ArrayList<TextEditorLine> highlightedLines = new ArrayList<TextEditorLine>();
            if (this.endHighlightLineIndex <= this.getLineCount() - 1) {
                highlightedLines.addAll(this.textFieldLines.subList(this.startHighlightLineIndex, this.endHighlightLineIndex + 1));
            }
            for (TextEditorLine t : highlightedLines) {
                if (!t.isHighlightedHovered()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getHighlightedText() {
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
                lines.add(this.getLine(this.startHighlightLineIndex));
                if (this.startHighlightLineIndex != this.endHighlightLineIndex) {
                    lines.addAll(this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex));
                    lines.add(this.getLine(this.endHighlightLineIndex));
                }
                StringBuilder s = new StringBuilder();
                boolean b = false;
                for (TextEditorLine t : lines) {
                    if (b) {
                        s.append("\n");
                    }
                    s.append(t.getHighlighted());
                    b = true;
                }
                String ret = s.toString();
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @NotNull
    public String cutHighlightedText() {
        String highlighted = this.getHighlightedText();
        this.deleteHighlightedText();
        return highlighted;
    }

    public void deleteHighlightedText() {
        int linesRemoved = 0;
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                if (this.startHighlightLineIndex == this.endHighlightLineIndex) {
                    this.getLine(this.startHighlightLineIndex).insertText("");
                } else {
                    TextEditorLine start = this.getLine(this.startHighlightLineIndex);
                    start.insertText("");
                    TextEditorLine end = this.getLine(this.endHighlightLineIndex);
                    end.insertText("");
                    if (this.endHighlightLineIndex - this.startHighlightLineIndex > 1) {
                        for (TextEditorLine line : this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex)) {
                            this.removeLineAtIndex(this.getLineIndex(line));
                            ++linesRemoved;
                        }
                    }
                    String oldStartValue = start.getValue();
                    start.setCursorPosition(start.getValue().length());
                    start.setHighlightPos(start.getCursorPosition());
                    start.insertText(end.getValue());
                    start.setCursorPosition(oldStartValue.length());
                    start.setHighlightPos(start.getCursorPosition());
                    this.removeLineAtIndex(this.getLineIndex(end));
                    ++linesRemoved;
                    this.setFocusedLine(this.startHighlightLineIndex);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.correctYScroll(-linesRemoved);
        this.resetHighlighting();
    }

    public void resetHighlighting() {
        this.startHighlightLineIndex = -1;
        this.endHighlightLineIndex = -1;
        for (TextEditorLine t : this.textFieldLines) {
            t.setHighlightPos(t.getCursorPosition());
        }
    }

    public boolean isInMouseHighlightingMode() {
        return MouseInput.isLeftMouseDown() && this.startHighlightLine != null;
    }

    public void pasteText(String text) {
        try {
            if (text != null && !text.equals("")) {
                int addedLinesCount = 0;
                if (this.isTextHighlighted()) {
                    this.deleteHighlightedText();
                }
                if (!this.isLineFocused()) {
                    this.setFocusedLine(this.getLineCount() - 1);
                    this.getFocusedLine().moveCursorToEnd(false);
                }
                TextEditorLine focusedLine = this.getFocusedLine();
                String textBeforeCursor = "";
                String textAfterCursor = "";
                if (focusedLine.getValue().length() > 0) {
                    textBeforeCursor = focusedLine.getValue().substring(0, focusedLine.getCursorPosition());
                    if (focusedLine.getCursorPosition() < focusedLine.getValue().length()) {
                        textAfterCursor = this.getFocusedLine().getValue().substring(focusedLine.getCursorPosition(), focusedLine.getValue().length());
                    }
                }
                focusedLine.setValue(textBeforeCursor);
                focusedLine.setCursorPosition(textBeforeCursor.length());
                String[] lines = new String[]{text};
                if (text.contains("\n")) {
                    lines = text.split("\n", -1);
                }
                if (!this.multilineMode && lines.length > 1) {
                    lines = new String[]{lines[0]};
                    this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
                }
                Array.set(lines, lines.length - 1, lines[lines.length - 1] + textAfterCursor);
                if (lines.length == 1) {
                    this.getFocusedLine().insertText(lines[0]);
                } else if (lines.length > 1) {
                    int index = -1;
                    for (String s : lines) {
                        if (index == -1) {
                            index = this.getFocusedLineIndex();
                        } else {
                            this.addLineAtIndex(index);
                            ++addedLinesCount;
                        }
                        this.getLine(index).insertText(s);
                        ++index;
                    }
                    this.setFocusedLine(index - 1);
                    this.getFocusedLine().setCursorPosition(Math.max(0, this.getFocusedLine().getValue().length() - textAfterCursor.length()));
                    this.getFocusedLine().setHighlightPos(this.getFocusedLine().getCursorPosition());
                }
                this.correctYScroll(addedLinesCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetHighlighting();
    }

    public TextEditorScreen setText(@Nullable String text) {
        if (text == null) {
            text = "";
        }
        TextEditorLine t = this.getLine(0);
        this.textFieldLines.clear();
        this.textFieldLines.add(t);
        this.setFocusedLine(0);
        t.setValue("");
        t.moveCursorTo(0, false);
        this.pasteText(text);
        this.setFocusedLine(0);
        t.moveCursorTo(0, false);
        this.verticalScrollBar.setScroll(0.0f);
        return this;
    }

    @NotNull
    public String getText() {
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : this.textFieldLines) {
            if (b) {
                s.append("\n");
            }
            s.append(t.getValue());
            b = true;
        }
        return s.toString();
    }

    protected boolean isTextValid() {
        if (this.textValidator != null) {
            return this.textValidator.get(this);
        }
        return true;
    }

    public TextEditorScreen setTextValidator(@Nullable ConsumingSupplier<TextEditorScreen, Boolean> textValidator) {
        this.textValidator = textValidator;
        return this;
    }

    public TextEditorScreen setTextValidatorUserFeedback(@Nullable Tooltip feedback) {
        this.textValidatorFeedbackTooltip = feedback;
        return this;
    }

    public boolean placeholdersAllowed() {
        return this.allowPlaceholders;
    }

    public TextEditorScreen setPlaceholdersAllowed(boolean allowed) {
        this.allowPlaceholders = allowed;
        this.init();
        return this;
    }

    public boolean isMultilineMode() {
        return this.multilineMode;
    }

    public TextEditorScreen setMultilineMode(boolean multilineMode) {
        this.multilineMode = multilineMode;
        return this;
    }

    public boolean isBoldTitle() {
        return this.boldTitle;
    }

    public TextEditorScreen setBoldTitle(boolean boldTitle) {
        this.boldTitle = boldTitle;
        return this;
    }

    @Nullable
    public String getTextBeforeCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == 0) {
            lines.add(this.getLine(0));
        } else if (focusedLineIndex > 0) {
            lines.addAll(this.textFieldLines.subList(0, focusedLineIndex + 1));
        }
        TextEditorLine lastLine = (TextEditorLine)((Object)lines.get(lines.size() - 1));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != lastLine) {
                s.append(t.getValue());
            } else {
                s.append(t.getValue().substring(0, t.getCursorPosition()));
            }
            b = true;
        }
        return s.toString();
    }

    @Nullable
    public String getTextAfterCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == this.getLineCount() - 1) {
            lines.add(this.getLine(this.getLineCount() - 1));
        } else if (focusedLineIndex < this.getLineCount() - 1) {
            lines.addAll(this.textFieldLines.subList(focusedLineIndex, this.getLineCount()));
        }
        TextEditorLine firstLine = (TextEditorLine)((Object)lines.get(0));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != firstLine) {
                s.append(t.getValue());
            } else {
                s.append(t.getValue().substring(t.getCursorPosition(), t.getValue().length()));
            }
            b = true;
        }
        return s.toString();
    }

    public boolean charTyped(char character, int modifiers) {
        if (this.isLineFocused()) {
            this.history.saveSnapshot();
        }
        for (TextEditorLine l : this.textFieldLines) {
            l.charTyped(character, modifiers);
        }
        return super.charTyped(character, modifiers);
    }

    public boolean keyPressed(int keycode, int scancode, int modifiers) {
        for (TextEditorLine l : new ArrayList<TextEditorLine>(this.textFieldLines)) {
            l.keyPressed(keycode, scancode, modifiers);
        }
        String key = GLFW.glfwGetKeyName((int)keycode, (int)scancode);
        if (key == null) {
            key = "";
        }
        if (Screen.hasControlDown() && key.equals("z")) {
            this.history.stepBack();
            return true;
        }
        if (Screen.hasControlDown() && key.equals("y")) {
            this.history.stepForward();
            return true;
        }
        if (keycode == 257) {
            if (!this.isInMouseHighlightingMode() && this.multilineMode && this.isLineFocused()) {
                this.history.saveSnapshot();
                this.resetHighlighting();
                this.goDownLine(true);
                this.correctYScroll(1);
            }
            if (!this.multilineMode) {
                this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            }
            return true;
        }
        if (keycode == 265) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goUpLine();
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 264) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goDownLine(false);
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 259) {
            if (!this.isInMouseHighlightingMode()) {
                if (this.isTextHighlighted()) {
                    this.history.saveSnapshot();
                    this.deleteHighlightedText();
                } else if (this.isLineFocused()) {
                    if (!this.getText().isEmpty()) {
                        this.history.saveSnapshot();
                    }
                    TextEditorLine focused = this.getFocusedLine();
                    focused.getAsAccessor().invokeDeleteTextFancyMenu(-1);
                }
                this.resetHighlighting();
            }
            return true;
        }
        if (Screen.isCopy((int)keycode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getHighlightedText());
            return true;
        }
        if (Screen.isPaste((int)keycode)) {
            this.history.saveSnapshot();
            this.pasteText(Minecraft.getInstance().keyboardHandler.getClipboard());
            return true;
        }
        if (Screen.isSelectAll((int)keycode)) {
            for (TextEditorLine t : new ArrayList<TextEditorLine>(this.textFieldLines)) {
                t.setHighlightPos(0);
                t.setCursorPosition(t.getValue().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            return true;
        }
        if (Screen.isCut((int)keycode)) {
            this.history.saveSnapshot();
            Minecraft.getInstance().keyboardHandler.setClipboard(this.cutHighlightedText());
            this.resetHighlighting();
            return true;
        }
        if (keycode == 262 || keycode == 263) {
            this.resetHighlighting();
            return true;
        }
        return super.keyPressed(keycode, scancode, modifiers);
    }

    public boolean keyReleased(int i1, int i2, int i3) {
        for (TextEditorLine l : this.textFieldLines) {
            l.keyReleased(i1, i2, i3);
        }
        return super.keyReleased(i1, i2, i3);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.setFocused(null);
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        this.selectedHoveredOnRightClickMenuOpen = false;
        if (!this.isMouseInteractingWithGrabbers()) {
            for (TextEditorLine l : this.textFieldLines) {
                l.mouseClicked(mouseX, mouseY, button);
            }
            if (this.isMouseInsideEditorArea()) {
                if (button == 1) {
                    this.rightClickContextMenu.closeMenu();
                }
                if (button == 0 || button == 1) {
                    boolean isHighlightedHovered = this.isHighlightedTextHovered();
                    TextEditorLine hoveredLine = this.getHoveredLine();
                    if (!this.rightClickContextMenu.isOpen()) {
                        if (button == 0 || !isHighlightedHovered) {
                            this.resetHighlighting();
                        }
                        if (hoveredLine == null) {
                            TextEditorLine focus = this.getLine(this.getLineCount() - 1);
                            for (TextEditorLine t : this.textFieldLines) {
                                if (MouseInput.getMouseY() < t.getY() || MouseInput.getMouseY() > t.getY() + t.getHeight()) continue;
                                focus = t;
                                break;
                            }
                            this.setFocusedLine(this.getLineIndex(focus));
                            this.getFocusedLine().moveCursorToEnd(false);
                            this.correctYScroll(0);
                        } else if (button == 1 && !isHighlightedHovered) {
                            this.setFocusedLine(this.getLineIndex(hoveredLine));
                            String s = this.font.plainSubstrByWidth(hoveredLine.getValue().substring(hoveredLine.getAsAccessor().getDisplayPosFancyMenu()), hoveredLine.getInnerWidth());
                            hoveredLine.moveCursorTo(this.font.plainSubstrByWidth(s, MouseInput.getMouseX() - hoveredLine.getX()).length() + hoveredLine.getAsAccessor().getDisplayPosFancyMenu(), false);
                        }
                    }
                    if (button == 1) {
                        this.selectedHoveredOnRightClickMenuOpen = this.isHighlightedTextHovered();
                        this.rightClickContextMenu.openMenuAtMouse();
                    } else if (this.rightClickContextMenu.isOpen() && !this.rightClickContextMenu.isHovered()) {
                        this.rightClickContextMenu.closeMenu();
                        this.textFieldLines.forEach(line -> line.mouseClicked(mouseX, mouseY, button));
                        this.mouseClicked(mouseX, mouseY, button);
                    }
                }
            }
        }
        ArrayList<PlaceholderMenuEntry> entries = new ArrayList<PlaceholderMenuEntry>(this.placeholderMenuEntries);
        for (PlaceholderMenuEntry e : entries) {
            e.buttonBase.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public void tick() {
        for (TextEditorLine l : this.textFieldLines) {
            l.tick();
        }
        super.tick();
    }

    public void onClose() {
        this.callback.accept(null);
    }

    public boolean isMouseInteractingWithGrabbers() {
        return this.verticalScrollBar.isGrabberGrabbed() || this.verticalScrollBar.isGrabberHovered() || this.horizontalScrollBar.isGrabberGrabbed() || this.horizontalScrollBar.isGrabberHovered();
    }

    public boolean isMouseInteractingWithPlaceholderGrabbers() {
        return this.verticalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.verticalScrollBarPlaceholderMenu.isGrabberHovered() || this.horizontalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.horizontalScrollBarPlaceholderMenu.isGrabberHovered();
    }

    public int getEditBoxCursorX(EditBox editBox) {
        try {
            int l;
            IMixinEditBox b = (IMixinEditBox)editBox;
            String s = this.font.plainSubstrByWidth(editBox.getValue().substring(b.getDisplayPosFancyMenu()), editBox.getInnerWidth());
            int j = editBox.getCursorPosition() - b.getDisplayPosFancyMenu();
            boolean flag = j >= 0 && j <= s.length();
            boolean flag2 = editBox.getCursorPosition() < editBox.getValue().length() || editBox.getValue().length() >= b.getMaxLengthFancyMenu();
            int j1 = l = b.getBorderedFancyMenu() ? editBox.getX() + 4 : editBox.getX();
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 += this.font.width(b.getFormatterFancyMenu().apply(s1, b.getDisplayPosFancyMenu()));
            }
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + editBox.getWidth() : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            return k1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void scrollToLine(int lineIndex, boolean bottom) {
        if (bottom) {
            this.scrollToLine(lineIndex, -Math.max(0, this.getEditorAreaHeight() - this.lineHeight));
        } else {
            this.scrollToLine(lineIndex, 0);
        }
    }

    public void scrollToLine(int lineIndex, int offset) {
        int totalLineHeight = this.getTotalScrollHeight();
        float f = (float)Math.max(0, (lineIndex + 1) * this.lineHeight - this.lineHeight) / (float)totalLineHeight;
        if (offset != 0) {
            f = offset > 0 ? (f += (float)offset / (float)totalLineHeight) : (f -= (float)Math.abs(offset) / (float)totalLineHeight);
        }
        this.verticalScrollBar.setScroll(f);
    }

    public int getTotalScrollHeight() {
        if (this.overriddenTotalScrollHeight != -1) {
            return this.overriddenTotalScrollHeight;
        }
        return this.getTotalLineHeight();
    }

    public int getTotalScrollWidth() {
        return this.currentLineWidth;
    }

    public void correctYScroll(int lineCountOffsetAfterRemovingAdding) {
        if (this.isInMouseHighlightingMode() || !this.isLineFocused()) {
            return;
        }
        int minY = this.getEditorAreaY();
        int maxY = this.getEditorAreaY() + this.getEditorAreaHeight();
        int currentLineY = this.getFocusedLine().getY();
        if (currentLineY < minY) {
            this.scrollToLine(this.getFocusedLineIndex(), false);
        } else if (currentLineY + this.lineHeight > maxY) {
            this.scrollToLine(this.getFocusedLineIndex(), true);
        } else if (lineCountOffsetAfterRemovingAdding != 0) {
            this.overriddenTotalScrollHeight = -1;
            int removedAddedLineCount = Math.abs(lineCountOffsetAfterRemovingAdding);
            if (lineCountOffsetAfterRemovingAdding > 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() - this.lineHeight * removedAddedLineCount;
            } else if (lineCountOffsetAfterRemovingAdding < 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() + this.lineHeight * removedAddedLineCount;
            }
            this.updateLines(null);
            this.overriddenTotalScrollHeight = -1;
            int diffToTop = Math.max(0, this.getFocusedLine().getY() - this.getEditorAreaY());
            this.scrollToLine(this.getFocusedLineIndex(), -diffToTop);
            this.correctYScroll(0);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
    }

    public void correctXScroll(TextEditorLine line) {
        if (this.isInMouseHighlightingMode()) {
            return;
        }
        if (this.isLineFocused() && this.getFocusedLine() == line) {
            boolean textGotAdded;
            int oldX = line.getX();
            this.updateCurrentLineWidth();
            this.updateLines(null);
            int newX = line.getX();
            String oldValue = line.lastTickValue;
            String newValue = line.getValue();
            int cursorWidth = 2;
            if (line.getCursorPosition() >= newValue.length()) {
                cursorWidth = 6;
            }
            int editorAreaCenterX = this.getEditorAreaX() + this.getEditorAreaWidth() / 2;
            int cursorX = this.getEditBoxCursorX((EditBox)line);
            if (cursorX > editorAreaCenterX) {
                cursorX += cursorWidth + 5;
            } else if (cursorX < editorAreaCenterX) {
                cursorX -= cursorWidth + 5;
            }
            int maxToRight = this.getEditorAreaX() + this.getEditorAreaWidth();
            int maxToLeft = this.getEditorAreaX();
            float currentScrollX = this.horizontalScrollBar.getScroll();
            int currentLineW = this.getTotalScrollWidth();
            boolean textGotDeleted = oldValue.length() > newValue.length();
            boolean bl = textGotAdded = oldValue.length() < newValue.length();
            if (cursorX > maxToRight) {
                float f = (float)(cursorX - maxToRight) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (cursorX < maxToLeft) {
                float f = (float)(maxToLeft - cursorX) / (float)currentLineW;
                if (textGotDeleted) {
                    f = (float)(maxToRight - maxToLeft) / (float)currentLineW;
                }
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            } else if (textGotDeleted && oldX < newX) {
                float f = (float)(newX - oldX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (textGotAdded && oldX > newX) {
                float f = (float)(oldX - newX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            }
            if (line.getCursorPosition() == 0) {
                this.horizontalScrollBar.setScroll(0.0f);
            }
        }
    }

    public boolean isMouseInsideEditorArea() {
        int xStart = this.borderLeft;
        int yStart = this.headerHeight;
        int xEnd = this.getEditorAreaX() + this.getEditorAreaWidth();
        int yEnd = this.height - this.footerHeight;
        int mX = MouseInput.getMouseX();
        int mY = MouseInput.getMouseY();
        return mX >= xStart && mX <= xEnd && mY >= yStart && mY <= yEnd;
    }

    public int getEditorAreaWidth() {
        int i = this.width - this.borderRight - this.borderLeft;
        if (extendedPlaceholderMenu) {
            i = i - this.placeholderMenuWidth - 15;
        }
        return i;
    }

    public int getEditorAreaHeight() {
        return this.height - this.footerHeight - this.headerHeight;
    }

    public int getEditorAreaX() {
        return this.borderLeft;
    }

    public int getEditorAreaY() {
        return this.headerHeight;
    }

    public class PlaceholderMenuEntry
    extends UIBase {
        public TextEditorScreen parent;
        public final Component label;
        public Runnable clickAction;
        public int x;
        public int y;
        public final int labelWidth;
        protected Color backgroundColorIdle = Color.GRAY;
        protected Color backgroundColorHover = Color.LIGHT_GRAY;
        protected Color dotColor = Color.BLUE;
        protected Color entryLabelColor = Color.WHITE;
        public ExtendedButton buttonBase;
        public Font font;

        public PlaceholderMenuEntry(final @NotNull TextEditorScreen this$0, @NotNull TextEditorScreen parent, @NotNull Component label, Runnable clickAction) {
            this.font = Minecraft.getInstance().font;
            this.parent = parent;
            this.label = label;
            this.clickAction = clickAction;
            this.labelWidth = this.font.width((FormattedText)this.label);
            this.buttonBase = new ExtendedButton(0, 0, this.getWidth(), this.getHeight(), "", button -> this.clickAction.run()){

                public boolean isHoveredOrFocused() {
                    if (PlaceholderMenuEntry.this.parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return false;
                    }
                    return super.isHoveredOrFocused();
                }

                public void onClick(double p_93371_, double p_93372_) {
                    if (PlaceholderMenuEntry.this.parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return;
                    }
                    super.onClick(p_93371_, p_93372_);
                }

                @Override
                public void render(@NotNull GuiGraphics graphics, int p_93658_, int p_93659_, float p_93660_) {
                    if (PlaceholderMenuEntry.this.parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        this.isHovered = false;
                    }
                    super.render(graphics, p_93658_, p_93659_, p_93660_);
                }
            };
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.buttonBase.setBackgroundColor(DrawableColor.of(this.backgroundColorIdle), DrawableColor.of(this.backgroundColorHover), DrawableColor.of(this.backgroundColorIdle), DrawableColor.of(this.backgroundColorIdle), DrawableColor.of(this.backgroundColorHover), DrawableColor.of(this.backgroundColorIdle));
            this.buttonBase.setX(this.x);
            this.buttonBase.setY(this.y);
            int yCenter = this.y + this.getHeight() / 2;
            this.buttonBase.render(graphics, mouseX, mouseY, partial);
            PlaceholderMenuEntry.renderListingDot(graphics, this.x + 5, yCenter - 2, this.dotColor);
            Objects.requireNonNull(this.font);
            graphics.drawString(this.font, this.label, this.x + 5 + 4 + 3, yCenter - 9 / 2, this.entryLabelColor.getRGB(), false);
        }

        public int getWidth() {
            return Math.max(this.parent.placeholderMenuWidth, 12 + this.labelWidth + 5);
        }

        public int getHeight() {
            return this.parent.placeholderMenuEntryHeight;
        }

        public boolean isHovered() {
            return this.buttonBase.isHoveredOrFocused();
        }

        public void setDescription(String ... desc) {
            this.buttonBase.setTooltip(Tooltip.of(desc).setDefaultStyle());
        }
    }
}

