/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.other;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RandomTextPlaceholder
extends Placeholder {
    public static Map<String, RandomTextPackage> randomTextIntervals = new HashMap<String, RandomTextPackage>();

    public RandomTextPlaceholder() {
        super("randomtext");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String pathString = dps.values.get("path");
        String intervalString = dps.values.get("interval");
        if (pathString != null && intervalString != null) {
            File path = new File(pathString);
            if (!path.exists() || !path.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.getInstance().gameDirectory.getAbsolutePath().replace("\\", "/"))) {
                path = new File(Minecraft.getInstance().gameDirectory, pathString);
            }
            if (MathUtils.isLong((String)intervalString) && path.isFile() && path.getPath().toLowerCase().endsWith(".txt")) {
                RandomTextPackage p;
                long interval = Long.parseLong(intervalString) * 1000L;
                if (interval < 0L) {
                    interval = 0L;
                }
                long currentTime = System.currentTimeMillis();
                if (randomTextIntervals.containsKey(path.getPath())) {
                    p = randomTextIntervals.get(path.getPath());
                } else {
                    p = new RandomTextPackage();
                    randomTextIntervals.put(path.getPath(), p);
                }
                if ((interval > 0L || p.currentText == null) && p.lastChange + interval <= currentTime) {
                    p.lastChange = currentTime;
                    List txtLines = FileUtils.getFileLines((File)path);
                    p.currentText = !txtLines.isEmpty() ? (String)txtLines.get(MathUtils.getRandomNumberInRange((int)0, (int)(txtLines.size() - 1))) : null;
                }
                if (p.currentText != null) {
                    return p.currentText;
                }
                return "";
            }
        }
        return null;
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("path");
        l.add("interval");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.variables.randomtext", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.fancymenu.editor.dynamicvariabletextfield.variables.randomtext.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.other", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        DeserializedPlaceholderString dps = new DeserializedPlaceholderString();
        dps.placeholderIdentifier = this.getIdentifier();
        dps.values.put("path", "randomtexts.txt");
        dps.values.put("interval", "10");
        return dps;
    }

    public static class RandomTextPackage {
        public String currentText = null;
        public long lastChange = 0L;
    }
}

