/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRequirementScreen
extends Screen {
    protected Screen parentScreen;
    protected LoadingRequirementContainer parent;
    protected final LoadingRequirementInstance instance;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementInstance> callback;
    protected ScrollArea requirementsListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea requirementDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton requirementModeButton;
    protected ExtendedButton editValueButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public BuildRequirementScreen(@Nullable Screen parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementInstance instanceToEdit, @NotNull Consumer<LoadingRequirementInstance> callback) {
        super((Component)(instanceToEdit != null ? Component.literal((String)I18n.get((String)"fancymenu.editor.loading_requirement.screens.edit_requirement", (Object[])new Object[0])) : Component.literal((String)I18n.get((String)"fancymenu.editor.loading_requirement.screens.add_requirement", (Object[])new Object[0]))));
        this.parentScreen = parentScreen;
        this.parent = parent;
        this.instance = instanceToEdit != null ? instanceToEdit : new LoadingRequirementInstance(null, null, LoadingRequirementInstance.RequirementMode.IF, parent);
        this.isEdit = instanceToEdit != null;
        this.callback = callback;
        this.setContentOfRequirementsList(null);
        if (this.instance.requirement != null) {
            this.setContentOfRequirementsList(this.instance.requirement.getCategory());
            for (ScrollAreaEntry e : this.requirementsListScrollArea.getEntries()) {
                if (!(e instanceof RequirementScrollEntry) || ((RequirementScrollEntry)e).requirement != this.instance.requirement) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    protected void init() {
        this.editValueButton = new ExtendedButton(0, 0, 150, 20, I18n.get((String)"fancymenu.editor.loading_requirement.screens.build_screen.edit_value", (Object[])new Object[0]), button -> {
            if (this.instance.requirement != null) {
                this.instance.requirement.editValue(this, this.instance);
            }
        }){

            @Override
            public void render(@NotNull GuiGraphics graphics, int p_93658_, int p_93659_, float p_93660_) {
                LoadingRequirement r = BuildRequirementScreen.this.instance.requirement;
                if (r != null && !r.hasValue()) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.no_value", new String[0])));
                } else {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.build_screen.edit_value.desc.normal", new String[0])));
                }
                this.active = r != null && r.hasValue();
                super.render(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.addWidget((GuiEventListener)this.editValueButton);
        UIBase.applyDefaultWidgetSkinTo(this.editValueButton);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, I18n.get((String)"fancymenu.guicomponents.done", (Object[])new Object[0]), button -> {
            Minecraft.getInstance().setScreen(this.parentScreen);
            this.callback.accept(this.instance);
        }){

            @Override
            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                if (BuildRequirementScreen.this.instance.requirement == null) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_requirement_selected", new String[0])));
                    this.active = false;
                } else if (BuildRequirementScreen.this.instance.value == null && BuildRequirementScreen.this.instance.requirement.hasValue()) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.build_screen.finish.desc.no_value_set", new String[0])));
                    this.active = false;
                } else {
                    this.setTooltip(null);
                    this.active = true;
                }
                super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            }
        };
        this.addWidget((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, I18n.get((String)"fancymenu.guicomponents.cancel", (Object[])new Object[0]), button -> {
            Minecraft.getInstance().setScreen(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.instance);
            } else {
                this.callback.accept(null);
            }
        });
        this.addWidget((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.requirementModeButton = new ExtendedButton(0, 0, 150, 20, "", button -> {
            this.instance.mode = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? LoadingRequirementInstance.RequirementMode.IF_NOT : LoadingRequirementInstance.RequirementMode.IF;
        }){

            @Override
            public void render(@NotNull GuiGraphics graphics, int p_93658_, int p_93659_, float p_93660_) {
                if (BuildRequirementScreen.this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                    this.setLabel(I18n.get((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.normal", (Object[])new Object[0]));
                } else {
                    this.setLabel(I18n.get((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.opposite", (Object[])new Object[0]));
                }
                super.render(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.addWidget((GuiEventListener)this.requirementModeButton);
        this.requirementModeButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.loading_requirement.screens.build_screen.requirement_mode.desc", new String[0])));
        UIBase.applyDefaultWidgetSkinTo(this.requirementModeButton);
        this.setDescription(this.instance.requirement);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.instance);
        } else {
            this.callback.accept(null);
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        graphics.fill(0, 0, this.width, this.height, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        MutableComponent titleComp = this.title.copy().withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        graphics.drawString(this.font, (Component)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.drawString(this.font, I18n.get((String)"fancymenu.editor.loading_requirement.screens.build_screen.available_requirements", (Object[])new Object[0]), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementsListScrollArea.setWidth(this.width / 2 - 40, true);
        this.requirementsListScrollArea.setHeight(this.height - 85, true);
        this.requirementsListScrollArea.setX(20, true);
        this.requirementsListScrollArea.setY(65, true);
        this.requirementsListScrollArea.render(graphics, mouseX, mouseY, partial);
        String descLabelString = I18n.get((String)"fancymenu.editor.loading_requirement.screens.build_screen.requirement_description", (Object[])new Object[0]);
        int descLabelWidth = this.font.width(descLabelString);
        graphics.drawString(this.font, descLabelString, this.width - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.requirementDescriptionScrollArea.setWidth(this.width / 2 - 40, true);
        this.requirementDescriptionScrollArea.setHeight(Math.max(40, this.height / 2 - 50 - 25), true);
        this.requirementDescriptionScrollArea.setX(this.width - 20 - this.requirementDescriptionScrollArea.getWidthWithBorder(), true);
        this.requirementDescriptionScrollArea.setY(65, true);
        this.requirementDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.setX(this.width - 20 - this.doneButton.getWidth());
        this.doneButton.setY(this.height - 20 - 20);
        this.doneButton.render(graphics, mouseX, mouseY, partial);
        if (!this.isEdit) {
            this.cancelButton.setX(this.width - 20 - this.cancelButton.getWidth());
            this.cancelButton.setY(this.doneButton.getY() - 5 - 20);
            this.cancelButton.render(graphics, mouseX, mouseY, partial);
        } else {
            this.cancelButton.active = false;
        }
        this.editValueButton.setX(this.width - 20 - this.editValueButton.getWidth());
        this.editValueButton.setY((this.isEdit ? this.doneButton.getY() : this.cancelButton.getY()) - 15 - 20);
        this.editValueButton.render(graphics, mouseX, mouseY, partial);
        this.requirementModeButton.setX(this.width - 20 - this.cancelButton.getWidth());
        this.requirementModeButton.setY(this.editValueButton.getY() - 5 - 20);
        this.requirementModeButton.render(graphics, mouseX, mouseY, partial);
        super.render(graphics, mouseX, mouseY, partial);
    }

    public void renderBackground(@NotNull GuiGraphics $$0, int $$1, int $$2, float $$3) {
    }

    protected void setDescription(@Nullable LoadingRequirement requirement) {
        this.requirementDescriptionScrollArea.clearEntries();
        if (requirement != null && requirement.getDescription() != null) {
            for (String s : requirement.getDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.requirementDescriptionScrollArea, (Component)Component.literal((String)s).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                e.setSelectable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.requirementDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected void setContentOfRequirementsList(@Nullable String category) {
        block4: {
            LinkedHashMap<String, List<LoadingRequirement>> categories;
            block3: {
                TextListScrollAreaEntry e;
                MutableComponent label;
                this.requirementsListScrollArea.clearEntries();
                categories = LoadingRequirementRegistry.getRequirementsOrderedByCategories();
                if (category != null) break block3;
                for (Map.Entry<String, List<LoadingRequirement>> m : categories.entrySet()) {
                    label = Component.literal((String)m.getKey()).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                    e = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_2.getColor(), entry -> {
                        this.setContentOfRequirementsList((String)m.getKey());
                        this.instance.requirement = null;
                        this.setDescription(null);
                    });
                    e.setSelectable(false);
                    this.requirementsListScrollArea.addEntry(e);
                }
                for (LoadingRequirement r : LoadingRequirementRegistry.getRequirementsWithoutCategory()) {
                    if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                    label = Component.literal((String)r.getDisplayName()).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                    e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                        this.instance.requirement = r;
                        this.setDescription(this.instance.requirement);
                    });
                    ((RequirementScrollEntry)e).requirement = r;
                    this.requirementsListScrollArea.addEntry(e);
                }
                break block4;
            }
            MutableComponent backLabel = Component.literal((String)I18n.get((String)"fancymenu.editor.loading_requirement.screens.lists.back", (Object[])new Object[0])).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            TextListScrollAreaEntry backEntry = new TextListScrollAreaEntry(this.requirementsListScrollArea, (Component)backLabel, UIBase.getUIColorTheme().listing_dot_color_2.getColor(), entry -> {
                this.setContentOfRequirementsList(null);
                this.instance.requirement = null;
                this.setDescription(null);
            });
            backEntry.setSelectable(false);
            this.requirementsListScrollArea.addEntry(backEntry);
            List<LoadingRequirement> l = categories.get(category);
            if (l == null) break block4;
            for (LoadingRequirement r : l) {
                if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                MutableComponent label = Component.literal((String)r.getDisplayName()).withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (Component)label, UIBase.getUIColorTheme().listing_dot_color_1.getColor(), entry -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }
        }
    }

    public static class RequirementScrollEntry
    extends TextListScrollAreaEntry {
        public LoadingRequirement requirement;

        public RequirementScrollEntry(ScrollArea parent, @NotNull Component text, @NotNull Color listDotColor, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, text, listDotColor, onClick);
        }
    }
}

