/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.integrations;

import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.utils.MathUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ScrollPane
extends ExtendedScreen {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceUtils.getResource("widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceUtils.getResource("widget/scroller_background");
    private static final int DEFAULT_PADDING = 4;
    private static final int DEFAULT_HEADER_HEIGHT = 2;
    private static final int DEFAULT_FOOTER_HEIGHT = 2;
    private static final int DEFAULT_BAR_WIDTH = 6;
    private static final int DEFAULT_HEIGHT_PER_SCROLL = 8;
    private final ScreenConstants.ColorData DEFAULT_HEADER_BACKGROUND;
    private final ScreenConstants.ColorData DEFAULT_FOOTER_BACKGROUND;
    private boolean clickedScrollbar;
    private int padding;
    private float amountScrolled = 0.0f;

    public ScrollPane(int startX, int startY, int width, int height, int padding) {
        this.setScreenX(startX);
        this.setScreenY(startY);
        this.setScreenWidth(width);
        this.setScreenHeight(height);
        this.setPadding(padding);
        this.DEFAULT_HEADER_BACKGROUND = new ScreenConstants.ColorData((this.hasWorld() ? ExtendedScreen.INWORLD_HEADER_SEPARATOR : ExtendedScreen.HEADER_SEPARATOR).toString(), 0.0, 32.0, 2.0);
        this.DEFAULT_FOOTER_BACKGROUND = new ScreenConstants.ColorData((this.hasWorld() ? ExtendedScreen.INWORLD_FOOTER_SEPARATOR : ExtendedScreen.FOOTER_SEPARATOR).toString(), 0.0, 32.0, 2.0);
    }

    public ScrollPane(int startX, int startY, int width, int height) {
        this(startX, startY, width, height, 4);
    }

    public ScrollPane(int width, int height, int padding) {
        this(0, 0, width, height, padding);
    }

    public ScrollPane(int width, int height) {
        this(width, height, 4);
    }

    @Override
    public void resetMouseScroll() {
        super.resetMouseScroll();
        this.setScroll(this.getMouseScroll());
    }

    @Override
    public void refreshContentHeight() {
        super.refreshContentHeight();
        this.setContentHeight((int)((float)this.getContentHeight() + this.getAmountScrolled()));
    }

    @Override
    public double getOffset() {
        return this.needsScrollbar() ? (double)this.getAmountScrolled() : super.getOffset();
    }

    @Override
    public float getTintFactor() {
        return super.getTintFactor();
    }

    @Override
    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, ScreenConstants.ColorData data) {
        this.drawBackground(left, right, top, bottom, offset, tintFactor, right, bottom, data);
    }

    public void renderBackground(@Nonnull GuiGraphics arg, int i, int j, float f) {
        super.renderMenuBackground(arg);
    }

    protected int getHeaderTop() {
        return this.getTop() - this.getHeaderHeight();
    }

    protected int getHeaderHeight() {
        return 2;
    }

    protected int getHeaderBottom() {
        return this.getHeaderTop() + this.getHeaderHeight();
    }

    protected int getFooterTop() {
        return this.getBottom();
    }

    protected int getFooterHeight() {
        return 2;
    }

    protected int getFooterBottom() {
        return this.getFooterTop() + this.getFooterHeight();
    }

    protected ScreenConstants.ColorData getHeaderBackground() {
        return this.DEFAULT_HEADER_BACKGROUND;
    }

    protected ScreenConstants.ColorData getFooterBackground() {
        return this.DEFAULT_FOOTER_BACKGROUND;
    }

    protected ResourceLocation getScrollerBackgroundSprite() {
        return SCROLLER_BACKGROUND_SPRITE;
    }

    protected ResourceLocation getScrollerSprite() {
        return SCROLLER_SPRITE;
    }

    protected void renderListSeparators() {
        this.drawBackground(this.getLeft(), this.getRight(), this.getHeaderTop(), this.getHeaderBottom(), 0.0, 1.0f, 0.0, 0.0, this.getHeaderBackground());
        this.drawBackground(this.getLeft(), this.getRight(), this.getFooterTop(), this.getFooterBottom(), 0.0, 1.0f, 0.0, 0.0, this.getFooterBackground());
    }

    protected void renderScrollbar() {
        if (this.needsScrollbar()) {
            int scrollBarX = this.getScrollBarX();
            int scrollBarWidth = this.getScrollBarWidth();
            int bottom = this.getBottom();
            int top = this.getTop();
            int maxScroll = this.getMaxScroll();
            int screenHeight = this.getScreenHeight();
            int height = this.getBarHeight();
            int barTop = Math.max((int)this.getAmountScrolled() * (screenHeight - height) / maxScroll + top, top);
            RenderUtils.renderSprite(this.getCurrentMatrix(), graphics -> {
                graphics.blitSprite(this.getScrollerBackgroundSprite(), scrollBarX, top, scrollBarWidth, bottom - top);
                graphics.blitSprite(this.getScrollerSprite(), scrollBarX, barTop, scrollBarWidth, height);
            });
        }
    }

    @Override
    public void postRender() {
        this.renderListSeparators();
        this.renderScrollbar();
        super.postRender();
    }

    protected boolean isValidMouseClick(int button) {
        return button == 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isLoaded()) {
            this.checkScrollbarClick(mouseX, mouseY, mouseButton);
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isLoaded()) {
            if (this.isValidMouseClick(button) && this.needsScrollbar() && this.isScrolling()) {
                if (mouseY < (double)this.getTop()) {
                    this.setScroll(0.0f);
                } else if (mouseY > (double)this.getBottom()) {
                    this.setScroll(this.getMaxScroll());
                } else {
                    int deltaYInt = (int)(deltaY > 0.0 ? deltaY + 0.5 : deltaY - 0.5);
                    int height = this.getBarHeight();
                    int scrollLimit = Math.max(1, this.getMaxScroll());
                    int heightPerScroll = Math.max(1, scrollLimit / (this.getScreenHeight() - height));
                    this.scrollBy(deltaYInt * heightPerScroll);
                }
                return true;
            }
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double wheelX, double wheelY) {
        this.scrollBy((float)(-wheelY * (double)this.getHeightPerScroll()));
        return true;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int newPadding) {
        this.padding = newPadding;
    }

    public int getScrollBarX() {
        return this.getRight() - this.getScrollBarWidth();
    }

    public int getScrollBarWidth() {
        return this.needsScrollbar() ? 6 : 0;
    }

    public int getHeightPerScroll() {
        return 8;
    }

    public void scrollBy(float amount) {
        this.setScroll(this.getAmountScrolled() + amount);
    }

    public void setScroll(float amount) {
        float prevScrollAmount = this.getAmountScrolled();
        this.setAmountScrolled(amount);
        this.bindAmountScrolled();
        if (this.getAmountScrolled() != prevScrollAmount) {
            int scrollDiff = (int)(this.getAmountScrolled() - prevScrollAmount);
            for (DynamicWidget widget : this.getWidgets()) {
                widget.setControlPosY(widget.getControlPosY() - scrollDiff);
            }
        }
    }

    public void checkScrollbarClick(double mouseX, double mouseY, int button) {
        this.clickedScrollbar = this.needsScrollbar() && this.isValidMouseClick(button) && MathUtils.isWithinValue(mouseX, this.getScrollBarX(), this.getScrollBarX() + this.getScrollBarWidth(), true, false);
    }

    public boolean isScrolling() {
        return this.clickedScrollbar;
    }

    public void bindAmountScrolled() {
        this.setAmountScrolled(MathUtils.clamp(this.getAmountScrolled(), 0.0f, (float)this.getMaxScroll()));
    }

    public float getAmountScrolled() {
        return this.amountScrolled;
    }

    public void setAmountScrolled(float scrolled) {
        this.amountScrolled = scrolled;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.getBottom() - this.getPadding()));
    }

    public int getBarHeight() {
        if (!this.needsScrollbar()) {
            return 0;
        }
        int barHeight = this.getScreenHeight() * this.getScreenHeight() / this.getContentHeight();
        return MathUtils.clamp(barHeight, 32, this.getScreenHeight() - this.getPadding() * 2);
    }

    public boolean needsScrollbar() {
        return this.getMaxScroll() > 0;
    }

    @Override
    public int getMaxWidth() {
        return this.getScreenWidth() - this.getPadding() - this.getScrollBarWidth();
    }
}

