/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.items.Items;
import com.github.d0ctorleon.mythsandlegends.utils.DebtUtils;
import com.github.d0ctorleon.mythsandlegends.utils.InventoryUtils;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class PlayerDataUtils {
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static final DebtUtils debtUtils = new DebtUtils(Platform.getConfigFolder().resolve("MythsAndLegends"));
    private static ModConfigs modConfig;

    public static void setModConfig(ModConfigs config) {
        modConfig = config;
    }

    public static PlayerData getPlayerData(Player player) {
        return playerDataMap.computeIfAbsent(player.getUUID(), k -> new PlayerData());
    }

    public static void checkPlayerInventory(Player player) {
        Item configItem;
        HashSet<Item> itemsToCheck = new HashSet<Item>();
        for (ResourceLocation resourceLocation : Items.MYTHS_AND_LEGENDS_ITEMS) {
            configItem = (Item)BuiltInRegistries.ITEM.get(resourceLocation);
            itemsToCheck.add(configItem);
        }
        for (String string : PlayerDataUtils.modConfig.inventory_check_item_list) {
            configItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)string));
            itemsToCheck.add(configItem);
        }
        PlayerData data = PlayerDataUtils.getPlayerData(player);
        for (Item item : itemsToCheck) {
            data.setItemCount(item, 0);
        }
        HashMap<Item, Integer> hashMap = new HashMap<Item, Integer>();
        debtUtils.loadDebts();
        Map<ResourceLocation, Integer> playerDebts = debtUtils.getDebtsForPlayer(player.getUUID());
        if (!playerDebts.isEmpty()) {
            for (Map.Entry entry : playerDebts.entrySet()) {
                int debtCount;
                ResourceLocation debtItemId = (ResourceLocation)entry.getKey();
                Item debtItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)debtItemId.getNamespace(), (String)debtItemId.getPath()));
                if (!InventoryUtils.removeItemFromInventory((ServerPlayer)player, debtItem, debtCount = ((Integer)entry.getValue()).intValue(), false, false)) continue;
                debtUtils.clearDebt(player.getUUID(), debtItemId);
            }
        }
        for (ItemStack itemStack : player.getInventory().items) {
            if (itemsToCheck.contains(itemStack.getItem())) {
                data.setItemState(itemStack.getItem(), true);
                hashMap.merge(itemStack.getItem(), itemStack.getCount(), Integer::sum);
            }
            if (PlayerDataUtils.modConfig.inventory_check_bundles && itemStack.getItem() instanceof BundleItem) {
                PlayerDataUtils.checkItemsInContainer(itemStack, data, itemsToCheck, hashMap, player);
            }
            if (!PlayerDataUtils.modConfig.inventory_check_shulker_boxes || !(itemStack.getItem() instanceof BlockItem) || !(((BlockItem)itemStack.getItem()).getBlock() instanceof ShulkerBoxBlock)) continue;
            PlayerDataUtils.checkItemsInContainer(itemStack, data, itemsToCheck, hashMap, player);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            data.setItemCount((Item)entry.getKey(), (Integer)entry.getValue());
        }
    }

    private static void checkItemsInContainer(ItemStack containerStack, PlayerData data, Set<Item> itemsToCheck, Map<Item, Integer> totalItemCounts, Player player) {
        block6: {
            ItemContainerContents containerComponent;
            Item containerItem;
            block5: {
                containerItem = containerStack.getItem();
                Map<ResourceLocation, Integer> playerDebts = debtUtils.getDebtsForPlayer(player.getUUID());
                if (!playerDebts.isEmpty()) {
                    for (Map.Entry<ResourceLocation, Integer> debtEntry : playerDebts.entrySet()) {
                        int debtCount;
                        ResourceLocation debtItemId = debtEntry.getKey();
                        Item debtItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)debtItemId.getNamespace(), (String)debtItemId.getPath()));
                        if (!InventoryUtils.removeItemFromInventory((ServerPlayer)player, debtItem, debtCount = debtEntry.getValue().intValue(), true, true)) continue;
                        debtUtils.clearDebt(player.getUUID(), debtItemId);
                    }
                }
                if (!(containerItem instanceof BundleItem)) break block5;
                BundleContents bundleContents = (BundleContents)containerStack.get(DataComponents.BUNDLE_CONTENTS);
                if (bundleContents == null) break block6;
                for (ItemStack bundleItem : bundleContents.itemsCopy()) {
                    if (!itemsToCheck.contains(bundleItem.getItem())) continue;
                    data.setItemState(bundleItem.getItem(), true);
                    totalItemCounts.merge(bundleItem.getItem(), bundleItem.getCount(), Integer::sum);
                }
                break block6;
            }
            if (containerItem instanceof BlockItem && ((BlockItem)containerItem).getBlock() instanceof ShulkerBoxBlock && (containerComponent = (ItemContainerContents)containerStack.get(DataComponents.CONTAINER)) != null) {
                for (ItemStack shulkerItem : containerComponent.nonEmptyItems()) {
                    if (!itemsToCheck.contains(shulkerItem.getItem())) continue;
                    data.setItemState(shulkerItem.getItem(), true);
                    totalItemCounts.merge(shulkerItem.getItem(), shulkerItem.getCount(), Integer::sum);
                }
            }
        }
    }

    public static class PlayerData {
        private final Map<Item, Boolean> itemStates = new HashMap<Item, Boolean>();
        private final Map<Item, Integer> itemCounts = new HashMap<Item, Integer>();

        public void setItemState(Item item, boolean hasItem) {
            if (hasItem) {
                this.itemStates.putIfAbsent(item, hasItem);
            } else {
                this.itemStates.remove(item);
            }
        }

        public boolean hasItem(Item item) {
            return this.itemStates.getOrDefault(item, false);
        }

        public void setItemCount(Item item, int count) {
            if (count <= 0) {
                this.itemCounts.remove(item);
            } else {
                this.itemCounts.put(item, count);
            }
        }

        public int getItemCount(Item item) {
            return this.itemCounts.getOrDefault(item, 0);
        }

        public String getFormattedItemsWithCounts() {
            StringBuilder itemsWithCounts = new StringBuilder();
            for (Map.Entry<Item, Boolean> entry : this.itemStates.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                String itemName = entry.getKey().getDescription().getString();
                int itemCount = this.itemCounts.getOrDefault(entry.getKey(), 0);
                itemsWithCounts.append(itemName).append(": ").append(itemCount).append(", ");
            }
            if (!itemsWithCounts.isEmpty()) {
                itemsWithCounts = new StringBuilder(itemsWithCounts.substring(0, itemsWithCounts.length() - 2));
            }
            return itemsWithCounts.toString();
        }
    }
}

