/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.utils;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.spawning.CobblemonWorldSpawnerManager;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.WorldSlice;
import com.cobblemon.mod.common.api.spawning.condition.AppendageCondition;
import com.cobblemon.mod.common.api.spawning.condition.SpawningCondition;
import com.cobblemon.mod.common.api.spawning.context.AreaSpawningContext;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.detail.SingleEntitySpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningArea;
import com.cobblemon.mod.common.config.CobblemonConfig;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.mixins.SpawningConditionMixin;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.keyitem.KeyItemCondition;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import kotlin.Pair;
import kotlin.Unit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ForceSpawningUtils {
    public static InteractionResultHolder<ItemStack> forceSpawnv1(Level world, Player playerEntity, InteractionHand hand, String keyItemIdentifierPath) {
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        ItemStack itemStack = playerEntity.getItemInHand(hand);
        playerEntity.getCooldowns().addCooldown(itemStack.getItem(), Modconfig.force_spawn_item_cooldown);
        if (!Modconfig.enable_force_spawning) {
            MythsAndLegends.getLogger().debug("Force spawning is disabled.");
            return InteractionResultHolder.fail((Object)itemStack);
        }
        PlayerDataUtils.checkPlayerInventory(playerEntity);
        if (!world.isClientSide) {
            MythsAndLegends.getLogger().debug("Force spawning enabled and not client.");
            PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.getUUID());
            SpawnBucket spawn_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> Modconfig.force_spawning_spawn_pool.equalsIgnoreCase(b.name)).findFirst().orElse(null);
            if (spawner != null) {
                SpawnCause cause;
                if (spawn_bucket == null) {
                    MythsAndLegends.getLogger().debug("No ultra-rare bucket found.");
                    cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (Entity)spawner.getCauseEntity());
                    SpawningArea area = spawner.getArea(cause);
                    if (area == null) {
                        MythsAndLegends.getLogger().debug("No valid area for spawning found.");
                    }
                } else {
                    MythsAndLegends.getLogger().debug("Ultra-rare bucket found.");
                    cause = new SpawnCause((Spawner)spawner, spawn_bucket, (Entity)spawner.getCauseEntity());
                    SpawningArea area = spawner.getArea(cause);
                    if (area == null) {
                        MythsAndLegends.getLogger().debug("No valid area for spawning found.");
                    }
                    MythsAndLegends.getLogger().debug("SpawningArea and SpawnCause[Ultra-Rare] found.");
                }
                CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
                WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (ServerLevel)playerEntity.level(), (int)Math.ceil(playerEntity.getX() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.getY() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.getZ() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
                List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
                if (contexts.isEmpty()) {
                    MythsAndLegends.getLogger().debug("No spawnable contexts found.");
                }
                MythsAndLegends.getLogger().debug("Spawnable contexts found.");
                contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).filter(selection -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selection.getSecond(), keyItemIdentifierPath)).limit(1L).findFirst().ifPresent(selection -> {
                    MythsAndLegends.getLogger().debug("Processing context: " + String.valueOf(selection));
                    SpawnAction spawnAction = ((SpawnDetail)selection.getSecond()).doSpawn((SpawningContext)selection.getFirst());
                    ForceSpawningUtils.handleSpawnAction2(spawnAction);
                });
            }
        }
        MythsAndLegends.getLogger().debug("Force spawning completed.");
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    public static boolean forceSpawnv1command(Player playerEntity, String keyItemIdentifierPath) {
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        if (!Modconfig.enable_force_spawning) {
            MythsAndLegends.getLogger().debug("Force spawning is disabled.");
            return false;
        }
        PlayerDataUtils.checkPlayerInventory(playerEntity);
        MythsAndLegends.getLogger().debug("Force spawning enabled and not client.");
        PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.getUUID());
        SpawnBucket spawn_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> Modconfig.force_spawning_spawn_pool.equalsIgnoreCase(b.name)).findFirst().orElse(null);
        if (spawner != null) {
            SpawnCause cause;
            if (spawn_bucket == null) {
                MythsAndLegends.getLogger().debug("No ultra-rare bucket found.");
                cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (Entity)spawner.getCauseEntity());
                SpawningArea area = spawner.getArea(cause);
                if (area == null) {
                    return false;
                }
            } else {
                MythsAndLegends.getLogger().debug("Ultra-rare bucket found.");
                cause = new SpawnCause((Spawner)spawner, spawn_bucket, (Entity)spawner.getCauseEntity());
                SpawningArea area = spawner.getArea(cause);
                if (area == null) {
                    return false;
                }
                MythsAndLegends.getLogger().debug("SpawningArea and SpawnCause[Ultra-Rare] found.");
            }
            CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
            WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (ServerLevel)playerEntity.level(), (int)Math.ceil(playerEntity.getX() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.getY() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.getZ() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
            List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
            if (contexts.isEmpty()) {
                return false;
            }
            MythsAndLegends.getLogger().debug("Spawnable contexts found.");
            contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).filter(selection -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selection.getSecond(), keyItemIdentifierPath)).limit(1L).findFirst().ifPresent(selection -> {
                MythsAndLegends.getLogger().debug("Processing context: " + String.valueOf(selection));
                SpawnAction spawnAction = ((SpawnDetail)selection.getSecond()).doSpawn((SpawningContext)selection.getFirst());
                ForceSpawningUtils.handleSpawnAction2(spawnAction);
            });
            MythsAndLegends.getLogger().debug("Force spawning completed | TRUE.");
            return true;
        }
        MythsAndLegends.getLogger().debug("Force spawning completed. | FALSE");
        return false;
    }

    public static boolean forceSpawnv1SO(Level world, Player playerEntity, InteractionHand hand, String keyItemIdentifierPath) {
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        ItemStack itemStack = playerEntity.getItemInHand(hand);
        playerEntity.getCooldowns().addCooldown(itemStack.getItem(), Modconfig.force_spawn_item_cooldown);
        if (!Modconfig.enable_force_spawning) {
            MythsAndLegends.getLogger().debug("Force spawning is disabled.");
            return false;
        }
        PlayerDataUtils.checkPlayerInventory(playerEntity);
        if (!world.isClientSide) {
            MythsAndLegends.getLogger().debug("Force spawning enabled and not client.");
            PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.getUUID());
            SpawnBucket spawn_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> Modconfig.force_spawning_spawn_pool.equalsIgnoreCase(b.name)).findFirst().orElse(null);
            if (spawner != null) {
                SpawnCause cause;
                if (spawn_bucket == null) {
                    MythsAndLegends.getLogger().debug("No ultra-rare bucket found.");
                    cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (Entity)spawner.getCauseEntity());
                    SpawningArea area = spawner.getArea(cause);
                    if (area == null) {
                        MythsAndLegends.getLogger().debug("No valid area for spawning found.");
                    }
                } else {
                    MythsAndLegends.getLogger().debug("Ultra-rare bucket found.");
                    cause = new SpawnCause((Spawner)spawner, spawn_bucket, (Entity)spawner.getCauseEntity());
                    SpawningArea area = spawner.getArea(cause);
                    if (area == null) {
                        MythsAndLegends.getLogger().debug("No valid area for spawning found.");
                    }
                    MythsAndLegends.getLogger().debug("SpawningArea and SpawnCause[Ultra-Rare] found.");
                }
                CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
                WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (ServerLevel)playerEntity.level(), (int)Math.ceil(playerEntity.getX() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.getY() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.getZ() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
                List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
                if (contexts.isEmpty()) {
                    MythsAndLegends.getLogger().debug("No spawnable contexts found.");
                }
                MythsAndLegends.getLogger().debug("Spawnable contexts found.");
                contexts.stream().map(context -> spawner.getSpawningSelector().select((Spawner)spawner, List.of(context))).filter(Objects::nonNull).filter(selection -> ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selection.getSecond(), keyItemIdentifierPath)).limit(1L).findFirst().ifPresent(selection -> {
                    MythsAndLegends.getLogger().debug("Processing context: " + String.valueOf(selection));
                    SpawnAction spawnAction = ((SpawnDetail)selection.getSecond()).doSpawn((SpawningContext)selection.getFirst());
                    ForceSpawningUtils.handleSpawnAction2(spawnAction);
                });
            }
        }
        MythsAndLegends.getLogger().debug("Force spawning completed.");
        return true;
    }

    public static InteractionResultHolder<ItemStack> forceSpawnv2(Level world, Player playerEntity, InteractionHand hand, String keyItemIdentifierPath) {
        ItemStack itemStack = playerEntity.getItemInHand(hand);
        ModConfigs Modconfig = MythsAndLegends.getConfigManager().getConfig();
        playerEntity.getCooldowns().addCooldown(itemStack.getItem(), Modconfig.force_spawn_item_cooldown);
        if (!world.isClientSide) {
            PlayerSpawner spawner = (PlayerSpawner)CobblemonWorldSpawnerManager.INSTANCE.getSpawnersForPlayers().get(playerEntity.getUUID());
            SpawnBucket ultra_rare_bucket = Cobblemon.INSTANCE.getBestSpawner().getConfig().getBuckets().stream().filter(b -> "ultra-rare".equalsIgnoreCase(b.name)).findFirst().orElse(null);
            if (spawner != null) {
                SpawnCause cause;
                SpawningArea area;
                if (ultra_rare_bucket == null ? (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, spawner.chooseBucket(), (Entity)spawner.getCauseEntity()))) == null : (area = spawner.getArea(cause = new SpawnCause((Spawner)spawner, ultra_rare_bucket, (Entity)spawner.getCauseEntity()))) == null) {
                    // empty if block
                }
                CobblemonConfig config = Cobblemon.INSTANCE.getConfig();
                WorldSlice slice = spawner.getProspector().prospect((Spawner)spawner, new SpawningArea(cause, (ServerLevel)playerEntity.level(), (int)Math.ceil(playerEntity.getX() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), (int)Math.ceil(playerEntity.getY() - (double)((float)config.getWorldSliceHeight() / 2.0f)), (int)Math.ceil(playerEntity.getZ() - (double)((float)config.getWorldSliceDiameter() / 2.0f)), Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width, Modconfig.force_spawn_check_height == -1 ? config.getWorldSliceHeight() : Modconfig.force_spawn_check_height, Modconfig.force_spawn_check_width == -1 ? config.getWorldSliceDiameter() : Modconfig.force_spawn_check_width));
                List contexts = spawner.getResolver().resolve((Spawner)spawner, spawner.getContextCalculators(), slice);
                if (contexts.isEmpty()) {
                    // empty if block
                }
                for (AreaSpawningContext context : contexts) {
                    Pair selected = spawner.getSpawningSelector().select((Spawner)spawner, List.of(context));
                    if (selected == null || !ForceSpawningUtils.isSpawnDetailForKeyItem((SpawnDetail)selected.getSecond(), keyItemIdentifierPath)) continue;
                    SingleEntitySpawnAction spawnAction = (SingleEntitySpawnAction)((SpawnDetail)selected.getSecond()).doSpawn((SpawningContext)selected.getFirst());
                    Entity entityToSpawn = Objects.requireNonNull(spawnAction.createEntity());
                    CobblemonEvents.ENTITY_SPAWN.postThen((Cancelable)new SpawnEvent(entityToSpawn, (SpawningContext)selected.getFirst()), event -> Unit.INSTANCE, ifSucceeded -> {
                        ((SpawningContext)selected.getFirst()).getWorld().addFreshEntity(entityToSpawn);
                        return Unit.INSTANCE;
                    });
                    if (playerEntity.getAbilities().instabuild) break;
                    itemStack.shrink(1);
                    break;
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    private static boolean isSpawnDetailForKeyItem(SpawnDetail detail, String keyItemIdentifierPath) {
        MythsAndLegends.getLogger().debug("Detail Display Name:" + detail.getDisplayName() + " Detail Id: " + detail.getId());
        for (SpawningCondition condition : detail.getConditions()) {
            if (condition instanceof SpawningConditionMixin) {
                SpawningConditionMixin conditionMixin = (SpawningConditionMixin)condition;
                List<AppendageCondition> appendages = conditionMixin.getAppendages();
                for (AppendageCondition appendage : appendages) {
                    if (appendage instanceof KeyItemCondition) {
                        KeyItemCondition keyItemCondition = (KeyItemCondition)appendage;
                        if (keyItemCondition.getItemCondtionIdentifier() != null) {
                            MythsAndLegends.getLogger().debug("Found key item condition: " + keyItemCondition.getItemCondtionIdentifier().getNamespace() + keyItemCondition.getItemCondtionIdentifier().getPath());
                            return keyItemCondition.getItemCondtionIdentifier().getPath().equals(keyItemIdentifierPath);
                        }
                        MythsAndLegends.getLogger().debug("Key item condition has no item condition identifier.");
                        return false;
                    }
                    MythsAndLegends.getLogger().debug("Appendage is not a key item condition.");
                }
                MythsAndLegends.getLogger().debug("No appendages found.");
            }
            MythsAndLegends.getLogger().debug("Condition is not a mixin.");
        }
        MythsAndLegends.getLogger().debug("No conditions found.");
        return false;
    }

    public static void handleSpawnAction(SpawnAction<?> spawnAction) {
        ((CompletableFuture)((CompletableFuture)spawnAction.getFuture().thenAccept(result -> {
            if (result instanceof EntitySpawnResult) {
                EntitySpawnResult entitySpawnResult = (EntitySpawnResult)result;
            }
        })).exceptionally(throwable -> null)).thenRun(() -> spawnAction.complete());
    }

    public static void handleSpawnAction2(SpawnAction<?> spawnAction) {
        spawnAction.complete();
        ((CompletableFuture)spawnAction.getFuture().thenAccept(result -> {
            if (result instanceof EntitySpawnResult) {
                EntitySpawnResult entitySpawnResult = (EntitySpawnResult)result;
            }
        })).exceptionally(throwable -> null);
    }
}

