/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.events;

import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import com.github.d0ctorleon.mythsandlegends.utils.PlayerDataUtils;
import dev.architectury.event.events.common.TickEvent;
import java.util.Random;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class TickEvents {
    private static final Random random = new Random();
    private static int nextInventoryCheckTick = 0;

    public TickEvents() {
        TickEvent.SERVER_PRE.register(this::onServerPreTick);
        TickEvent.SERVER_POST.register(this::onServerPostTick);
        TickEvent.SERVER_LEVEL_PRE.register(this::onServerLevelPreTick);
        TickEvent.SERVER_LEVEL_POST.register(this::onServerLevelPostTick);
        TickEvent.PLAYER_PRE.register(this::onPlayerPreTick);
        TickEvent.PLAYER_POST.register(this::onPlayerPostTick);
        MythsAndLegends.getLogger().info("Tick Events Registered");
    }

    private static void scheduleNextInventoryCheck(int currentTick, int interval) {
        int offset = random.nextInt(interval);
        nextInventoryCheckTick = currentTick + offset;
    }

    public void onServerLevelPreTick(ServerLevel level) {
        if (level.getGameTime() % 200L == 0L) {
            // empty if block
        }
    }

    public void onServerLevelPostTick(ServerLevel level) {
    }

    public void onServerPreTick(MinecraftServer server) {
        if (server.getTickCount() % 100 == 0) {
            // empty if block
        }
    }

    public void onServerPostTick(MinecraftServer server) {
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        int inventoryCheckInterval = config.inventory_check_interval;
        if (nextInventoryCheckTick == 0) {
            TickEvents.scheduleNextInventoryCheck(server.getTickCount(), inventoryCheckInterval);
        }
        if (server.getTickCount() >= nextInventoryCheckTick) {
            for (Player player : server.getPlayerList().getPlayers()) {
                PlayerDataUtils.checkPlayerInventory(player);
            }
            TickEvents.scheduleNextInventoryCheck(server.getTickCount(), inventoryCheckInterval);
        }
    }

    public void onPlayerPreTick(Player player) {
    }

    public void onPlayerPostTick(Player player) {
    }
}

