/*
 * Decompiled with CFR 0.152.
 */
package com.github.d0ctorleon.mythsandlegends.cobblemon.events;

import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.d0ctorleon.mythsandlegends.MythsAndLegends;
import com.github.d0ctorleon.mythsandlegends.cobblemon.spawning.condition.MythsAndLegendsConditions;
import com.github.d0ctorleon.mythsandlegends.configs.BroadcastSettings;
import com.github.d0ctorleon.mythsandlegends.configs.ModConfigs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class SpawnEventListener {
    public static void onPokemonSpawn(SpawnEvent<PokemonEntity> event) {
        boolean shouldBroadcastShiny;
        ModConfigs config = MythsAndLegends.getConfigManager().getConfig();
        boolean isBroadcastEnabled = config.isBroadcastEnabled;
        if (!isBroadcastEnabled) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)event.getEntity();
        Pokemon pokemon = pokemonEntity.getPokemon();
        if (pokemon.isPlayerOwned()) {
            return;
        }
        boolean isLegendary = pokemon.isLegendary();
        boolean isMythical = pokemon.isMythical();
        boolean isUltraBeast = pokemon.isUltraBeast();
        boolean isShiny = pokemon.getShiny();
        boolean bl = shouldBroadcastShiny = SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny") && isShiny;
        if (!(isLegendary || isMythical || isUltraBeast || shouldBroadcastShiny)) {
            return;
        }
        SpawningContext ctx = event.getCtx();
        Spawner spawner = ctx.getSpawner();
        ServerPlayer player = null;
        MinecraftServer server = null;
        if (spawner instanceof PlayerSpawner) {
            PlayerSpawner playerSpawner = (PlayerSpawner)spawner;
            player = MythsAndLegendsConditions.getPlayerFromUUID(ctx.getWorld(), playerSpawner.getUuid());
            if (player != null) {
                server = player.getServer();
            }
        }
        MutableComponent PokemonDisplayName = pokemon.getDisplayName();
        BlockPos pos = pokemonEntity.blockPosition();
        MutableComponent message = Component.translatable((String)"chat.broadcast.spawn", (Object[])new Object[]{PokemonDisplayName});
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Location")) {
            message.append((Component)Component.translatable((String)"chat.broadcast.location", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GREEN));
        }
        if (pokemon.isLegendary() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Legendarys")) {
            message.append((Component)Component.translatable((String)"chat.broadcast.legendary").withStyle(ChatFormatting.GOLD));
        }
        if (pokemon.isMythical() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Mythicals")) {
            message.append((Component)Component.translatable((String)"chat.broadcast.mythical").withStyle(ChatFormatting.DARK_PURPLE));
        }
        if (pokemon.isUltraBeast() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "UltraBeasts")) {
            message.append((Component)Component.translatable((String)"chat.broadcast.ultrabeast").withStyle(ChatFormatting.DARK_AQUA));
        }
        if (pokemon.getShiny() && SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Shiny")) {
            message.append((Component)Component.translatable((String)"chat.broadcast.shiny").withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "Level")) {
            int level = pokemon.getLevel();
            message.append((Component)Component.translatable((String)"chat.broadcast.level", (Object[])new Object[]{level}).withStyle(ChatFormatting.YELLOW));
        }
        if (SpawnEventListener.findBroadcastConfig(config.broadcast_settings, "BroadcastToAll")) {
            if (server != null) {
                SpawnEventListener.broadcastMessageToServer((Component)message, server);
            }
        } else if (player != null) {
            player.sendSystemMessage((Component)message);
        }
    }

    private static boolean findBroadcastConfig(List<BroadcastSettings> settings, String settingName) {
        for (BroadcastSettings setting : settings) {
            if (!setting.settingName.equalsIgnoreCase(settingName)) continue;
            return setting.settingValue;
        }
        return false;
    }

    private static void broadcastMessageToServer(Component message, MinecraftServer server) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            player.displayClientMessage(message, false);
        }
    }
}

