/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.logic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.util.MapRenderer;
import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.util.NMSWrapper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class HeldItemHandler {
    private Item filledMap = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "filled_map"));
    private Item book = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "book"));
    private Item writtenBook = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "written_book"));
    private Item writableBook = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "writable_book"));
    private Item enchantedBook = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "enchanted_book"));
    private Item knowledgeBook = NMSHelper.getItem(NMSHelper.getResourceLocation("minecraft", "knowledge_book"));
    public Set<Item> books = new HashSet<Item>(Arrays.asList(this.writableBook, this.writtenBook, this.enchantedBook, this.knowledgeBook, this.book));
    public Map<Item, ResourceLocation> bookTextures = new HashMap<Item, ResourceLocation>(){
        {
            this.put(HeldItemHandler.this.knowledgeBook, NMSHelper.getResourceLocation("notenoughanimations", "textures/recipe_book.png"));
        }
    };
    public Set<Item> glintingBooks = new HashSet<Item>(Arrays.asList(this.enchantedBook));
    private BookModel bookModel = null;

    public void onRenderItem(LivingEntity entity, EntityModel<?> model, ItemStack itemStack, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo info) {
        if (this.bookModel == null) {
            this.bookModel = new BookModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BOOK));
        }
        if (entity.isSleeping()) {
            if (NEABaseMod.config.dontHoldItemsInBed) {
                info.cancel();
            }
            return;
        }
        if (NMSWrapper.hasCustomModel(itemStack)) {
            return;
        }
        if (model instanceof ArmedModel) {
            ArmedModel armedModel = (ArmedModel)model;
            if (model instanceof HumanoidModel) {
                HumanoidModel humanoid = (HumanoidModel)model;
                if (arm == HumanoidArm.RIGHT && humanoid.rightArm.visible || arm == HumanoidArm.LEFT && humanoid.leftArm.visible) {
                    if (NEABaseMod.config.enableInWorldMapRendering) {
                        if (arm == entity.getMainArm() && entity.getMainHandItem().getItem().equals(this.filledMap)) {
                            matrices.pushPose();
                            armedModel.translateToHand(arm, matrices);
                            matrices.mulPose(NMSHelper.XP.rotationDegrees(-90.0f));
                            matrices.mulPose(NMSHelper.YP.rotationDegrees(200.0f));
                            boolean bl = arm == HumanoidArm.LEFT;
                            matrices.translate((double)((float)(bl ? -1 : 1) / 16.0f), 0.125 + (entity.getOffhandItem().isEmpty() ? 0.15 : 0.0), -0.625);
                            MapRenderer.renderFirstPersonMap(matrices, vertexConsumers, light, itemStack, !entity.getOffhandItem().isEmpty(), entity.getMainArm() == HumanoidArm.LEFT);
                            matrices.popPose();
                            info.cancel();
                            return;
                        }
                        if (arm != entity.getMainArm() && entity.getOffhandItem().getItem().equals(this.filledMap)) {
                            matrices.pushPose();
                            armedModel.translateToHand(arm, matrices);
                            matrices.mulPose(NMSHelper.XP.rotationDegrees(-90.0f));
                            matrices.mulPose(NMSHelper.YP.rotationDegrees(200.0f));
                            boolean bl = arm == HumanoidArm.LEFT;
                            matrices.translate((double)((float)(bl ? -1 : 1) / 16.0f), 0.125, -0.625);
                            MapRenderer.renderFirstPersonMap(matrices, vertexConsumers, light, itemStack, true, false);
                            matrices.popPose();
                            info.cancel();
                            return;
                        }
                    }
                    if (NEABaseMod.config.enableInWorldBookRendering) {
                        Item item = entity.getMainHandItem().getItem();
                        if (arm == entity.getMainArm() && this.books.contains(item)) {
                            this.renderBook(entity, 0.0f, itemStack, arm, matrices, vertexConsumers, light, armedModel, this.glintingBooks.contains(item), item);
                            info.cancel();
                            return;
                        }
                        item = entity.getOffhandItem().getItem();
                        if (arm != entity.getMainArm() && this.books.contains(item)) {
                            this.renderBook(entity, 0.0f, itemStack, arm, matrices, vertexConsumers, light, armedModel, this.glintingBooks.contains(item), item);
                            info.cancel();
                            return;
                        }
                    }
                }
            }
        }
        if (NEABaseMod.config.enableOffhandHiding && entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            HumanoidModel.ArmPose armPose = AnimationUtil.getArmPose(player, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose armPose2 = AnimationUtil.getArmPose(player, InteractionHand.OFF_HAND);
            if (!AnimationUtil.isUsingboothHands(armPose) && !AnimationUtil.isUsingboothHands(armPose2)) {
                return;
            }
            if (armPose.isTwoHanded()) {
                HumanoidModel.ArmPose armPose3 = armPose2 = player.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (player.getMainArm() == HumanoidArm.RIGHT) {
                if (arm == HumanoidArm.RIGHT && AnimationUtil.isUsingboothHands(armPose2)) {
                    info.cancel();
                    return;
                }
                if (arm == HumanoidArm.LEFT && AnimationUtil.isUsingboothHands(armPose)) {
                    info.cancel();
                    return;
                }
            } else {
                if (arm == HumanoidArm.LEFT && AnimationUtil.isUsingboothHands(armPose2)) {
                    info.cancel();
                    return;
                }
                if (arm == HumanoidArm.RIGHT && AnimationUtil.isUsingboothHands(armPose)) {
                    info.cancel();
                    return;
                }
            }
        }
    }

    private void renderBook(LivingEntity entity, float delta, ItemStack itemStack, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmedModel armedModel, boolean glow, Item item) {
        matrices.pushPose();
        armedModel.translateToHand(arm, matrices);
        matrices.mulPose(NMSHelper.YP.rotationDegrees(100.0f));
        matrices.mulPose(NMSHelper.ZP.rotationDegrees(-100.0f));
        matrices.translate(-0.56, 0.34, 0.0);
        float g = (float)entity.tickCount + delta;
        float l = 0.0f;
        float m = Mth.frac((float)(l + 0.25f)) * 1.6f - 0.3f;
        float n = Mth.frac((float)(l + 0.75f)) * 1.6f - 0.3f;
        float o = 1.0f;
        this.bookModel.setupAnim(g, Mth.clamp((float)m, (float)0.0f, (float)1.0f), Mth.clamp((float)n, (float)0.0f, (float)1.0f), o);
        VertexConsumer vertexConsumer = this.bookTextures.containsKey(item) ? ItemRenderer.getFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)RenderType.entitySolid((ResourceLocation)this.bookTextures.get(item)), (boolean)true, (boolean)glow) : EnchantTableRenderer.BOOK_LOCATION.buffer(vertexConsumers, RenderType::entitySolid, glow);
        this.bookModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, Integer.MAX_VALUE);
        matrices.popPose();
        if (item == this.writtenBook) {
            matrices.pushPose();
            armedModel.translateToHand(arm, matrices);
            this.renderText(entity, matrices, itemStack, armedModel, arm);
            matrices.popPose();
        }
    }

    private void renderText(LivingEntity entity, PoseStack matrices, ItemStack itemStack, ArmedModel armedModel, HumanoidArm arm) {
    }
}

