/*
 * Decompiled with CFR 0.152.
 */
package org.hiedacamellia.languagereload.client.gui;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.hiedacamellia.languagereload.client.gui.LanguageEntry;
import org.hiedacamellia.languagereload.core.access.ILanguageOptionsScreen;
import org.hiedacamellia.languagereload.core.mixin.EntryListWidgetAccessor;
import org.jetbrains.annotations.Nullable;

public class LanguageListWidget
extends ObjectSelectionList<LanguageEntry> {
    private final Component title;
    private final LanguageSelectScreen screen;

    public LanguageListWidget(Minecraft client, LanguageSelectScreen screen, int width, int height, Component title) {
        super(client, width, height - 83 - 16, 48, 24);
        this.title = title;
        this.screen = screen;
        this.setRenderHeader(true, 13);
        this.centerListVertically = false;
    }

    protected void renderHeader(GuiGraphics context, int x, int y) {
        MutableComponent headerText = this.title.copy().withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.BOLD});
        int headerPosX = x + this.width / 2 - this.minecraft.font.width((FormattedText)headerText) / 2;
        int headerPosY = Math.min(this.getY() + 3, y);
        context.drawString(this.minecraft.font, (Component)headerText, headerPosX, headerPosY, 0xFFFFFF, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        LanguageEntry selectedEntry = (LanguageEntry)this.getSelected();
        if (selectedEntry == null) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (keyCode == 32 || keyCode == 257) {
            selectedEntry.toggle();
            this.setFocused(null);
            ((ILanguageOptionsScreen)this.screen).languagereload_focusEntry(selectedEntry);
            return true;
        }
        if (Screen.hasShiftDown()) {
            if (keyCode == 264) {
                selectedEntry.moveDown();
                return true;
            }
            if (keyCode == 265) {
                selectedEntry.moveUp();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        LanguageEntry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry == null && button == 0) {
            return true;
        }
        if (entry != null && entry.mouseClicked(mouseX, mouseY, button)) {
            LanguageEntry focusedEntry = (LanguageEntry)this.getFocused();
            if (focusedEntry != entry && focusedEntry instanceof ContainerEventHandler) {
                ContainerEventHandler parentElement = (ContainerEventHandler)focusedEntry;
                parentElement.setFocused(null);
            }
            this.setDragging(true);
            return true;
        }
        return ((EntryListWidgetAccessor)((Object)this)).languagereload_isScrolling();
    }

    @Nullable
    public LanguageEntry getEntryAtPosition(double x, double y) {
        int halfRowWidth = this.getRowWidth() / 2;
        int center = this.getX() + this.width / 2;
        int minX = center - halfRowWidth;
        int maxX = center + halfRowWidth;
        int m = Mth.floor((double)(y - (double)this.getY())) - this.headerHeight + (int)this.getScrollAmount() - 4 + 2;
        int entryIndex = m / this.itemHeight;
        boolean hasScrollbar = this.scrollbarVisible();
        int scrollbarX = this.getScrollbarPosition();
        int entryCount = this.getItemCount();
        return x >= (double)minX && x <= (double)maxX && (!hasScrollbar || x < (double)scrollbarX) && entryIndex >= 0 && m >= 0 && entryIndex < entryCount ? (LanguageEntry)((Object)this.children().get(entryIndex)) : null;
    }

    public LanguageSelectScreen getScreen() {
        return this.screen;
    }

    public int getRowHeight() {
        return this.itemHeight;
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    public void updateScroll() {
        this.setScrollAmount(this.getScrollAmount());
    }
}

