/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;

public class SetCurioAttributesFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetCurioAttributesFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetCurioAttributesFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)ExtraCodecs.nonEmptyList((Codec)Modifier.MODIFIER_CODEC.listOf()).fieldOf("modifiers").forGetter(function -> function.modifiers), (App)Codec.BOOL.optionalFieldOf("replace", (Object)Boolean.TRUE).forGetter(function -> function.replace))).apply((Applicative)instance, SetCurioAttributesFunction::new));
    public static LootItemFunctionType<SetCurioAttributesFunction> TYPE = null;
    final List<Modifier> modifiers;
    final boolean replace;

    SetCurioAttributesFunction(List<LootItemCondition> conditions, List<Modifier> modifiers, boolean replace) {
        super(conditions);
        this.modifiers = ImmutableList.copyOf(modifiers);
        this.replace = replace;
    }

    public static void register() {
        TYPE = (LootItemFunctionType)Registry.register((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"set_curio_attributes"), (Object)new LootItemFunctionType(CODEC));
    }

    @Nonnull
    public LootItemFunctionType<SetCurioAttributesFunction> getType() {
        return TYPE;
    }

    @Nonnull
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return (Set)this.modifiers.stream().flatMap(mod -> mod.amount.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public ItemStack run(@Nonnull ItemStack stack, LootContext context) {
        RandomSource random = context.getRandom();
        for (Modifier modifier : this.modifiers) {
            String slot = (String)Util.getRandom(modifier.slots, (RandomSource)random);
            Object object = modifier.attribute.value();
            if (object instanceof SlotAttribute) {
                SlotAttribute wrapper = (SlotAttribute)((Object)object);
                CuriosApi.addSlotModifier(stack, wrapper.getIdentifier(), modifier.id, modifier.amount.getFloat(context), modifier.operation, slot);
                continue;
            }
            CuriosApi.addModifier(stack, modifier.attribute, modifier.id, modifier.amount.getFloat(context), modifier.operation, slot);
        }
        return stack;
    }

    record Modifier(String name, Holder<Attribute> attribute, AttributeModifier.Operation operation, NumberProvider amount, ResourceLocation id, List<String> slots) {
        private static final Codec<List<String>> SLOTS_CODEC = ExtraCodecs.nonEmptyList((Codec)Codec.either((Codec)Codec.STRING, (Codec)Codec.list((Codec)Codec.STRING)).xmap(either -> (List)either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((String)list.getFirst())) : Either.right((Object)list)));
        private static final Codec<Holder<Attribute>> ATTRIBUTE_CODEC = new PrimitiveCodec<Holder<Attribute>>(){

            public <T> DataResult<Holder<Attribute>> read(DynamicOps<T> ops, T input) {
                return ops.getStringValue(input).map(name -> {
                    Holder<Attribute> attribute;
                    ResourceLocation rl = ResourceLocation.tryParse((String)name);
                    if (rl == null) {
                        return null;
                    }
                    if (rl.getNamespace().equals("curios")) {
                        String identifier = rl.getPath();
                        if (CuriosApi.getSlot(identifier, false).isEmpty()) {
                            throw new JsonSyntaxException("Unknown curios slot type: " + identifier);
                        }
                        attribute = SlotAttribute.getOrCreate(identifier);
                    } else {
                        attribute = BuiltInRegistries.ATTRIBUTE.getHolder(rl).orElse(null);
                    }
                    return attribute;
                });
            }

            public <T> T write(DynamicOps<T> ops, Holder<Attribute> value) {
                ResourceLocation rl;
                Object object = value.value();
                if (object instanceof SlotAttribute) {
                    SlotAttribute wrapper = (SlotAttribute)((Object)object);
                    rl = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)wrapper.getIdentifier());
                } else {
                    rl = BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)value.value()));
                }
                return (T)(rl != null ? ops.createString(rl.toString()) : ops.empty());
            }
        };
        public static final Codec<Modifier> MODIFIER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Modifier::name), (App)ATTRIBUTE_CODEC.fieldOf("attribute").forGetter(Modifier::attribute), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(Modifier::operation), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(Modifier::amount), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(Modifier::id), (App)SLOTS_CODEC.fieldOf("slot").forGetter(Modifier::slots)).apply((Applicative)instance, Modifier::new));
    }
}

