/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;

public class CompositeRegistryCodec<A>
implements Codec<A> {
    private final Codec<A> primaryCodec;
    private final ResourceKey<Registry<A>> secondaryKey;
    private Codec<A> secondaryCodec;

    private CompositeRegistryCodec(Codec<A> primaryCodec, ResourceKey<Registry<A>> secondaryKey) {
        this.primaryCodec = primaryCodec;
        this.secondaryKey = secondaryKey;
    }

    public static <T> CompositeRegistryCodec<T> of(Codec<T> primaryCodec, ResourceKey<Registry<T>> secondaryKey) {
        return new CompositeRegistryCodec<T>(primaryCodec, secondaryKey);
    }

    public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
        DataResult result = this.primaryCodec.decode(ops, input);
        if (result.error().isEmpty() || ops.compressMaps()) {
            return result;
        }
        if (this.secondaryCodec == null) {
            Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(this.secondaryKey.location());
            if (registry == null) {
                return result;
            }
            this.secondaryCodec = registry.byNameCodec();
        }
        return this.secondaryCodec.decode(ops, input);
    }

    public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
        DataResult result = this.primaryCodec.encode(input, ops, prefix);
        if (result.error().isEmpty() || ops.compressMaps()) {
            return result;
        }
        if (this.secondaryCodec == null) {
            Registry registry = (Registry)BuiltInRegistries.REGISTRY.get(this.secondaryKey.location());
            if (registry == null) {
                return result;
            }
            this.secondaryCodec = registry.byNameCodec();
        }
        return this.secondaryCodec.encode(input, ops, prefix);
    }
}

