/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.roughlyenoughprofessions.profession;

import com.mrbysco.roughlyenoughprofessions.RenderHelper;
import com.mrbysco.roughlyenoughprofessions.platform.Services;
import com.mrbysco.roughlyenoughprofessions.profession.ProfessionEntry;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;

public class ProfessionDisplay {
    protected final ProfessionEntry entry;

    public ProfessionDisplay(ProfessionEntry entry) {
        this.entry = entry;
    }

    public ResourceLocation getProfessionName() {
        return Services.PLATFORM.getProfessionID(this.entry.profession());
    }

    public Component getDisplayName() {
        ResourceLocation professionKey = this.getProfessionName();
        String languageKey = professionKey.toLanguageKey();
        if (languageKey.startsWith("minecraft.")) {
            languageKey = languageKey.replace("minecraft.", "");
        }
        return Component.translatable((String)("entity.minecraft.villager." + languageKey));
    }

    public List<ItemStack> getBlockStacks() {
        return this.entry.blockStacks();
    }

    public void drawEntry(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Villager entityVillager = this.entry.getVillagerEntity();
        if (entityVillager != null) {
            RenderHelper.renderEntity(guiGraphics, 22, 62, 25.0, Mth.wrapDegrees((double)(38.0 - mouseX)), Mth.wrapDegrees((double)(15.0 - mouseY)), (LivingEntity)entityVillager);
        }
    }
}

