/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.graphics.shader.PositionTexAlphaTestShader;

public class DirectRender {
    public static void coloredRectangle(PoseStack matrices, float x1, float y1, float x2, float y2, int color) {
        DirectRender.coloredRectangle(matrices.last().pose(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        DirectRender.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f, true);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha, boolean blend) {
        if (discardAlpha < 0.0f) {
            RenderSystem.setShader(blend ? () -> MinimapShaders.POSITION_TEX_NO_ALPHA_TEST : () -> MinimapShaders.POSITION_TEX_NO_ALPHA_TEST_NO_BLEND);
        } else {
            RenderSystem.setShader(blend ? () -> MinimapShaders.POSITION_TEX_ALPHA_TEST : () -> MinimapShaders.POSITION_TEX_ALPHA_TEST_NO_BLEND);
            ((PositionTexAlphaTestShader)RenderSystem.getShader()).setDiscardAlpha(discardAlpha);
        }
        DirectRender.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }

    private static void texturedRectInternal(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + height, 0.0f).setUv((float)(textureX + 0) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + height, 0.0f).setUv(((float)textureX + width) * f, (float)(textureY + 0) * f1);
        vertexBuffer.addVertex(matrix, x + width, y + 0.0f, 0.0f).setUv(((float)textureX + width) * f, ((float)textureY + textureH) * f1);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + 0.0f, 0.0f).setUv((float)(textureX + 0) * f, ((float)textureY + textureH) * f1);
        BufferUploader.drawWithShader((MeshData)vertexBuffer.build());
    }

    public static void drawOutlineLayer(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        MinimapShaders.POSITION_TEX_ICON_OUTLINE.setDiscardAlpha(discardAlpha);
        RenderSystem.setShader(() -> MinimapShaders.POSITION_TEX_ICON_OUTLINE);
        DirectRender.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
    }
}

