/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message.payload;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapMessageHandlerFull;
import xaero.common.message.payload.MinimapMessagePayload;
import xaero.common.message.type.MinimapMessageType;

public class MinimapMessagePayloadCodec
implements StreamCodec<FriendlyByteBuf, MinimapMessagePayload<?>> {
    private final MinimapMessageHandlerFull messageHandler;

    public MinimapMessagePayloadCodec(MinimapMessageHandlerFull messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void encode(FriendlyByteBuf buf, MinimapMessagePayload<?> payload) {
        this.messageHandler.encodeMessage(payload.getType(), (MinimapMessage<?>)payload.getMsg(), buf);
    }

    public MinimapMessagePayload<?> decode(FriendlyByteBuf friendlyByteBuf) {
        byte index = friendlyByteBuf.readByte();
        MinimapMessageType<?> messageType = this.messageHandler.getByIndex(index);
        if (messageType == null) {
            return null;
        }
        return this.createTypedPayload(messageType, friendlyByteBuf);
    }

    private <T extends MinimapMessage<T>> MinimapMessagePayload<T> createTypedPayload(MinimapMessageType<T> messageType, FriendlyByteBuf friendlyByteBuf) {
        return new MinimapMessagePayload<MinimapMessage>(messageType, (MinimapMessage)messageType.getDecoder().apply(friendlyByteBuf));
    }
}

