/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform;

import architectury_inject_architectury_common_47250920f34245459095f33f44b42f2b_d1717bfde6e7ed62c26cd7cb030875d2d88c73e5922f53b9865970a5fb0f19f6architectury1305devjar.PlatformMethods;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Mod;
import dev.architectury.platform.forge.PlatformImpl;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.neoforged.api.distmarker.Dist;

public final class Platform {
    private static int simpleLoaderCache = -1;

    private Platform() {
    }

    public static boolean isFabric() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 0;
    }

    @Deprecated(forRemoval=true)
    public static boolean isForge() {
        return Platform.isForgeLike();
    }

    public static boolean isForgeLike() {
        return Platform.isMinecraftForge() || Platform.isNeoForge();
    }

    public static boolean isMinecraftForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 1;
    }

    public static boolean isNeoForge() {
        Platform.updateLoaderCache();
        return simpleLoaderCache == 2;
    }

    private static void updateLoaderCache() {
        if (simpleLoaderCache != -1) {
            return;
        }
        switch (PlatformMethods.getCurrentTarget()) {
            case "fabric": {
                simpleLoaderCache = 0;
                break;
            }
            case "forge": {
                simpleLoaderCache = 1;
                break;
            }
            case "neoforge": {
                simpleLoaderCache = 2;
            }
        }
    }

    public static String getMinecraftVersion() {
        return SharedConstants.getCurrentVersion().getId();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameFolder() {
        return PlatformImpl.getGameFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigFolder() {
        return PlatformImpl.getConfigFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getModsFolder() {
        return PlatformImpl.getModsFolder();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getEnvironment() {
        return PlatformImpl.getEnvironment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Dist getEnv() {
        return PlatformImpl.getEnv();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String id) {
        return PlatformImpl.isModLoaded(id);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Mod getMod(String id) {
        return PlatformImpl.getMod(id);
    }

    public static Optional<Mod> getOptionalMod(String id) {
        try {
            return Optional.of(Platform.getMod(id));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<Mod> getMods() {
        return PlatformImpl.getMods();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Collection<String> getModIds() {
        return PlatformImpl.getModIds();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopmentEnvironment() {
        return PlatformImpl.isDevelopmentEnvironment();
    }
}

