/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.util;

import com.misterpemodder.shulkerboxtooltip.api.config.ItemStackMergingStrategy;
import com.misterpemodder.shulkerboxtooltip.impl.util.ItemKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MergedItemStack
implements Comparable<MergedItemStack> {
    private ItemStack merged = ItemStack.EMPTY;
    private final NonNullList<ItemStack> subItems;
    private int firstSlot;

    public MergedItemStack(int slotCount) {
        this.subItems = NonNullList.withSize((int)slotCount, (Object)ItemStack.EMPTY);
        this.firstSlot = Integer.MAX_VALUE;
    }

    public ItemStack get() {
        return this.merged;
    }

    public void add(ItemStack stack, int slot, ItemStackMergingStrategy mergingStrategy) {
        if (slot < 0 || slot >= this.subItems.size()) {
            return;
        }
        this.subItems.set(slot, (Object)stack.copy());
        if (slot < this.firstSlot) {
            this.firstSlot = slot;
        }
        if (this.merged.isEmpty()) {
            this.merged = mergingStrategy == ItemStackMergingStrategy.IGNORE ? MergedItemStack.copyStackWithoutComponents(stack) : stack.copy();
        } else {
            this.merged.grow(stack.getCount());
        }
    }

    private static ItemStack copyStackWithoutComponents(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack copy = new ItemStack((ItemLike)stack.getItem(), stack.getCount());
        copy.setPopTime(stack.getPopTime());
        return copy;
    }

    public ItemStack getSubStack(int slot) {
        if (slot < 0 || slot >= this.subItems.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.subItems.get(slot);
    }

    public int size() {
        return this.subItems.size();
    }

    @Override
    public int compareTo(MergedItemStack other) {
        int ret = this.merged.getCount() - other.merged.getCount();
        if (ret != 0) {
            return ret;
        }
        return other.firstSlot - this.firstSlot;
    }

    public static List<MergedItemStack> mergeInventory(List<ItemStack> inventory, int maxSize, ItemStackMergingStrategy mergingStrategy) {
        ArrayList<MergedItemStack> items = new ArrayList<MergedItemStack>();
        if (!inventory.isEmpty()) {
            HashMap<ItemKey, MergedItemStack> mergedStacks = new HashMap<ItemKey, MergedItemStack>();
            int len = inventory.size();
            for (int i = 0; i < len; ++i) {
                ItemStack s = inventory.get(i);
                if (s.isEmpty()) continue;
                ItemKey k = new ItemKey(s, mergingStrategy != ItemStackMergingStrategy.SEPARATE);
                MergedItemStack mergedStack = (MergedItemStack)mergedStacks.get(k);
                if (mergedStack == null) {
                    mergedStack = new MergedItemStack(maxSize);
                    mergedStacks.put(k, mergedStack);
                }
                mergedStack.add(s, i, mergingStrategy);
            }
            items.addAll(mergedStacks.values());
            items.sort(Comparator.reverseOrder());
        }
        return items;
    }
}

