const { chromium } = require('playwright');

const url = process.argv[2];
const delay = parseInt(process.argv[3] || '5000');
const proxy = process.argv[4]; // format: http://user:pass@host:port or http://host:port

if (!url) {
  console.error('Usage: node printPageProxy.js <url> [wait_ms] [proxy]');
  process.exit(1);
}


(async () => {
  const browser = await chromium.launch({
    proxy: proxy ? { server: proxy } : undefined
  });

  const page = await browser.newPage();

  await page.goto(url);
  await page.waitForTimeout(delay);

  const content = await page.content();
  console.log(content);

  await browser.close();
})();
