/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.ability.teleportondeath;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.TeleportOnDeathAbility;
import artifacts.network.ChorusTotemUsedPacket;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"checkTotemDeathProtection(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemDeathProtection(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        Level level;
        LivingEntity entity = (LivingEntity)this;
        ItemStack totem = TeleportOnDeathAbility.findTotem(entity);
        if (!totem.isEmpty() && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                AbilityHelper.getAbilities((ArtifactAbility.Type)ModAbilities.TELEPORT_ON_DEATH.value(), totem).findFirst().ifPresent(ability -> {
                    if ((Double)ability.teleportationChance().get() > entity.getRandom().nextDouble()) {
                        Player player;
                        TeleportOnDeathAbility.teleport(entity, level2);
                        if (((Boolean)ability.consumedOnUse().get()).booleanValue()) {
                            totem.shrink(1);
                        } else if (entity instanceof Player) {
                            player = (Player)entity;
                            player.getCooldowns().addCooldown(totem.getItem(), (Integer)ability.cooldown().get() * 20);
                        }
                        entity.setHealth(Math.min(entity.getMaxHealth(), (float)Math.max(1, (Integer)ability.healthRestored().get())));
                        if (entity instanceof ServerPlayer) {
                            player = (ServerPlayer)entity;
                            entity.level().playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ChorusTotemUsedPacket());
                        }
                        cir.setReturnValue((Object)true);
                    }
                });
            }
        }
    }
}

