/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client;

import artifacts.ability.ArtifactAbility;
import artifacts.component.AbilityToggles;
import artifacts.network.ToggleArtifactPacket;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModAbilities;
import artifacts.registry.ModKeyMappings;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;

public class ToggleKeyHandler {
    private static final Map<ArtifactAbility.Type<?>, KeyMapping> TOGGLE_KEY_MAPPINGS = new HashMap();

    public static void register() {
        ToggleKeyHandler.addToggleInputHandler((ArtifactAbility.Type)ModAbilities.NIGHT_VISION.value(), ModKeyMappings.TOGGLE_NIGHT_VISION_GOGGLES);
        ToggleKeyHandler.addToggleInputHandler((ArtifactAbility.Type)ModAbilities.ATTRACT_ITEMS.value(), ModKeyMappings.TOGGLE_UNIVERSAL_ATTRACTOR);
    }

    public static KeyMapping getToggleKey(ArtifactAbility.Type<?> ability) {
        return TOGGLE_KEY_MAPPINGS.get(ability);
    }

    private static void addToggleInputHandler(ArtifactAbility.Type<?> ability, KeyMapping toggleKey) {
        TOGGLE_KEY_MAPPINGS.put(ability, toggleKey);
        ToggleInputHandler handler = new ToggleInputHandler(ability);
        ClientTickEvent.CLIENT_PRE.register(instance -> handler.onClientTick());
    }

    private static class ToggleInputHandler {
        private boolean wasToggleKeyDown;
        private final ArtifactAbility.Type<?> ability;

        public ToggleInputHandler(ArtifactAbility.Type<?> ability) {
            this.ability = ability;
        }

        public void onClientTick() {
            AbilityToggles abilityToggles;
            boolean isToggleKeyDown = ToggleKeyHandler.getToggleKey(this.ability).isDown();
            if (isToggleKeyDown && !this.wasToggleKeyDown && (abilityToggles = PlatformServices.platformHelper.getAbilityToggles((LivingEntity)Minecraft.getInstance().player)) != null) {
                abilityToggles.toggle(this.ability, (LivingEntity)Minecraft.getInstance().player);
                NetworkManager.sendToServer((CustomPacketPayload)new ToggleArtifactPacket(this.ability));
            }
            this.wasToggleKeyDown = isToggleKeyDown;
        }
    }
}

