/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability.mobeffect;

import artifacts.ability.ArtifactAbility;
import artifacts.ability.mobeffect.MobEffectAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import artifacts.util.AbilityHelper;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;

public record ApplyMobEffectAfterEatingAbility(Holder<MobEffect> mobEffect, Value<Integer> level, Value<Integer> duration) implements MobEffectAbility
{
    public static final MapCodec<ApplyMobEffectAfterEatingAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> MobEffectAbility.codecStartWithDuration(instance).apply((Applicative)instance, ApplyMobEffectAfterEatingAbility::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ApplyMobEffectAfterEatingAbility> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), ApplyMobEffectAfterEatingAbility::mobEffect, ValueTypes.DURATION.streamCodec(), ApplyMobEffectAfterEatingAbility::duration, ValueTypes.MOB_EFFECT_LEVEL.streamCodec(), ApplyMobEffectAfterEatingAbility::level, ApplyMobEffectAfterEatingAbility::new);

    public static void applyEffects(LivingEntity entity, FoodProperties properties) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = 20 - player.getFoodData().getFoodLevel();
        } else {
            n = 20;
        }
        int foodPointsMissing = n;
        int foodPointsRestored = Math.min(properties.nutrition(), foodPointsMissing);
        ApplyMobEffectAfterEatingAbility.applyEffects(entity, foodPointsRestored);
    }

    public static void applyEffects(LivingEntity entity, int foodPointsRestored) {
        if (foodPointsRestored > 0) {
            AbilityHelper.forEach((ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_EATING.value(), entity, ability -> entity.addEffect(ability.createEffect((Integer)ability.duration().get() * 20 * foodPointsRestored)));
        }
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.APPLY_MOB_EFFECT_AFTER_EATING.value();
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        if (this.mobEffect.equals((Object)MobEffects.DIG_SPEED)) {
            tooltip.add(this.tooltipLine("haste", new Object[0]));
        }
    }
}

