/*
 * Decompiled with CFR 0.152.
 */
package artifacts.ability;

import artifacts.ability.ArtifactAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModAbilities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public record AttacksAbsorbDamageAbility(Value<Double> absorptionRatio, Value<Double> absorptionChance, Value<Integer> maxDamageAbsorbed) implements ArtifactAbility
{
    public static final MapCodec<AttacksAbsorbDamageAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ValueTypes.NON_NEGATIVE_DOUBLE.codec().fieldOf("absorption_ratio").forGetter(AttacksAbsorbDamageAbility::absorptionRatio), (App)ValueTypes.FRACTION.codec().fieldOf("absorption_chance").forGetter(AttacksAbsorbDamageAbility::absorptionChance), (App)ValueTypes.NON_NEGATIVE_INT.codec().fieldOf("max_damage_absorbed").forGetter(AttacksAbsorbDamageAbility::maxDamageAbsorbed)).apply((Applicative)instance, AttacksAbsorbDamageAbility::new));
    public static final StreamCodec<ByteBuf, AttacksAbsorbDamageAbility> STREAM_CODEC = StreamCodec.composite(ValueTypes.NON_NEGATIVE_DOUBLE.streamCodec(), AttacksAbsorbDamageAbility::absorptionRatio, ValueTypes.FRACTION.streamCodec(), AttacksAbsorbDamageAbility::absorptionChance, ValueTypes.NON_NEGATIVE_INT.streamCodec(), AttacksAbsorbDamageAbility::maxDamageAbsorbed, AttacksAbsorbDamageAbility::new);

    @Override
    public ArtifactAbility.Type<?> getType() {
        return (ArtifactAbility.Type)ModAbilities.ATTACKS_ABSORB_DAMAGE.value();
    }

    @Override
    public boolean isNonCosmetic() {
        return (Double)this.absorptionRatio.get() > 0.0 && (Double)this.absorptionChance.get() > 0.0 && (Integer)this.maxDamageAbsorbed.get() > 0;
    }

    @Override
    public void addAbilityTooltip(List<MutableComponent> tooltip) {
        if (Mth.equal((double)((Double)this.absorptionChance.get()), (double)1.0)) {
            tooltip.add(this.tooltipLine("constant", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("chance", new Object[0]));
        }
    }
}

