/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.otherside.gen;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.world.otherside.OthersideBiomes;
import com.kyanite.deeperdarker.world.otherside.OthersideDimension;
import com.kyanite.deeperdarker.world.otherside.gen.OthersideNoiseRouter;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class OthersideGeneration {
    public static final ResourceKey<LevelStem> OTHERSIDE_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)DeeperDarker.rl("otherside"));
    public static final ResourceKey<NoiseGeneratorSettings> OTHERSIDE_GENERATOR = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)DeeperDarker.rl("otherside"));

    public static void levelBootstrap(BootstrapContext<LevelStem> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter noiseSettings = context.lookup(Registries.NOISE_SETTINGS);
        HolderGetter dimensions = context.lookup(Registries.DIMENSION_TYPE);
        context.register(OTHERSIDE_STEM, (Object)OthersideGeneration.levelStem((HolderGetter<Biome>)biomes, (HolderGetter<NoiseGeneratorSettings>)noiseSettings, (HolderGetter<DimensionType>)dimensions));
    }

    private static LevelStem levelStem(HolderGetter<Biome> biomes, HolderGetter<NoiseGeneratorSettings> noiseSettings, HolderGetter<DimensionType> dimensions) {
        NoiseBasedChunkGenerator chunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)Climate.parameters((float)-0.4f, (float)-0.66f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(OthersideBiomes.DEEPLANDS)), Pair.of((Object)Climate.parameters((float)0.11f, (float)0.79f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(OthersideBiomes.ECHOING_FOREST)), Pair.of((Object)Climate.parameters((float)-0.55f, (float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(OthersideBiomes.BLOOMING_CAVERNS)), Pair.of((Object)Climate.parameters((float)0.9f, (float)0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(OthersideBiomes.OVERCAST_COLUMNS))))), (Holder)noiseSettings.getOrThrow(OTHERSIDE_GENERATOR));
        return new LevelStem((Holder)dimensions.getOrThrow(OthersideDimension.OTHERSIDE), (ChunkGenerator)chunkGenerator);
    }

    public static void noiseBootstrap(BootstrapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunction = context.lookup(Registries.DENSITY_FUNCTION);
        HolderGetter noise = context.lookup(Registries.NOISE);
        context.register(OTHERSIDE_GENERATOR, (Object)OthersideGeneration.noiseSettings((HolderGetter<DensityFunction>)densityFunction, (HolderGetter<NormalNoise.NoiseParameters>)noise));
    }

    private static NoiseGeneratorSettings noiseSettings(HolderGetter<DensityFunction> densityFunction, HolderGetter<NormalNoise.NoiseParameters> noise) {
        SurfaceRules.RuleSource bedrockFloor = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BEDROCK.defaultBlockState()));
        SurfaceRules.RuleSource bedrockRoof = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BEDROCK.defaultBlockState()));
        SurfaceRules.RuleSource echoSoilLayer = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{OthersideBiomes.ECHOING_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)DDBlocks.ECHO_SOIL.get()).defaultBlockState())));
        SurfaceRules.RuleSource biomeSurfaceLayer = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{OthersideBiomes.BLOOMING_CAVERNS}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)DDBlocks.BLOOMING_SCULK_STONE.get()).defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{OthersideBiomes.OVERCAST_COLUMNS}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)DDBlocks.GLOOMY_SCULK.get()).defaultBlockState())), SurfaceRules.state((BlockState)Blocks.SCULK.defaultBlockState())}));
        SurfaceRules.RuleSource deepslateFloor = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"deepslate_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)12)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((BlockState)Blocks.DEEPSLATE.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y))));
        SurfaceRules.RuleSource deepslateRoof = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"deepslate_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)12), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((BlockState)Blocks.DEEPSLATE.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y))));
        SurfaceRules.RuleSource gloomslate = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{OthersideBiomes.OVERCAST_COLUMNS}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)((Block)DDBlocks.GLOOMSLATE.get()).defaultBlockState()));
        return new NoiseGeneratorSettings(NoiseSettings.create((int)0, (int)128, (int)1, (int)2), ((Block)DDBlocks.SCULK_STONE.get()).defaultBlockState(), ((Block)DDBlocks.SCULK_GRIME.get()).defaultBlockState(), OthersideNoiseRouter.otherside(densityFunction, noise), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{bedrockFloor, bedrockRoof, echoSoilLayer, biomeSurfaceLayer, deepslateFloor, deepslateRoof, gloomslate}), List.of(), 17, false, false, true, false);
    }
}

