/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.otherside;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.blocks.OthersidePortalBlock;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;

public class OthersideTeleporter {
    public static final int MIN_WIDTH = 2;
    public static final int MIN_HEIGHT = 2;
    public static final int MAX_WIDTH = 21;
    public static final int MAX_HEIGHT = 21;
    private static final int PORTAL_BASE = 2;
    private static final int PORTAL_WIDTH = DeeperDarkerConfig.othersidePortalWidth;
    private static final int PORTAL_HEIGHT = DeeperDarkerConfig.othersidePortalHeight;

    public static DimensionTransition getExitPortal(ServerLevel destLevel, Entity entity, BlockPos pos, BlockPos exitPos, boolean isOtherside, WorldBorder destBorder) {
        DimensionTransition.PostDimensionTransition transition;
        BlockUtil.FoundRectangle portal;
        Optional closestPos = destLevel.getPortalForcer().findClosestPortalPosition(exitPos, isOtherside, destBorder);
        if (closestPos.isPresent()) {
            BlockPos blockPos = (BlockPos)closestPos.get();
            BlockState destState = destLevel.getBlockState(blockPos);
            portal = BlockUtil.getLargestRectangleAround((BlockPos)blockPos, (Direction.Axis)((Direction.Axis)destState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos1 -> destLevel.getBlockState(pos1) == destState);
            transition = DimensionTransition.PLAY_PORTAL_SOUND.then(entity1 -> entity1.placePortalTicket(blockPos));
        } else {
            Direction.Axis direction = entity.level().getBlockState(pos).getOptionalValue(OthersidePortalBlock.AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> rectangle = OthersideTeleporter.makePortal(destLevel, exitPos, direction);
            if (rectangle.isEmpty()) {
                DeeperDarker.LOGGER.error("Unable to create a portal, likely target out of worldborder");
                return null;
            }
            portal = rectangle.get();
            transition = DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET);
        }
        return OthersideTeleporter.getDimensionTransitionFromExit(entity, pos, portal, destLevel, transition);
    }

    private static DimensionTransition getDimensionTransitionFromExit(Entity entity, BlockPos pos, BlockUtil.FoundRectangle rectangle, ServerLevel level, DimensionTransition.PostDimensionTransition postTransition) {
        Vec3 vec3;
        Direction.Axis axis;
        BlockState state = entity.level().getBlockState(pos);
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
            BlockUtil.FoundRectangle portal = BlockUtil.getLargestRectangleAround((BlockPos)pos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, p_351016_ -> entity.level().getBlockState(p_351016_) == state);
            vec3 = entity.getRelativePortalPosition(axis, portal);
        } else {
            axis = Direction.Axis.X;
            vec3 = new Vec3(0.5, 0.0, 0.0);
        }
        return OthersideTeleporter.createDimensionTransition(level, rectangle, axis, vec3, entity, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), postTransition);
    }

    private static DimensionTransition createDimensionTransition(ServerLevel level, BlockUtil.FoundRectangle rectangle, Direction.Axis axis, Vec3 offset, Entity entity, Vec3 speed, float yRot, float xRot, DimensionTransition.PostDimensionTransition postTransition) {
        BlockPos cornerPos = rectangle.minCorner;
        BlockState cornerState = level.getBlockState(cornerPos);
        Direction.Axis axis1 = cornerState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_AXIS).orElse(Direction.Axis.X);
        double d0 = rectangle.axis1Size;
        double d1 = rectangle.axis2Size;
        EntityDimensions dimensions = entity.getDimensions(entity.getPose());
        int i = axis == axis1 ? 0 : 90;
        Vec3 vec3 = axis == axis1 ? speed : new Vec3(speed.z, speed.y, -speed.x);
        double d2 = (double)dimensions.width() / 2.0 + (d0 - (double)dimensions.width()) * offset.x();
        double d3 = (d1 - (double)dimensions.height()) * offset.y();
        double d4 = 0.5 + offset.z();
        boolean flag = axis1 == Direction.Axis.X;
        Vec3 vec31 = new Vec3((double)cornerPos.getX() + (flag ? d2 : d4), (double)cornerPos.getY() + d3, (double)cornerPos.getZ() + (flag ? d4 : d2));
        Vec3 vec32 = PortalShape.findCollisionFreePosition((Vec3)vec31, (ServerLevel)level, (Entity)entity, (EntityDimensions)dimensions);
        return new DimensionTransition(level, vec32, vec3, yRot + (float)i, xRot, postTransition);
    }

    public static Optional<BlockUtil.FoundRectangle> makePortal(ServerLevel level, BlockPos pos, Direction.Axis axis) {
        int i;
        int i2;
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        double d1 = -1.0;
        BlockPos finalPos = null;
        BlockPos destPos = null;
        WorldBorder worldBorder = level.getWorldBorder();
        int levelHeight = level.getHeight() - 1;
        BlockPos.MutableBlockPos mutablePos = pos.mutable();
        for (BlockPos.MutableBlockPos portalPos : BlockPos.spiralAround((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int min = Math.min(levelHeight, level.getHeight(Heightmap.Types.MOTION_BLOCKING, portalPos.getX(), portalPos.getZ()));
            if (!worldBorder.isWithinBounds((BlockPos)portalPos) || !worldBorder.isWithinBounds((BlockPos)portalPos.move(direction, 1))) continue;
            portalPos.move(direction.getOpposite(), 1);
            for (i2 = min; i2 >= 0; --i2) {
                int j;
                portalPos.setY(i2);
                if (!level.isEmptyBlock((BlockPos)portalPos)) continue;
                int y = i2;
                while (i2 > 0 && level.isEmptyBlock((BlockPos)portalPos.move(Direction.DOWN))) {
                    --i2;
                }
                if (i2 + 4 > levelHeight || (j = y - i2) > 0 && j < 3) continue;
                portalPos.setY(i2);
                if (!OthersideTeleporter.checkRegionForPlacement(level, (BlockPos)portalPos, mutablePos, direction, 0)) continue;
                double d2 = pos.distSqr((Vec3i)portalPos);
                if (OthersideTeleporter.checkRegionForPlacement(level, (BlockPos)portalPos, mutablePos, direction, -1) && OthersideTeleporter.checkRegionForPlacement(level, (BlockPos)portalPos, mutablePos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    finalPos = portalPos.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                destPos = portalPos.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            finalPos = destPos;
            d0 = d1;
        }
        if (d0 == -1.0) {
            finalPos = new BlockPos(pos.getX(), Mth.clamp((int)pos.getY(), (int)16, (int)(level.getHeight() - 20)), pos.getZ()).immutable();
            Direction direction1 = direction.getClockWise();
            if (!worldBorder.isWithinBounds(finalPos)) {
                return Optional.empty();
            }
            int yDiff = 0;
            BlockPos.MutableBlockPos blockPos = finalPos.mutable();
            while (!level.getBlockState((BlockPos)blockPos).isAir() && !level.isOutsideBuildHeight((BlockPos)blockPos)) {
                blockPos.move(0, 1, 0);
                ++yDiff;
            }
            if (!level.isOutsideBuildHeight((BlockPos)blockPos)) {
                finalPos = blockPos;
            } else {
                blockPos.move(0, -yDiff, 0);
                while (!level.getBlockState((BlockPos)blockPos).isAir() && !level.isOutsideBuildHeight((BlockPos)blockPos)) {
                    blockPos.move(0, -1, 0);
                }
                if (!level.isOutsideBuildHeight((BlockPos)blockPos)) {
                    finalPos = blockPos;
                }
            }
            blockPos = finalPos.mutable();
            while (level.getBlockState(blockPos.below()).isAir()) {
                blockPos.move(0, -1, 0);
            }
            finalPos = blockPos;
            for (i2 = -2; i2 < 3; ++i2) {
                for (int j = 0; j < PORTAL_WIDTH; ++j) {
                    for (int k = -1; k < PORTAL_HEIGHT; ++k) {
                        mutablePos.setWithOffset((Vec3i)finalPos, j * direction.getStepX() + i2 * direction1.getStepX(), k, j * direction.getStepZ() + i2 * direction1.getStepZ());
                        if (k < 0 && (i2 == -2 || i2 == 2)) continue;
                        level.setBlockAndUpdate((BlockPos)mutablePos, k < 0 ? Blocks.REINFORCED_DEEPSLATE.defaultBlockState() : Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
        for (i = -1; i < PORTAL_WIDTH + 1; ++i) {
            for (int j = -1; j < PORTAL_HEIGHT + 1; ++j) {
                if (i != -1 && i != PORTAL_WIDTH && j != -1 && j != PORTAL_HEIGHT) continue;
                mutablePos.setWithOffset((Vec3i)finalPos, i * direction.getStepX(), j, i * direction.getStepZ());
                level.setBlock((BlockPos)mutablePos, Blocks.REINFORCED_DEEPSLATE.defaultBlockState(), 3);
            }
        }
        for (i = 0; i < PORTAL_WIDTH; ++i) {
            for (int j = 0; j < PORTAL_HEIGHT; ++j) {
                mutablePos.setWithOffset((Vec3i)finalPos, i * direction.getStepX(), j, i * direction.getStepZ());
                level.setBlock((BlockPos)mutablePos, (BlockState)((OthersidePortalBlock)((Object)DDBlocks.OTHERSIDE_PORTAL.get())).defaultBlockState().setValue(OthersidePortalBlock.AXIS, (Comparable)axis), 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(finalPos.immutable(), 2, 3));
    }

    private static boolean checkRegionForPlacement(ServerLevel level, BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.setWithOffset((Vec3i)originalPos, directionIn.getStepX() * i + direction.getStepX() * offsetScale, j, directionIn.getStepZ() * i + direction.getStepZ() * offsetScale);
                if (j < 0 && !level.getBlockState((BlockPos)offsetPos).isAir()) {
                    return false;
                }
                if (j < 0 || level.isEmptyBlock((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }
}

