/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.datagen.assets;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDEffects;
import com.kyanite.deeperdarker.content.DDEnchantments;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.entities.DDBoat;
import com.kyanite.deeperdarker.content.entities.DDChestBoat;
import com.kyanite.deeperdarker.util.DDDamageTypes;
import com.kyanite.deeperdarker.world.otherside.OthersideBiomes;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ENLanguageProvider
extends LanguageProvider {
    public ENLanguageProvider(PackOutput output) {
        super(output, "deeperdarker", "en_us");
    }

    protected void addTranslations() {
        this.add("item.minecraft.tipped_arrow.effect.sculk_affinity", "Arrow of Sculk Affinity");
        this.add("item.minecraft.tipped_arrow.effect.long_sculk_affinity", "Arrow of Sculk Affinity");
        this.add("item.minecraft.potion.effect.sculk_affinity", "Potion of Sculk Affinity");
        this.add("item.minecraft.potion.effect.long_sculk_affinity", "Potion of Sculk Affinity");
        this.add("item.minecraft.splash_potion.effect.sculk_affinity", "Splash Potion of Sculk Affinity");
        this.add("item.minecraft.splash_potion.effect.long_sculk_affinity", "Splash Potion of Sculk Affinity");
        this.add("item.minecraft.lingering_potion.effect.sculk_affinity", "Lingering Potion of Sculk Affinity");
        this.add("item.minecraft.lingering_potion.effect.long_sculk_affinity", "Lingering Potion of Sculk Affinity");
        this.add("advancements.deeperdarker.root.title", "Sculk Story");
        this.add("advancements.deeperdarker.root.description", "You feel something pulling you towards the source...");
        this.add("advancements.deeperdarker.find_ancient_city.title", "A Metropolis of Restless Souls");
        this.add("advancements.deeperdarker.find_ancient_city.description", "Find an Ancient City");
        this.add("advancements.deeperdarker.kill_warden.title", "Phantom Thief");
        this.add("advancements.deeperdarker.kill_warden.description", "Slay the Warden and take its heart");
        this.add("advancements.deeperdarker.enter_otherside.title", "Below the Bedrock");
        this.add("advancements.deeperdarker.enter_otherside.description", "Deep below the bedrock, the darkness awaits");
        this.add("advancements.deeperdarker.find_ancient_temple.title", "Abyssal Descent");
        this.add("advancements.deeperdarker.find_ancient_temple.description", "Explore the depths for a temple");
        this.add("advancements.deeperdarker.obtain_sculk_transmitter.title", "Remote Storage");
        this.add("advancements.deeperdarker.obtain_sculk_transmitter.description", "Acquire a Sculk Transmitter");
        this.add("advancements.deeperdarker.obtain_sonorous_staff.title", "Noise Complaint");
        this.add("advancements.deeperdarker.obtain_sonorous_staff.description", "Acquire a Sonorous Staff");
        this.add("advancements.deeperdarker.explore_otherside.title", "Echolocation");
        this.add("advancements.deeperdarker.explore_otherside.description", "Explore all Otherside biomes");
        this.add("advancements.deeperdarker.kill_all_sculk_mobs.title", "Sculk Slayer");
        this.add("advancements.deeperdarker.kill_all_sculk_mobs.description", "Kill one of every Sculk monster");
        this.add("advancements.deeperdarker.obtain_reinforced_echo_shard.title", "Sculk Engineer");
        this.add("advancements.deeperdarker.obtain_reinforced_echo_shard.description", "Reinforce an Echo Shard");
        this.add("advancements.deeperdarker.warden_armor.title", "Cover Me with Sculk");
        this.add("advancements.deeperdarker.warden_armor.description", "Protect yourself with a full set of Warden Armor");
        this.add("block.deeperdarker.linked", "Linked transmitter");
        this.add("block.deeperdarker.unlinked", "Unlinked transmitter");
        this.add("block.deeperdarker.not_transmittable", "Cannot link to block");
        this.add("block.deeperdarker.not_found", "The linked block is missing or unloaded");
        this.add("block.deeperdarker.flowerless_ice_lily", "Flowerless Ice Lily");
        this.add("tooltips.deeperdarker.crystallized_amber.item", "Contains %s");
        this.add("tooltips.deeperdarker.crystallized_amber.leech", "Contains Sculk Leech");
        this.add("tooltips.deeperdarker.sculk_transmitter.linked", "Linked to %s");
        this.add("tooltips.deeperdarker.sculk_transmitter.location", "Located at %s, %s, %s");
        this.add("tooltips.deeperdarker.sculk_transmitter.not_linked", "Unlinked");
        this.add("itemGroup.deeperdarker", "Deeper and Darker");
        this.add("item.deeperdarker.dampens_vibrations", "Dampens Vibrations");
        this.add("item.deeperdarker.soul_elytra.equipped", "Press %s to boost");
        this.add("item.deeperdarker.soul_elytra.cooldown", "Boost available in %s");
        this.add("item.deeperdarker.soul_elytra.no_cooldown", "Boost disabled");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.applies_to", "Netherite Equipment");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.ingredients", "Reinforced Echo Shard");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.base_slot_description", "Add netherite armor, weapon, or tool");
        this.add("item.deeperdarker.smithing_template.warden_upgrade.additions_slot_description", "Add Reinforced Echo Shard");
        this.add("upgrade.deeperdarker.warden_upgrade", "Warden Upgrade");
        this.add("key.categories.deeperdarker", "Deeper and Darker");
        this.add("key.deeperdarker.boost", "Boost Soul Elytra");
        this.add("key.deeperdarker.transmit", "Use Sculk Transmitter");
        this.add("biome.deeperdarker." + OthersideBiomes.DEEPLANDS.location().getPath(), this.convertToName(OthersideBiomes.DEEPLANDS.location().getPath()));
        this.add("biome.deeperdarker." + OthersideBiomes.ECHOING_FOREST.location().getPath(), this.convertToName(OthersideBiomes.ECHOING_FOREST.location().getPath()));
        this.add("biome.deeperdarker." + OthersideBiomes.BLOOMING_CAVERNS.location().getPath(), this.convertToName(OthersideBiomes.BLOOMING_CAVERNS.location().getPath()));
        this.add("biome.deeperdarker." + OthersideBiomes.OVERCAST_COLUMNS.location().getPath(), this.convertToName(OthersideBiomes.OVERCAST_COLUMNS.location().getPath()));
        this.add("death.attack.deeperdarker." + DDDamageTypes.BITE.location().getPath(), "%s was devoured");
        this.add("death.attack.deeperdarker." + DDDamageTypes.RING.location().getPath(), "%s was given a deadly case of tinnitus by %s");
        this.add("enchantment.deeperdarker." + DDEnchantments.CATALYSIS.location().getPath(), this.convertToName(DDEnchantments.CATALYSIS.location().getPath()));
        this.add("enchantment.deeperdarker." + DDEnchantments.CATALYSIS.location().getPath() + ".desc", "Spreads sculk when mobs are killed.");
        this.add("enchantment.deeperdarker." + DDEnchantments.SCULK_SMITE.location().getPath(), this.convertToName(DDEnchantments.SCULK_SMITE.location().getPath()));
        this.add("enchantment.deeperdarker." + DDEnchantments.SCULK_SMITE.location().getPath() + ".desc", "Increases damage against sculk mobs such as Shattered and the Warden.");
        this.add("painting.deeperdarker.abstraction.title", "Abstraction");
        this.add("painting.deeperdarker.abstraction.author", "Pedro Ricardo");
        this.add("painting.deeperdarker.adventure.title", "Adventure");
        this.add("painting.deeperdarker.adventure.author", "Pedro Ricardo");
        this.add("painting.deeperdarker.carrot.title", "Back to Your Roots");
        this.add("painting.deeperdarker.carrot.author", "Pedro Ricardo");
        this.add("painting.deeperdarker.clouds.title", "Clouds");
        this.add("painting.deeperdarker.clouds.author", "Pedro Ricardo");
        this.add("painting.deeperdarker.echoer.title", "Echoer");
        this.add("painting.deeperdarker.echoer.author", "Pedro Ricardo");
        this.add("painting.deeperdarker.millipede.title", "Millipede");
        this.add("painting.deeperdarker.millipede.author", "Pedro Ricardo");
        this.add("painting.deeperdarker.ooze.title", "Ooze");
        this.add("painting.deeperdarker.ooze.author", "Pedro Ricardo");
        this.add("subtitles.ambient.otherside.additions", "Warden dreams");
        this.add("subtitles.ambient.portal.groan", "The Otherside forebodes");
        this.add("subtitles.entity.angler_fish.death", "Angler Fish dies");
        this.add("subtitles.entity.angler_fish.flop", "Angler Fish flops");
        this.add("subtitles.entity.angler_fish.hurt", "Angler Fish hurts");
        this.add("subtitles.entity.leech.hurt", "Sculk Leech hurts");
        this.add("subtitles.entity.snapper.ambient", "Sculk Snapper breathes");
        this.add("subtitles.entity.snapper.bite", "Sculk Snapper bites");
        this.add("subtitles.entity.snapper.hurt", "Sculk Snapper hurts");
        this.add("subtitles.entity.snapper.sniff", "Sculk Snapper sniffs");
        this.add("subtitles.entity.shattered.ambient", "Shattered growls");
        this.add("subtitles.entity.shattered.death", "Shattered dies");
        this.add("subtitles.entity.shattered.hurt", "Shattered hurts");
        this.add("subtitles.entity.shattered.notice", "Shattered takes notice");
        this.add("subtitles.entity.shriek_worm.ambient", "Shriek Worm cries");
        this.add("subtitles.entity.shriek_worm.death", "Shriek Worm dies");
        this.add("subtitles.entity.shriek_worm.hurt", "Shriek Worm hurts");
        this.add("subtitles.entity.stalker.ambient", "Stalker chirps");
        this.add("subtitles.entity.stalker.death", "Stalker dies");
        this.add("subtitles.entity.stalker.hurt", "Stalker hurts");
        this.add("subtitles.entity.stalker.notice", "Stalker takes notice");
        this.add("subtitles.item.transmitter.error", "Transmitter fails");
        this.add("subtitles.item.transmitter.link", "Transmitter links");
        this.add("subtitles.item.transmitter.open", "Transmitter transmits");
        this.add("subtitles.item.transmitter.unlink", "Transmitter unlinks");
        this.add("tag.item.deeperdarker.bloom_stems", "Blooming Stems");
        this.add("tag.item.deeperdarker.echo_logs", "Echo Logs");
        this.add("tag.item.deeperdarker.dampens_vibrations", "Dampens Vibrations");
        this.add("tag.item.deeperdarker.scutes", "Scutes");
        DDBlocks.BLOCKS.getEntries().forEach(block -> this.add((DeferredHolder<?, ?>)block, "block"));
        DDItems.ITEMS.getEntries().forEach(item -> this.add((DeferredHolder<?, ?>)item, "item"));
        DDEntities.ENTITIES.getEntries().forEach(entity -> this.add((DeferredHolder<?, ?>)entity, "entity"));
        DDEffects.EFFECTS.getEntries().forEach(effect -> this.add((DeferredHolder<?, ?>)effect, "effect"));
    }

    private void add(DeferredHolder<?, ?> entry, String prefix) {
        if (this.filter(entry)) {
            return;
        }
        String key = entry.getId().getPath();
        this.add(prefix + ".deeperdarker." + key, this.convertToName(key));
    }

    private boolean filter(DeferredHolder<?, ?> entry) {
        if (entry.get() instanceof ItemNameBlockItem) {
            return false;
        }
        return entry.get() instanceof BlockItem || entry.get() instanceof WallSignBlock || entry.get() instanceof WallHangingSignBlock || entry.get() instanceof DDBoat || entry.get() instanceof DDChestBoat;
    }

    private String convertToName(String key) {
        StringBuilder builder = new StringBuilder(key.substring(0, 1).toUpperCase() + key.substring(1));
        for (int i = 1; i < builder.length(); ++i) {
            if (builder.charAt(i) != '_') continue;
            builder.deleteCharAt(i);
            builder.replace(i, i + 1, " " + Character.toUpperCase(builder.charAt(i)));
        }
        Object name = builder.toString();
        if (((String)name).contains("Chest ")) {
            name = ((String)name).replace("Chest ", "") + " With Chest";
        }
        if (((String)name).contains("Lapis")) {
            name = ((String)name).replace("Lapis", "Lapis Lazuli");
        }
        if (((String)name).contains("Of The")) {
            name = ((String)name).replace("Of The", "of the");
        }
        if (((String)name).contains("Smithing")) {
            name = "Smithing Template";
        }
        if (((String)name).contains("With")) {
            name = ((String)name).replace("With", "with");
        }
        return name;
    }
}

