/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SonorousStaffItem
extends Item {
    public double dropOffFactor = 0.3333333333333333;

    public SonorousStaffItem(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int timeUsed = this.getUseDuration(stack, (LivingEntity)player) - timeCharged;
        int damage = (int)Math.round(50.0 / (1.0 + 16.0 / Math.exp(0.06 * (double)timeUsed)));
        int range = (int)Math.min(40L, Math.round(3.0 * Math.log(timeUsed + 1)));
        Vec3 eyePos = player.getEyePosition();
        Vec3 facing = player.getForward();
        for (int i = 0; i < range; ++i) {
            Vec3 scanVec = eyePos.add(facing.scale((double)i));
            BlockPos targetPos = new BlockPos((int)scanVec.x, (int)scanVec.y, (int)scanVec.z);
            BlockState targetState = level.getBlockState(targetPos);
            if (!targetState.isAir() && targetState.canOcclude()) break;
            if (level.isClientSide() && i % 2 == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, scanVec.x, scanVec.y, scanVec.z, 1.0, 0.0, 0.0);
            }
            AABB aabb = new AABB(targetPos).inflate(0.4);
            List targets = level.getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity entity : targets) {
                if (entity.is((Entity)player)) continue;
                int finalDamage = (int)((double)damage * (1.0 - this.dropOffFactor * Math.pow((double)i / (double)range, 2.0)));
                entity.hurt(level.damageSources().sonicBoom((Entity)player), (float)finalDamage);
                double horizontalResistance = 1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
                double verticalResistance = 1.0 - entity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
                entity.push(facing.x * horizontalResistance, facing.y * verticalResistance, facing.z * horizontalResistance);
            }
        }
        player.playSound(SoundEvents.WARDEN_SONIC_BOOM);
        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        player.getCooldowns().addCooldown((Item)this, 20);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = stack.has(DataComponents.CUSTOM_DATA) ? ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag() : new CompoundTag();
            tag.putBoolean("charged", player.getUseItem() == stack && stack.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks() >= 123);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || stack.has(DataComponents.CUSTOM_DATA) && ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean("charged");
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

