/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker;

import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.DeeperDarkerConfig;
import com.kyanite.deeperdarker.client.Keybinds;
import com.kyanite.deeperdarker.client.model.AnglerFishModel;
import com.kyanite.deeperdarker.client.model.SculkCentipedeModel;
import com.kyanite.deeperdarker.client.model.SculkLeechModel;
import com.kyanite.deeperdarker.client.model.SculkSnapperModel;
import com.kyanite.deeperdarker.client.model.ShatteredModel;
import com.kyanite.deeperdarker.client.model.ShriekWormModel;
import com.kyanite.deeperdarker.client.model.SludgeModel;
import com.kyanite.deeperdarker.client.model.StalkerModel;
import com.kyanite.deeperdarker.client.model.WardenHelmetModel;
import com.kyanite.deeperdarker.client.render.AnglerFishRenderer;
import com.kyanite.deeperdarker.client.render.CrystallizedAmberBlockRenderer;
import com.kyanite.deeperdarker.client.render.DDBoatRenderer;
import com.kyanite.deeperdarker.client.render.SculkCentipedeRenderer;
import com.kyanite.deeperdarker.client.render.SculkLeechRenderer;
import com.kyanite.deeperdarker.client.render.SculkSnapperRenderer;
import com.kyanite.deeperdarker.client.render.ShatteredRenderer;
import com.kyanite.deeperdarker.client.render.ShriekWormRenderer;
import com.kyanite.deeperdarker.client.render.SludgeOuterLayer;
import com.kyanite.deeperdarker.client.render.SludgeRenderer;
import com.kyanite.deeperdarker.client.render.SoulElytraRenderer;
import com.kyanite.deeperdarker.client.render.StalkerRenderer;
import com.kyanite.deeperdarker.client.render.WardenHelmetRenderer;
import com.kyanite.deeperdarker.content.DDBlockEntities;
import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDItems;
import com.kyanite.deeperdarker.content.DDPotions;
import com.kyanite.deeperdarker.content.blocks.AncientVaseBlock;
import com.kyanite.deeperdarker.content.blocks.CrystallizedAmberBlock;
import com.kyanite.deeperdarker.content.blocks.entity.CrystallizedAmberBlockEntity;
import com.kyanite.deeperdarker.content.blocks.vegetation.IceLilyBlock;
import com.kyanite.deeperdarker.content.items.ResonariumArmorItem;
import com.kyanite.deeperdarker.content.items.SculkTransmitterItem;
import com.kyanite.deeperdarker.content.items.SoulElytraItem;
import com.kyanite.deeperdarker.network.SoulElytraBoostPacket;
import com.kyanite.deeperdarker.network.SoulElytraClientPacket;
import com.kyanite.deeperdarker.network.UseTransmitterPacket;
import com.kyanite.deeperdarker.util.DDArmorMaterials;
import com.kyanite.deeperdarker.util.DDTags;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="deeperdarker")
public class DeeperDarkerEvents {
    @SubscribeEvent
    public static void registerBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, (Item)DDItems.SOUL_CRYSTAL.get(), DDPotions.SCULK_AFFINITY);
        builder.addMix(Potions.INVISIBILITY, (Item)DDItems.SOUL_DUST.get(), DDPotions.SCULK_AFFINITY);
        builder.addMix(DDPotions.SCULK_AFFINITY, Items.REDSTONE, DDPotions.LONG_SCULK_AFFINITY);
        builder.addMix(Potions.LONG_INVISIBILITY, (Item)DDItems.SOUL_DUST.get(), DDPotions.LONG_SCULK_AFFINITY);
    }

    @SubscribeEvent
    public static void breakEvent(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        boolean silktouch;
        Level level = (Level)event.getLevel();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        HolderLookup.RegistryLookup lookup = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        boolean bl = silktouch = event.getPlayer().getMainHandItem().getEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH)) > 0;
        if (state.is(DDBlocks.CRYSTALLIZED_AMBER) && (blockEntity = level.getBlockEntity(pos)) instanceof CrystallizedAmberBlockEntity) {
            CrystallizedAmberBlockEntity blockEntity2 = (CrystallizedAmberBlockEntity)blockEntity;
            if (!silktouch && ((Boolean)state.getValue((Property)CrystallizedAmberBlock.FOSSILIZED)).booleanValue()) {
                if (blockEntity2.fossilizedEntity && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ((EntityType)DDEntities.SCULK_LEECH.get()).spawn(serverLevel, pos, MobSpawnType.TRIGGERED);
                } else {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)blockEntity2.getLoot());
                }
            } else if (silktouch && !level.isClientSide() && ((Boolean)state.getValue((Property)CrystallizedAmberBlock.FOSSILIZED)).booleanValue()) {
                CompoundTag tag = new CompoundTag();
                tag.put("item", blockEntity2.getLoot().saveOptional((HolderLookup.Provider)level.registryAccess()));
                tag.putBoolean("leech", blockEntity2.fossilizedEntity);
                ItemStack stack = new ItemStack((ItemLike)DDBlocks.CRYSTALLIZED_AMBER.get());
                BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)DDBlockEntities.CRYSTALLIZED_AMBER.get()), (CompoundTag)tag);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                event.setCanceled(true);
            }
            return;
        }
        if (silktouch) {
            return;
        }
        if (state.is(DDBlocks.ICE_LILY)) {
            if (((Boolean)state.getValue((Property)IceLilyBlock.HAS_FLOWER)).booleanValue()) {
                return;
            }
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("has_flower", false);
            tag.putString("id", "deeperdarker:ice_lily");
            ItemStack stack = new ItemStack(DDBlocks.ICE_LILY);
            stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"block.deeperdarker.flowerless_ice_lily"));
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            event.setCanceled(true);
        }
        if (state.is(DDBlocks.ANCIENT_VASE) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.getRandom();
            if (level.getDifficulty() != Difficulty.PEACEFUL && !((Boolean)state.getValue((Property)AncientVaseBlock.SAFE)).booleanValue() && random.nextDouble() < DeeperDarkerConfig.fakeVaseChance) {
                if (random.nextDouble() < 1.0 - DeeperDarkerConfig.stalkerSpawnChance) {
                    for (int i = 0; i < random.nextInt(1, 4); ++i) {
                        ((EntityType)DDEntities.SCULK_LEECH.get()).spawn(serverLevel, pos, MobSpawnType.TRIGGERED);
                    }
                } else {
                    ((EntityType)DDEntities.STALKER.get()).spawn(serverLevel, pos, MobSpawnType.TRIGGERED);
                }
                serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingDamageEvent.Pre event) {
        if (event.getSource().is(DamageTypeTags.BYPASSES_ARMOR)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        float incoming = event.getNewDamage();
        float reduction = incoming / 4.0f;
        for (ItemStack stack : entity.getArmorSlots()) {
            Item item = stack.getItem();
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armor = (ArmorItem)item;
            if (!stack.is(DDTags.Items.RESONARIUM_ARMOR)) continue;
            incoming -= reduction;
            stack.hurtAndBreak((int)(event.getOriginalDamage() / 1.5f), entity, armor.getEquipmentSlot());
        }
        event.setNewDamage(incoming);
    }

    @SubscribeEvent
    public static void armorHurtEvent(ArmorHurtEvent event) {
        event.getArmorMap().forEach((equipmentSlot, armorEntry) -> {
            ArmorItem armor;
            Item patt0$temp = event.getArmorItemStack(equipmentSlot).getItem();
            if (patt0$temp instanceof ArmorItem && (armor = (ArmorItem)patt0$temp).getMaterial().is(DDArmorMaterials.RESONARIUM.getId())) {
                armorEntry.newDamage = 0.0f;
            }
        });
    }

    @SubscribeEvent
    public static void equipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (!event.getSlot().isArmor()) {
            return;
        }
        if (!event.getTo().is((Item)DDItems.SOUL_ELYTRA.get()) || event.getFrom().is((Item)DDItems.SOUL_ELYTRA.get())) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SoulElytraClientPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void anvilEvent(AnvilUpdateEvent event) {
        ItemStack input = event.getLeft();
        ItemStack addition = event.getRight();
        if (!(input.getItem() instanceof ResonariumArmorItem)) {
            return;
        }
        if (addition.is(DDItems.RESONARIUM)) {
            ItemStack output = input.copy();
            int diff = Math.min(output.getDamageValue(), output.getMaxDamage() / 4);
            int cost = 0;
            for (int i = 0; diff > 0 && i < addition.getCount(); ++i) {
                int damage = output.getDamageValue() - diff;
                output.setDamageValue(damage);
                diff = Math.min(damage, output.getMaxDamage() / 4);
                ++cost;
            }
            event.setOutput(output);
            event.setCost((long)DeeperDarkerEvents.nameCost(event.getName(), input, cost, output));
            return;
        }
        if (!addition.is(Items.ENCHANTED_BOOK)) {
            return;
        }
        boolean client = event.getPlayer().level().isClientSide;
        ItemEnchantments inputEnchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)input);
        ItemEnchantments bookEnchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)addition);
        ItemEnchantments.Mutable finalEnchants = new ItemEnchantments.Mutable(inputEnchants);
        int cost = 0;
        boolean noChange = true;
        for (Object2IntMap.Entry entry : bookEnchants.entrySet()) {
            int existingLevel;
            Holder enchantment = (Holder)entry.getKey();
            Enchantment enchant = (Enchantment)enchantment.value();
            int level = entry.getIntValue();
            level = level == (existingLevel = inputEnchants.getLevel(enchantment)) ? level + 1 : Math.max(level, existingLevel);
            level = Math.min(level, enchant.getMaxLevel());
            if (!enchant.canEnchant(input) || enchantment.is(DDTags.Misc.RESONARIUM_EXCLUDES)) continue;
            finalEnchants.set(enchantment, level);
            cost += enchant.getAnvilCost() * level;
            noChange = false;
        }
        if (noChange) {
            event.setCanceled(true);
            return;
        }
        int inputRepair = (Integer)input.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
        int additionRepair = (Integer)addition.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
        int newRepairCost = AnvilMenu.calculateIncreasedRepairCost((int)Math.max(inputRepair, additionRepair));
        cost = Math.clamp((long)(cost + inputRepair + additionRepair), 0, Integer.MAX_VALUE);
        ItemStack output = input.copy();
        output.set(DataComponents.REPAIR_COST, (Object)newRepairCost);
        EnchantmentHelper.setEnchantments((ItemStack)output, (ItemEnchantments)finalEnchants.toImmutable());
        cost = DeeperDarkerEvents.nameCost(event.getName(), input, cost, output);
        event.setOutput(output);
        event.setCost((long)(cost / 2));
    }

    private static int nameCost(String name, ItemStack input, int cost, ItemStack output) {
        if (name != null && !StringUtil.isBlank((String)name)) {
            if (!name.equals(input.getHoverName().getString())) {
                ++cost;
                output.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
            }
        } else if (input.has(DataComponents.CUSTOM_NAME)) {
            ++cost;
            output.remove(DataComponents.CUSTOM_NAME);
        }
        return cost;
    }

    @EventBusSubscriber(modid="deeperdarker", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class NeoForgeClientEvents {
        @SubscribeEvent
        public static void keyInput(InputEvent.Key event) {
            if (Keybinds.BOOST.consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SoulElytraBoostPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (Keybinds.TRANSMIT.consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new UseTransmitterPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber(modid="deeperdarker", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Sheets.addWoodType((WoodType)DDBlocks.ECHO);
                Sheets.addWoodType((WoodType)DDBlocks.BLOOM);
                ItemProperties.register((Item)((Item)DDItems.SOUL_ELYTRA.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"broken"), (pStack, pLevel, pEntity, pSeed) -> SoulElytraItem.isFlyEnabled((ItemStack)pStack) ? 0.0f : 1.0f);
                ItemProperties.register((Item)((Item)DDItems.SCULK_TRANSMITTER.get()), (ResourceLocation)DeeperDarker.rl("linked"), (pStack, pLevel, pEntity, pSeed) -> SculkTransmitterItem.isLinked(pStack) ? 1.0f : 0.0f);
                ItemProperties.register((Item)((Item)DDItems.SONOROUS_STAFF.get()), (ResourceLocation)DeeperDarker.rl("charge"), (pStack, pLevel, pEntity, pSeed) -> pEntity != null && pEntity.getUseItem() == pStack ? (float)(pStack.getUseDuration(pEntity) - pEntity.getUseItemRemainingTicks()) / 123.0f : 0.0f);
            });
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)DDBlockEntities.DEEPER_DARKER_SIGNS.get()), SignRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)DDBlockEntities.DEEPER_DARKER_HANGING_SIGNS.get()), HangingSignRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.BOAT.get()), context -> new DDBoatRenderer(context, false));
            EntityRenderers.register((EntityType)((EntityType)DDEntities.CHEST_BOAT.get()), context -> new DDBoatRenderer(context, true));
            EntityRenderers.register((EntityType)((EntityType)DDEntities.ANGLER_FISH.get()), AnglerFishRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.SCULK_CENTIPEDE.get()), SculkCentipedeRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.SCULK_LEECH.get()), SculkLeechRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.SCULK_SNAPPER.get()), SculkSnapperRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.SHATTERED.get()), ShatteredRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.SHRIEK_WORM.get()), ShriekWormRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.SLUDGE.get()), SludgeRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)DDEntities.STALKER.get()), StalkerRenderer::new);
        }

        @SubscribeEvent
        public static void registerKeybinds(RegisterKeyMappingsEvent event) {
            event.register(Keybinds.BOOST);
            event.register(Keybinds.TRANSMIT);
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)DDBlockEntities.CRYSTALLIZED_AMBER.get(), CrystallizedAmberBlockRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(DDBoatRenderer.ECHO_BOAT_MODEL, BoatModel::createBodyModel);
            event.registerLayerDefinition(DDBoatRenderer.ECHO_CHEST_BOAT_MODEL, ChestBoatModel::createBodyModel);
            event.registerLayerDefinition(DDBoatRenderer.BLOOM_BOAT_MODEL, BoatModel::createBodyModel);
            event.registerLayerDefinition(DDBoatRenderer.BLOOM_CHEST_BOAT_MODEL, ChestBoatModel::createBodyModel);
            event.registerLayerDefinition(AnglerFishRenderer.MODEL, AnglerFishModel::createBodyModel);
            event.registerLayerDefinition(SculkCentipedeRenderer.MODEL, SculkCentipedeModel::createBodyModel);
            event.registerLayerDefinition(SculkLeechRenderer.MODEL, SculkLeechModel::createBodyModel);
            event.registerLayerDefinition(SculkSnapperRenderer.MODEL, SculkSnapperModel::createBodyModel);
            event.registerLayerDefinition(ShatteredRenderer.MODEL, ShatteredModel::createBodyModel);
            event.registerLayerDefinition(ShriekWormRenderer.MODEL, ShriekWormModel::createBodyModel);
            event.registerLayerDefinition(SludgeRenderer.MODEL, SludgeModel::createInnerBodyModel);
            event.registerLayerDefinition(SludgeOuterLayer.OUTER_MODEL, SludgeModel::createOuterBodyModel);
            event.registerLayerDefinition(StalkerRenderer.MODEL, StalkerModel::createBodyModel);
            event.registerLayerDefinition(WardenHelmetRenderer.MODEL, WardenHelmetModel::createBodyModel);
        }

        @SubscribeEvent
        public static void addLayers(EntityRenderersEvent.AddLayers event) {
            event.getSkins().forEach(name -> {
                EntityRenderer patt0$temp = event.getSkin(name);
                if (patt0$temp instanceof PlayerRenderer) {
                    PlayerRenderer renderer = (PlayerRenderer)patt0$temp;
                    renderer.addLayer(new SoulElytraRenderer(renderer, event.getEntityModels()));
                    renderer.addLayer(new WardenHelmetRenderer(renderer, event.getEntityModels()));
                }
            });
            EntityRenderer entityRenderer = event.getRenderer(EntityType.ARMOR_STAND);
            if (entityRenderer instanceof ArmorStandRenderer) {
                ArmorStandRenderer renderer = (ArmorStandRenderer)entityRenderer;
                renderer.addLayer(new SoulElytraRenderer(renderer, event.getEntityModels()));
                renderer.addLayer(new WardenHelmetRenderer(renderer, event.getEntityModels()));
            }
        }
    }
}

