/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForge;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

public class BlockSetInternalImpl {
    private static final Map<String, List<Runnable>> LATE_REGISTRATION_QUEUE = new ConcurrentHashMap<String, List<Runnable>>();
    private static boolean hasFilledBlockSets = false;

    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, Registry<E> registry) {
        if (registry == BuiltInRegistries.BLOCK) {
            BlockSetInternalImpl.addEvent(BuiltInRegistries.BLOCK, registrationFunction, blockType);
        } else if (registry == BuiltInRegistries.ITEM) {
            BlockSetInternalImpl.addEvent(BuiltInRegistries.ITEM, registrationFunction, blockType);
        } else {
            if (registry == BuiltInRegistries.FLUID || registry == BuiltInRegistries.SOUND_EVENT) {
                throw new IllegalArgumentException("Fluid and Sound Events registry not supported here");
            }
            BlockSetInternalImpl.getOrAddQueue();
            RegHelper.registerInBatch(registry, e -> registrationFunction.accept((Registrator)e, BlockSetAPI.getBlockSet(blockType).getValues()));
        }
    }

    public static <T extends BlockType, E> void addEvent(Registry<E> reg, BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType) {
        List<Runnable> registrationQueues = BlockSetInternalImpl.getOrAddQueue();
        Consumer<RegisterEvent> eventConsumer = e -> {
            if (e.getRegistryKey().equals(BuiltInRegistries.BLOCK.key())) {
                Runnable lateRegistration = () -> registrationFunction.accept((r, o) -> Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)r, (Object)((Block)o)), BlockSetAPI.getBlockSet(blockType).getValues());
                registrationQueues.add(lateRegistration);
            }
        };
        IEventBus bus = MoonlightForge.getCurrentBus();
        bus.addListener(EventPriority.HIGHEST, eventConsumer);
    }

    @NotNull
    private static List<Runnable> getOrAddQueue() {
        IEventBus bus = MoonlightForge.getCurrentBus();
        String modId = ModLoadingContext.get().getActiveContainer().getModId();
        return LATE_REGISTRATION_QUEUE.computeIfAbsent(modId, s -> {
            bus.addListener(EventPriority.HIGHEST, BlockSetInternalImpl::registerLateBlockAndItems);
            return new ArrayList();
        });
    }

    protected static void registerLateBlockAndItems(RegisterEvent event) {
        if (event.getRegistryKey().equals(BuiltInRegistries.ATTRIBUTE.key()) && !hasFilledBlockSets) {
            BlockSetInternal.initializeBlockSets();
            hasFilledBlockSets = true;
        }
        if (event.getRegistryKey().equals(Registries.ENTITY_TYPE)) {
            String modId;
            List<Runnable> registrationQueues;
            BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
            if (!hasFilledBlockSets) {
                BlockSetInternal.initializeBlockSets();
                hasFilledBlockSets = true;
            }
            if ((registrationQueues = LATE_REGISTRATION_QUEUE.get(modId = ModLoadingContext.get().getActiveContainer().getModId())) != null) {
                registrationQueues.forEach(Runnable::run);
            }
            LATE_REGISTRATION_QUEUE.remove(modId);
        }
    }

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    static {
        Consumer<RegisterEvent> eventConsumer = e -> {
            if (e.getRegistryKey().equals(BuiltInRegistries.POTION.key())) {
                BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
            }
        };
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }
}

