/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import org.jetbrains.annotations.Nullable;

public class OptionalItemPool
extends LootPoolSingletonContainer {
    public static final MapCodec<OptionalItemPool> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(o -> o.tagOrItemId)).and(OptionalItemPool.singletonFields((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, OptionalItemPool::new));
    @Nullable
    private final Item item;
    private final String tagOrItemId;

    OptionalItemPool(String tagOrItemId, int quality, int weight, List<LootItemCondition> lootItemConditions, List<LootItemFunction> lootItemFunctions) {
        super(quality, weight, OptionalItemPool.disableIfInvalid(tagOrItemId, lootItemConditions), lootItemFunctions);
        this.item = OptionalItemPool.getOptional(tagOrItemId);
        this.tagOrItemId = tagOrItemId;
    }

    @Nullable
    private static Item getOptional(String res) {
        if (res.startsWith("#")) {
            TagKey key = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)res.substring(1)));
            Iterator iterator = BuiltInRegistries.ITEM.getTagOrEmpty(key).iterator();
            if (iterator.hasNext()) {
                Holder v = (Holder)iterator.next();
                return (Item)v.value();
            }
            return null;
        }
        return BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)res)).orElse(null);
    }

    private static List<LootItemCondition> disableIfInvalid(String res, List<LootItemCondition> lootItemConditions) {
        if (OptionalItemPool.getOptional(res) == null) {
            ArrayList<LootItemCondition> newCond = new ArrayList<LootItemCondition>();
            newCond.add(LootItemRandomChanceCondition.randomChance((float)0.0f).build());
            newCond.addAll(lootItemConditions);
            return newCond;
        }
        return lootItemConditions;
    }

    public LootPoolEntryType getType() {
        return MoonlightRegistry.LAZY_ITEM.get();
    }

    public void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        if (this.item != null) {
            stackConsumer.accept(new ItemStack((ItemLike)this.item));
        } else {
            Moonlight.LOGGER.warn("Tried to add an item from a disabled OptionalLootPoolEntry");
        }
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableOptionalItem(String itemRes) {
        return OptionalItemPool.simpleBuilder((i, j, lootItemConditions, lootItemFunctions) -> new OptionalItemPool(itemRes, i, j, lootItemConditions, lootItemFunctions));
    }
}

