/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.fluid.neoforge.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    public static final Map<Fluid, Holder<SoftFluid>> FLUID_MAP = new IdentityHashMap<Fluid, Holder<SoftFluid>>();
    public static final Map<Item, Holder<SoftFluid>> ITEM_MAP = new IdentityHashMap<Item, Holder<SoftFluid>>();

    private static void populateSlaveMaps() {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        for (Holder.Reference<SoftFluid> h : SoftFluidRegistry.getHolders()) {
            SoftFluid s = (SoftFluid)h.value();
            if (!s.isEnabled()) continue;
            s.getEquivalentFluids().forEach(f -> FLUID_MAP.put((Fluid)f.value(), (Holder<SoftFluid>)h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.POTION || !BuiltInSoftFluids.WATER.is((Holder<SoftFluid>)h)) {
                    ITEM_MAP.put((Item)i, (Holder<SoftFluid>)h);
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidInternalImpl.init();
    }

    public static void postInitClient() {
        SoftFluidInternal.populateSlaveMaps();
        SoftFluidColors.refreshParticleColors();
    }

    public static void onDataSyncToPlayer(ServerPlayer player, boolean isJoined) {
        if (isJoined) {
            NetworkHelper.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer() {
        SoftFluidInternal.populateSlaveMaps();
        SoftFluidInternal.registerExistingVanillaFluids(FLUID_MAP, ITEM_MAP);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<Fluid, Holder<SoftFluid>> fluidMap, Map<Item, Holder<SoftFluid>> itemMap) {
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(fluidMap, (Map<Item, Holder<SoftFluid>>)var1_1);
    }
}

