/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.BaseMapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.LenientHolderSetCodec;
import net.mehvahdjukaar.moonlight.api.util.LenientListCodec;
import net.mehvahdjukaar.moonlight.api.util.neoforge.UtilsImpl;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothSides) {
        if (!player.level().isClientSide || bothSides) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)oldItem.copy(), (Player)player, (ItemStack)newItem, (boolean)player.isCreative()));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        Utils.swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.level().isClientSide) {
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)oldItem.copy(), (Player)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        Utils.swapItem(player, hand, player.getItemInHand(hand), newItem);
    }

    public static void addStackToExisting(Player player, ItemStack stack, boolean avoidHands) {
        int j;
        Inventory inv = player.getInventory();
        boolean added = false;
        for (j = 0; j < inv.items.size(); ++j) {
            if (!inv.getItem(j).is(stack.getItem()) || !inv.add(j, stack)) continue;
            added = true;
            break;
        }
        if (avoidHands && !added) {
            for (j = 0; j < inv.items.size(); ++j) {
                if (!inv.getItem(j).isEmpty() || j == inv.selected || !inv.add(j, stack)) continue;
                added = true;
                break;
            }
        }
        if (!added && inv.add(stack)) {
            player.drop(stack, false);
        }
    }

    public static int getXPinaBottle(int bottleCount, RandomSource rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.nextInt(5) + rand.nextInt(5);
        }
        return xp;
    }

    public static ResourceLocation getID(Block object) {
        return BuiltInRegistries.BLOCK.getKey((Object)object);
    }

    public static ResourceLocation getID(EntityType<?> object) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(object);
    }

    public static ResourceLocation getID(Biome object) {
        return Utils.hackyGetRegistry(Registries.BIOME).getKey((Object)object);
    }

    public static ResourceLocation getID(DamageType type) {
        return Utils.hackyGetRegistry(Registries.DAMAGE_TYPE).getKey((Object)type);
    }

    public static ResourceLocation getID(ConfiguredFeature<?, ?> object) {
        return Utils.hackyGetRegistry(Registries.CONFIGURED_FEATURE).getKey(object);
    }

    public static ResourceLocation getID(Item object) {
        return BuiltInRegistries.ITEM.getKey((Object)object);
    }

    public static ResourceLocation getID(Fluid object) {
        return BuiltInRegistries.FLUID.getKey((Object)object);
    }

    public static ResourceLocation getID(BlockEntityType<?> object) {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(object);
    }

    public static ResourceLocation getID(RecipeSerializer<?> object) {
        return BuiltInRegistries.RECIPE_SERIALIZER.getKey(object);
    }

    public static ResourceLocation getID(SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().getKey((Object)object);
    }

    public static ResourceLocation getID(MLMapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().getKey(object);
    }

    public static ResourceLocation getID(Potion object) {
        return BuiltInRegistries.POTION.getKey((Object)object);
    }

    public static ResourceLocation getID(MobEffect object) {
        return BuiltInRegistries.MOB_EFFECT.getKey((Object)object);
    }

    public static ResourceLocation getID(CreativeModeTab object) {
        return BuiltInRegistries.CREATIVE_MODE_TAB.getKey((Object)object);
    }

    public static ResourceLocation getID(StatType<?> object) {
        return BuiltInRegistries.STAT_TYPE.getKey(object);
    }

    public static ResourceLocation getID(Object object) {
        if (object instanceof Block) {
            Block b = (Block)object;
            return Utils.getID(b);
        }
        if (object instanceof Item) {
            Item b = (Item)object;
            return Utils.getID(b);
        }
        if (object instanceof EntityType) {
            EntityType b = (EntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof BlockEntityType) {
            BlockEntityType b = (BlockEntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof Biome) {
            Biome b = (Biome)object;
            return Utils.getID(b);
        }
        if (object instanceof Fluid) {
            Fluid b = (Fluid)object;
            return Utils.getID(b);
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer b = (RecipeSerializer)object;
            return Utils.getID(b);
        }
        if (object instanceof ConfiguredFeature) {
            ConfiguredFeature c = (ConfiguredFeature)object;
            return Utils.getID(c);
        }
        if (object instanceof Potion) {
            Potion c = (Potion)object;
            return Utils.getID(c);
        }
        if (object instanceof MobEffect) {
            MobEffect c = (MobEffect)object;
            return Utils.getID(c);
        }
        if (object instanceof Supplier) {
            Supplier s = (Supplier)object;
            return Utils.getID(s.get());
        }
        if (object instanceof SoftFluid) {
            SoftFluid s = (SoftFluid)object;
            return Utils.getID(s);
        }
        if (object instanceof MLMapDecorationType) {
            MLMapDecorationType s = (MLMapDecorationType)object;
            return Utils.getID(s);
        }
        if (object instanceof CreativeModeTab) {
            CreativeModeTab t = (CreativeModeTab)object;
            return Utils.getID(t);
        }
        if (object instanceof DamageType) {
            DamageType t = (DamageType)object;
            return Utils.getID(t);
        }
        if (object instanceof StatType) {
            StatType t = (StatType)object;
            return Utils.getID(t);
        }
        throw new UnsupportedOperationException("Unsupported class type " + String.valueOf(object.getClass()) + ". Expected a registry entry for a call to Utils.getID()");
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        MinecraftServer s = PlatHelper.getCurrentServer();
        if (s != null) {
            return s.registryAccess();
        }
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                return level.registryAccess();
            }
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static <T> Registry<T> hackyGetRegistry(ResourceKey<Registry<T>> registry) {
        return Utils.hackyGetRegistryAccess().registryOrThrow(registry);
    }

    public static BlockBehaviour.Properties copyPropertySafe(Block blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)blockBehaviour);
        BlockState state = blockBehaviour.defaultBlockState();
        p.lightLevel(s -> state.getLightEmission());
        p.offsetType(BlockBehaviour.OffsetType.NONE);
        p.isValidSpawn((blockState, blockGetter, pos, entityType) -> blockState.isFaceSturdy(blockGetter, pos, Direction.UP) && blockState.getLightEmission() < 14);
        p.mapColor(blockBehaviour.defaultMapColor());
        p.emissiveRendering((blockState, blockGetter, blockPos) -> false);
        return p;
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name) {
        Utils.awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name, String unlockProp) {
        PlayerAdvancements advancements;
        AdvancementHolder advancement = sp.getServer().getAdvancements().get(name);
        if (advancement != null && !(advancements = sp.getAdvancements()).getOrStartProgress(advancement).isDone()) {
            advancements.award(advancement, unlockProp);
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static BlockState readBlockState(CompoundTag compound, @Nullable Level level) {
        HolderLookup.RegistryLookup holderGetter = level != null ? level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        return NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)compound);
    }

    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.hasProperty(property)) {
            return (BlockState)to.setValue(property, from.getValue(property));
        }
        return to;
    }

    public static boolean mayPerformBlockAction(Player player, BlockPos pos, ItemStack stack) {
        AdventureModePredicate adventureModePredicate;
        boolean result;
        GameType gameMode;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            gameMode = sp.gameMode.getGameModeForPlayer();
        } else {
            gameMode = Minecraft.getInstance().gameMode.getPlayerMode();
        }
        boolean bl = result = !player.blockActionRestricted(player.level(), pos, gameMode);
        if (!result && gameMode == GameType.ADVENTURE && !stack.isEmpty() && (adventureModePredicate = (AdventureModePredicate)stack.get(DataComponents.CAN_PLACE_ON)) != null && adventureModePredicate.test(new BlockInWorld((LevelReader)player.level(), pos, false))) {
            return true;
        }
        return result;
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = Utils.findMethodWithMatchingName(subclass, name);
        Method modMethod = Utils.findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> C optionalMapCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        void var1_1;
        return UtilsImpl.optionalMapCodec(keyCodec, var1_1);
    }

    public static <T> Codec<List<T>> optionalRegistryListCodec(Registry<T> reg) {
        return ResourceLocation.CODEC.listOf().xmap(l -> l.stream().filter(arg_0 -> ((Registry)reg).containsKey(arg_0)).map(arg_0 -> ((Registry)reg).get(arg_0)).toList(), a -> a.stream().map(arg_0 -> ((Registry)reg).getKey(arg_0)).toList());
    }

    public static <A> LenientListCodec<A> lenientListCodec(Codec<A> elementCodec) {
        return new LenientListCodec<A>(elementCodec);
    }

    public static <E> Codec<HolderSet<E>> lenientHomogeneousList(ResourceKey<? extends Registry<E>> registryKey) {
        return LenientHolderSetCodec.create(registryKey, RegistryFixedCodec.create(registryKey), false);
    }
}

