/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe.neoforge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.AndCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ResourceConditionsBridge {
    private static final Codec<ICondition> REMAPPING_CODEC = ResourceConditionsBridge.byNameCodecRemap(NeoForgeRegistries.CONDITION_SERIALIZERS, "fabric", "neoforge").dispatch("condition", ICondition::codec, Function.identity());
    private static final Codec<List<ICondition>> LIST_CODEC = Utils.lenientListCodec(REMAPPING_CODEC);
    private static final Codec<ICondition> SINGLE_OR_LIST = Codec.withAlternative(REMAPPING_CODEC, LIST_CODEC, AndCondition::new);

    private static <T> Codec<T> byNameCodecRemap(Registry<T> registry, String from, String to) {
        return ResourceLocation.CODEC.xmap(r -> ResourceLocation.fromNamespaceAndPath((String)r.getNamespace().replace(from, to), (String)r.getPath()), Function.identity()).comapFlatMap(arg -> registry.getOptional(arg).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(registry.key()) + ": " + String.valueOf(arg))), arg_0 -> registry.getKey(arg_0));
    }

    public static boolean matchesForgeConditions(JsonObject obj, ICondition.IContext context, String conditionKey) {
        DataResult c;
        JsonElement je = obj.get(conditionKey);
        if (je != null && (c = SINGLE_OR_LIST.parse((DynamicOps)JsonOps.INSTANCE, (Object)je)).result().isPresent()) {
            return ((ICondition)c.getOrThrow()).test(context);
        }
        return true;
    }

    public static void init() {
        try {
            RegHelper.register(ResourceLocation.parse((String)"neoforge:all_mods_loaded"), () -> AllModsLoadedResourceCondition.CODEC, NeoForgeRegistries.Keys.CONDITION_CODECS);
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to register neoforge conditions", (Throwable)e);
        }
    }

    public record AllModsLoadedResourceCondition(List<String> modIds) implements ICondition
    {
        public static final MapCodec<AllModsLoadedResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("values").forGetter(AllModsLoadedResourceCondition::modIds)).apply((Applicative)instance, AllModsLoadedResourceCondition::new));

        public boolean test(ICondition.IContext iContext) {
            for (String modId : this.modIds) {
                if (PlatHelper.isModLoaded(modId)) continue;
                return false;
            }
            return true;
        }

        public MapCodec<? extends ICondition> codec() {
            return CODEC;
        }
    }
}

