/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayInputStream;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class DynamicDataPack
extends DynamicResourcePack {
    public DynamicDataPack(ResourceLocation name, Pack.Position position, boolean fixed, boolean hidden) {
        super(name, PackType.SERVER_DATA, position, fixed, hidden);
    }

    public DynamicDataPack(ResourceLocation name) {
        super(name, PackType.SERVER_DATA);
    }

    public void addTag(SimpleTagBuilder builder, ResourceKey<?> type) {
        ResourceLocation loc;
        ResourceLocation tagId = builder.getId();
        Object tagPath = type.location().getPath();
        if (((String)tagPath).equals("block") || ((String)tagPath).equals("entity_type") || ((String)tagPath).equals("item") || ((String)tagPath).equals("fluid")) {
            tagPath = (String)tagPath + "s";
        }
        if (this.resources.containsKey(loc = ResType.TAGS.getPath(tagId.withPath((String)tagPath + "/" + tagId.getPath())))) {
            byte[] r = (byte[])this.resources.get(loc);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(r);){
                JsonObject oldTag = RPUtils.deserializeJson(stream);
                builder.addFromJson(oldTag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JsonElement json = builder.serializeToJson();
        this.addJson(loc, json, ResType.GENERIC);
    }

    public void addSimpleBlockLootTable(Block block) {
        this.addLootTable(block, DynamicDataPack.createSingleItemTable((ItemLike)block).setParamSet(LootContextParamSets.BLOCK));
    }

    public void addLootTable(Block block, LootTable.Builder table) {
        this.addLootTable(block.getLootTable().location(), table.build());
    }

    public void addLootTable(ResourceLocation id, LootTable table) {
        this.addJson(id, (JsonElement)LootDataType.TABLE.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)table).getOrThrow(), ResType.LOOT_TABLES);
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike itemLike) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike)).unwrap());
    }

    public void addRecipe(RecipeHolder<?> holder) {
        this.addRecipe(holder.value(), holder.id());
    }

    public void addRecipe(Recipe<?> recipe, ResourceLocation id) {
        this.addRecipeNoAdvancement(recipe, id);
    }

    public void addRecipeNoAdvancement(Recipe<?> recipe, ResourceLocation id) {
        this.addJson(id, RPUtils.writeRecipe(recipe), ResType.RECIPES);
    }
}

