/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MLMapMarker<D extends MLMapDecoration> {
    private final Holder<MLMapDecorationType<?, ?>> type;
    @NotNull
    protected final BlockPos pos;
    protected final float rot;
    protected final Optional<Component> name;
    protected final boolean preventsExtending;
    protected final boolean shouldRefresh;
    protected final boolean shouldSave;
    public static final Codec<MLMapMarker<?>> CODEC = MLMapDecorationType.CODEC.dispatch("type", MLMapMarker::getType, mapWorldMarker -> ((MLMapDecorationType)mapWorldMarker.value()).getMarkerCodec());
    public static final int HAS_SMALL_TEXTURE_FLAG = 1;

    public static <T extends MLMapMarker<?>> Products.P7<RecordCodecBuilder.Mu<T>, Holder<MLMapDecorationType<?, ?>>, BlockPos, Float, Optional<Component>, Optional<Boolean>, Optional<Boolean>, Boolean> baseCodecGroup(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)MLMapDecorationType.CODEC.fieldOf("type").forGetter(m -> m.getType()), (App)BlockPos.CODEC.fieldOf("pos").forGetter(m -> m.getPos()), (App)Codec.FLOAT.optionalFieldOf("rot", (Object)Float.valueOf(0.0f)).forGetter(m -> Float.valueOf(m.getRotation())), (App)ComponentSerialization.FLAT_CODEC.optionalFieldOf("name").forGetter(m -> m.getDisplayName()), (App)Codec.BOOL.optionalFieldOf("should_refresh").forGetter(m -> Optional.of(m.shouldRefreshFromWorld())), (App)Codec.BOOL.optionalFieldOf("should_save").forGetter(m -> Optional.of(m.shouldSave())), (App)Codec.BOOL.optionalFieldOf("prevents_extending", (Object)false).forGetter(m -> m.preventsExtending()));
    }

    public MLMapMarker(Holder<MLMapDecorationType<?, ?>> type, BlockPos pos, float rotation, Optional<Component> component, Optional<Boolean> shouldRefresh, Optional<Boolean> shouldSave, boolean preventsExtending) {
        this.type = type;
        this.pos = pos;
        this.rot = rotation;
        this.name = component;
        this.shouldRefresh = shouldRefresh.orElse(((MLMapDecorationType)type.value()).isFromWorld());
        this.shouldSave = shouldSave.orElse(((MLMapDecorationType)type.value()).isFromWorld());
        this.preventsExtending = preventsExtending;
    }

    public Holder<MLMapDecorationType<?, ?>> getType() {
        return this.type;
    }

    public boolean shouldRefreshFromWorld() {
        return this.shouldRefresh;
    }

    public boolean shouldSave() {
        return this.shouldSave;
    }

    public boolean preventsExtending() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MLMapMarker that = (MLMapMarker)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.pos, that.pos) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.pos, this.name);
    }

    public String getMarkerUniqueId() {
        return this.type.getRegisteredName() + "-" + this.pos.getX() + "," + this.pos.getY() + "," + this.pos.getZ();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public float getRotation() {
        return this.rot;
    }

    public Optional<Component> getDisplayName() {
        return this.name;
    }

    @NotNull
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    @Nullable
    public D createDecorationFromMarker(MapItemSavedData data) {
        BlockPos pos = this.getPos();
        if (pos == null) {
            return null;
        }
        double worldX = pos.getX();
        double worldZ = pos.getZ();
        double rotation = this.getRotation();
        int i = 1 << data.scale;
        float f = (float)(worldX - (double)data.centerX) / (float)i;
        float f1 = (float)(worldZ - (double)data.centerZ) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }

    public int getFlags() {
        return 0;
    }

    public boolean hasFlag(int flag) {
        return (this.getFlags() & flag) != 0;
    }
}

