/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.SimpleMapMarker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.Nullable;

public final class MLJsonMapDecorationType
extends MLMapDecorationType<MLMapDecoration, SimpleMapMarker> {
    static final Codec<MLJsonMapDecorationType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.CODEC.optionalFieldOf("target_block").forGetter(MLJsonMapDecorationType::getTarget), (App)ComponentSerialization.FLAT_CODEC.optionalFieldOf("name").forGetter(MLJsonMapDecorationType::getDisplayName), (App)Codec.FLOAT.optionalFieldOf("rotation", (Object)Float.valueOf(0.0f)).forGetter(MLJsonMapDecorationType::getRotation), (App)ColorUtils.CODEC.optionalFieldOf("map_color", (Object)0).forGetter(MLJsonMapDecorationType::getDefaultMapColor), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.STRUCTURE).optionalFieldOf("target_structures").forGetter(MLJsonMapDecorationType::getAssociatedStructure), (App)Codec.STRING.xmap(PlatHelper::isModLoaded, b -> "minecraft").optionalFieldOf("from_mod", (Object)true).forGetter(t -> t.enabled)).apply((Applicative)instance, MLJsonMapDecorationType::new));
    static final Codec<MLJsonMapDecorationType> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.CODEC.optionalFieldOf("target_block").forGetter(MLJsonMapDecorationType::getTarget), (App)ComponentSerialization.FLAT_CODEC.optionalFieldOf("name").forGetter(MLJsonMapDecorationType::getDisplayName), (App)Codec.FLOAT.optionalFieldOf("rotation", (Object)Float.valueOf(0.0f)).forGetter(MLJsonMapDecorationType::getRotation), (App)ColorUtils.CODEC.optionalFieldOf("map_color", (Object)0).forGetter(MLJsonMapDecorationType::getDefaultMapColor), (App)Codec.BOOL.fieldOf("enabled").forGetter(t -> t.enabled)).apply((Applicative)instance, MLJsonMapDecorationType::new));
    private final Optional<RuleTest> target;
    private final Optional<Component> name;
    private final Optional<HolderSet<Structure>> structures;
    private final int defaultMapColor;
    private final float defaultRotation;
    private final boolean enabled;

    public MLJsonMapDecorationType(Optional<RuleTest> target) {
        this(target, Optional.empty(), 0.0f, 0, true);
    }

    public MLJsonMapDecorationType(Optional<RuleTest> target, Optional<Component> name, float rotation, int mapColor, boolean enabled) {
        this(target, name, rotation, mapColor, Optional.empty(), enabled);
    }

    public MLJsonMapDecorationType(Optional<RuleTest> target, Optional<Component> name, float rotation, int mapColor, Optional<HolderSet<Structure>> structure, Boolean enabled) {
        super(SimpleMapMarker.DIRECT_CODEC, MLMapDecoration.DIRECT_CODEC);
        this.target = target;
        this.name = name;
        this.defaultRotation = rotation;
        this.structures = structure;
        this.defaultMapColor = mapColor;
        this.enabled = enabled;
    }

    public Optional<RuleTest> getTarget() {
        return this.target;
    }

    public Optional<Component> getDisplayName() {
        return this.name;
    }

    public float getRotation() {
        return this.defaultRotation;
    }

    @Override
    public Optional<HolderSet<Structure>> getAssociatedStructure() {
        return this.structures;
    }

    @Override
    public int getDefaultMapColor() {
        return this.defaultMapColor;
    }

    @Override
    public boolean isFromWorld() {
        return this.target.isPresent();
    }

    @Override
    @Nullable
    public SimpleMapMarker createMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        if (this.target.isPresent() && this.enabled && this.target.get().test(reader.getBlockState(pos), RandomSource.create())) {
            return new SimpleMapMarker(MapDataInternal.hackyGetRegistry().wrapAsHolder((Object)this), pos, Float.valueOf(this.defaultRotation), this.name);
        }
        return null;
    }
}

