/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.configured;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeConfig;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.integration.configured.CustomConfigSelectScreen;
import net.mehvahdjukaar.moonlight.api.platform.configs.neoforge.ForgeConfigHolder;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Nullable;

public abstract class CustomConfigScreen
extends ConfigScreen {
    @Nullable
    private static final Field FORGE_CONFIG = CustomConfigScreen.findFieldOrNull(NeoForgeConfig.class, "config");
    @Nullable
    private static final Field BUTTON_ON_PRESS = CustomConfigScreen.findFieldOrNull(Button.class, "onPress");
    @Nullable
    private static final Field FOLDER_ENTRY = CustomConfigScreen.findFieldOrNull(ConfigScreen.class, "folderEntry");
    @Nullable
    private static final Method SAVE_CONFIG = CustomConfigScreen.findMethodOrNull(ConfigScreen.class, "saveConfig");
    @Nullable
    private static final Field CONFIG_VALUE_HOLDER = CustomConfigScreen.findFieldOrNull(ConfigScreen.ConfigItem.class, "holder");
    @Nullable
    private static final Field BOOLEAN_ITEM_BUTTON = CustomConfigScreen.findFieldOrNull(ConfigScreen.BooleanItem.class, "button");
    protected final String modId;
    protected final Map<String, ItemStack> icons = new HashMap<String, ItemStack>();
    public final ForgeConfigHolder mlConfig;
    public final ItemStack mainIcon;
    private int ticks = 0;

    @Nullable
    static Method findMethodOrNull(Class<?> c, String methodName) {
        Method field = null;
        try {
            field = ObfuscationReflectionHelper.findMethod(c, (String)methodName, (Class[])new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    @Nullable
    static Field findFieldOrNull(Class<?> c, String fieldName) {
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(c, (String)fieldName);
            field.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return field;
    }

    protected CustomConfigScreen(CustomConfigSelectScreen parent, IModConfig config) {
        this(parent.getModId(), parent.getMainIcon(), parent.getTitle(), (Screen)parent, config);
    }

    protected CustomConfigScreen(String modId, ItemStack mainIcon, Component title, Screen parent, IModConfig config) {
        super(parent, title, config);
        this.modId = modId;
        this.mainIcon = mainIcon;
        this.mlConfig = ForgeConfigHolder.getFromForgeConfig(this.getForgeConfig(config));
    }

    private ModConfig getForgeConfig(IModConfig config) {
        try {
            FORGE_CONFIG.setAccessible(true);
            return (ModConfig)FORGE_CONFIG.get(config);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        super.constructEntries(entries);
        ArrayList<ListMenuScreen.Item> copy = new ArrayList<ListMenuScreen.Item>(entries);
        entries.clear();
        ListIterator iter = copy.listIterator();
        while (iter.hasNext()) {
            ListMenuScreen.Item e = (ListMenuScreen.Item)iter.next();
            if (!e.getLabel().toLowerCase(Locale.ROOT).equals(this.getEnabledKeyword())) continue;
            iter.remove();
            entries.add(e);
        }
        entries.addAll(copy);
    }

    public ItemStack getIcon(String ... path) {
        String last = path[path.length - 1];
        if (path.length > 1 && last.equals(this.getEnabledKeyword())) {
            last = path[path.length - 2];
        }
        if (!this.icons.containsKey(last = last.toLowerCase(Locale.ROOT).replace("_", " "))) {
            String formatted = last.toLowerCase(Locale.ROOT).replace(" ", "_");
            Optional item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)formatted));
            String finalLast = last;
            item.ifPresent(value -> this.addIcon(finalLast, value.asItem().getDefaultInstance()));
        }
        return this.icons.getOrDefault(last, ItemStack.EMPTY);
    }

    private void addIcon(String s, ItemStack i) {
        this.icons.put(s, i);
    }

    protected void init() {
        super.init();
        this.list.replaceEntries(this.replaceItems(this.list.children()));
        Collection<ListMenuScreen.Item> temp = this.replaceItems(this.entries);
        this.entries = new ArrayList<ListMenuScreen.Item>(temp);
        if (this.saveButton != null && SAVE_CONFIG != null && BUTTON_ON_PRESS != null) {
            try {
                Button.OnPress press = this::saveButtonAction;
                BUTTON_ON_PRESS.set(this.saveButton, press);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Collection<ListMenuScreen.Item> replaceItems(Collection<ListMenuScreen.Item> originals) {
        ArrayList<ListMenuScreen.Item> newList = new ArrayList<ListMenuScreen.Item>();
        for (ListMenuScreen.Item c : originals) {
            ConfigScreen.BooleanItem b;
            Object wrapper;
            if (c instanceof ConfigScreen.FolderItem) {
                ConfigScreen.FolderItem f = (ConfigScreen.FolderItem)c;
                wrapper = this.wrapFolderItem(f);
                if (wrapper != null) {
                    newList.add((ListMenuScreen.Item)wrapper);
                    continue;
                }
            } else if (c instanceof ConfigScreen.BooleanItem && (wrapper = this.wrapBooleanItem(b = (ConfigScreen.BooleanItem)c)) != null) {
                newList.add((ListMenuScreen.Item)wrapper);
                continue;
            }
            newList.add(c);
        }
        return newList;
    }

    private void saveButtonAction(Button button) {
        if (this.config != null) {
            try {
                SAVE_CONFIG.invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isChanged(this.folderEntry)) {
                this.onSave();
            }
        }
        this.minecraft.setScreen(this.parent);
    }

    public abstract void onSave();

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Lighting.setupFor3DItems();
        int titleWidth = this.font.width((FormattedText)this.title) + 35;
        graphics.renderFakeItem(this.mainIcon, this.width / 2 + titleWidth / 2 - 17, 2);
        graphics.renderFakeItem(this.mainIcon, this.width / 2 - titleWidth / 2, 2);
    }

    public void tick() {
        super.tick();
        ++this.ticks;
    }

    @Nullable
    private FolderWrapper wrapFolderItem(ConfigScreen.FolderItem old) {
        try {
            String oldName = old.getLabel();
            IConfigEntry found = null;
            for (IConfigEntry e : this.folderEntry.getChildren()) {
                String n;
                if (e instanceof ValueEntry || !(n = Component.literal((String)ConfigScreen.createLabel((String)e.getEntryName())).getString()).equals(oldName)) continue;
                found = e;
                break;
            }
            if (found != null) {
                return new FolderWrapper(found, oldName);
            }
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to wrap folder entry for config screen: ", (Throwable)e);
        }
        return null;
    }

    public abstract Factory getSubScreenFactory();

    public String getEnabledKeyword() {
        return "enabled";
    }

    @Nullable
    private BooleanWrapper wrapBooleanItem(ConfigScreen.BooleanItem old) {
        try {
            IConfigValue holder = (IConfigValue)CONFIG_VALUE_HOLDER.get(old);
            ValueEntry found = null;
            for (IConfigEntry e : this.folderEntry.getChildren()) {
                ValueEntry value;
                if (!(e instanceof ValueEntry) || holder != (value = (ValueEntry)e).getValue()) continue;
                found = value;
            }
            if (found != null) {
                String[] path = (String[])((NeoForgeValue)holder).configValue.getPath().toArray(String[]::new);
                ItemStack icon = this.getIcon(path);
                return new BooleanWrapper((IConfigValue<Boolean>)holder, icon);
            }
        }
        catch (Exception ignored) {
            Moonlight.LOGGER.error("error");
        }
        return null;
    }

    private static void rotateItem(int ticks, float partialTicks, PoseStack s, BakedModel m) {
        if (ticks != 0) {
            if (m.usesBlockLight()) {
                s.mulPose(Axis.YP.rotation(((float)ticks + partialTicks) * ((float)Math.PI / 180) * 10.0f));
            } else {
                float scale = 1.0f + 0.1f * Mth.sin((float)(((float)ticks + partialTicks) * ((float)Math.PI / 180) * 20.0f));
                s.scale(scale, scale, scale);
            }
        }
    }

    private class FolderWrapper
    extends ConfigScreen.FolderItem {
        private final ItemStack icon;
        protected final Button button;
        protected boolean light;
        private int ticks;
        private int lastTick;

        private FolderWrapper(IConfigEntry folderEntry, String label) {
            super((ConfigScreen)CustomConfigScreen.this, folderEntry);
            this.ticks = 0;
            this.lastTick = 1;
            this.button = Button.builder((Component)Component.literal((String)label).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.WHITE), onPress -> {
                MutableComponent newTitle = CustomConfigScreen.this.title.plainCopy().append(" > " + label);
                CustomConfigScreen sc = CustomConfigScreen.this.getSubScreenFactory().create(CustomConfigScreen.this.modId, CustomConfigScreen.this.mainIcon, (Component)newTitle, (Screen)CustomConfigScreen.this, CustomConfigScreen.this.config);
                try {
                    FOLDER_ENTRY.set((Object)sc, folderEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CustomConfigScreen.this.minecraft.setScreen((Screen)sc);
            }).bounds(10, 5, 44, 20).build();
            ItemStack i = CustomConfigScreen.this.getIcon(label.toLowerCase(Locale.ROOT));
            this.icon = i.isEmpty() ? CustomConfigScreen.this.mainIcon : i;
            this.light = this.getFolderEnabledValue(folderEntry);
        }

        private boolean getFolderEnabledValue(IConfigEntry entry) {
            for (IConfigEntry c : entry.getChildren()) {
                Object object;
                IConfigValue value = c.getValue();
                if (value == null || !value.getName().equals(CustomConfigScreen.this.getEnabledKeyword()) || !((object = value.get()) instanceof Boolean)) continue;
                Boolean b = (Boolean)object;
                return b;
            }
            return true;
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.button);
        }

        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int light;
            int n = light = this.light ? 0xF000F0 : 0;
            if (this.lastTick < CustomConfigScreen.this.ticks) {
                this.ticks = Math.max(0, this.ticks + (hovered ? 1 : -2)) % 36;
            }
            this.lastTick = CustomConfigScreen.this.ticks;
            this.button.setX(left - 1);
            this.button.setY(top);
            this.button.setWidth(width);
            this.button.render(graphics, mouseX, mouseY, partialTicks);
            int center = this.button.getX() + width / 2;
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            RenderUtil.renderGuiItemRelative(graphics.pose(), this.icon, center + 95 - 17, top + 2, renderer, (s, m) -> CustomConfigScreen.rotateItem(this.ticks, partialTicks, s, m), light, OverlayTexture.NO_OVERLAY);
            RenderUtil.renderGuiItemRelative(graphics.pose(), this.icon, center - 95, top + 2, renderer, (s, m) -> CustomConfigScreen.rotateItem(this.ticks, partialTicks, s, m), light, OverlayTexture.NO_OVERLAY);
        }
    }

    private class BooleanWrapper
    extends ConfigScreen.BooleanItem {
        private static final int ICON_SIZE = 12;
        private final ItemStack item;
        protected final int iconOffset;
        protected final boolean needsGameRestart;
        protected boolean doesNeedsGameRestart;
        protected Button button;
        private int ticks;
        private int lastTick;

        public BooleanWrapper(IConfigValue<Boolean> holder, ItemStack item) {
            super((ConfigScreen)CustomConfigScreen.this, holder);
            this.doesNeedsGameRestart = false;
            this.ticks = 0;
            this.lastTick = 1;
            try {
                this.button = (Button)BOOLEAN_ITEM_BUTTON.get((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.button.setMessage((Component)Component.literal((String)""));
            this.needsGameRestart = CustomConfigScreen.this.mlConfig.requiresGameRestart(((NeoForgeValue)holder).configValue);
            this.item = item;
            this.iconOffset = item.isEmpty() ? 0 : 7;
        }

        public BooleanWrapper(IConfigValue<Boolean> holder) {
            this(holder, ItemStack.EMPTY);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean r = super.mouseClicked(mouseX, mouseY, button);
            this.doesNeedsGameRestart = !this.doesNeedsGameRestart;
            return r;
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.button.setMessage((Component)Component.literal((String)""));
            super.render(graphics, index, top, left, width, height, mouseX, mouseY, hovered, partialTicks);
            hovered = this.button.isMouseOver((double)mouseX, (double)mouseY);
            if (this.lastTick < CustomConfigScreen.this.ticks) {
                this.ticks = Math.max(0, this.ticks + (hovered ? 1 : -2)) % 36;
                if (!hovered && this.ticks > 17) {
                    this.ticks %= 18;
                }
            }
            this.lastTick = CustomConfigScreen.this.ticks;
            if (this.doesNeedsGameRestart) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.blit(IconButton.ICONS, left - 18, top + 5, 11, 11, 51.0f, 22.0f, 11, 11, 64, 64);
                if (MthUtils.isWithinRectangle(left - 18, top + 5, 11, 11, mouseX, mouseY)) {
                    String translationKey = "configured.gui.requires_game_restart";
                    int outline = -1438090048;
                    CustomConfigScreen.this.setActiveTooltip((Component)Component.translatable((String)translationKey), outline);
                }
            }
            RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int iconX = this.iconOffset + (int)((double)this.button.getX() + Math.ceil((float)(this.button.getWidth() - 12) / 2.0f));
            int iconY = (int)((double)this.button.getY() + Math.ceil((float)(this.button.getHeight() - 12) / 2.0f));
            boolean on = (Boolean)this.holder.get();
            int u = on ? 12 : 0;
            graphics.blit(CustomConfigSelectScreen.MISC_ICONS, iconX, iconY, 0, (float)u, 0.0f, 12, 12, 64, 64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.item.isEmpty()) {
                int light = on ? 0xF000F0 : 0;
                int center = (int)((float)this.button.getX() + (float)this.button.getWidth() / 2.0f);
                ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
                RenderUtil.renderGuiItemRelative(graphics.pose(), this.item, center - 8 - this.iconOffset, top + 2, renderer, (s, m) -> CustomConfigScreen.rotateItem(this.ticks, partialTicks, s, m), light, OverlayTexture.NO_OVERLAY);
            }
        }

        public void onResetValue() {
            this.button.setMessage((Component)Component.literal((String)""));
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public CustomConfigScreen create(String var1, ItemStack var2, Component var3, Screen var4, IModConfig var5);
    }
}

