/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class ImprovedProjectileEntity
extends ThrowableItemProjectile {
    protected Vec3 movementOld = this.getDeltaMovement();
    protected boolean isStuck = false;
    protected int stuckTime = 0;
    protected int maxAge = 300;
    protected int maxStuckTime = 20;

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, Level world) {
        super(type, world);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level world) {
        this(type, world);
        this.setPos(x, y, z);
    }

    protected ImprovedProjectileEntity(EntityType<? extends ThrowableItemProjectile> type, LivingEntity thrower, Level world) {
        this(type, thrower.getX(), thrower.getEyeY() - (double)0.1f, thrower.getZ(), world);
        this.setOwner((Entity)thrower);
    }

    public void tick() {
        Vec3 movement;
        if (!this.hasBeenShot) {
            this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        this.baseTick();
        if (this.hasReachedEndOfLife() && !this.isRemoved()) {
            this.reachedEndOfLife();
        }
        Level level = this.level();
        this.movementOld = movement = this.getDeltaMovement();
        if (this.stuckSpeedMultiplier.lengthSqr() > 1.0E-7) {
            movement = movement.multiply(this.stuckSpeedMultiplier);
            this.stuckSpeedMultiplier = Vec3.ZERO;
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (!this.noPhysics && this.isStuck) {
            ++this.stuckTime;
        }
        this.move(MoverType.SELF, movement);
        this.tryCheckInsideBlocks();
        this.updateFireState();
        float deceleration = this.isInWater() ? this.getWaterInertia() : this.getInertia();
        this.setDeltaMovement(this.getDeltaMovement().scale((double)deceleration));
        if (!this.isNoGravity() && !this.noPhysics) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, this.getGravity(), 0.0));
        }
        if (!this.isStuck) {
            if (level.isClientSide) {
                this.spawnTrailParticles();
            }
            this.updateRotation();
        }
    }

    private void updateFireState() {
        this.wasOnFire = this.isOnFire();
        if (this.level().getBlockStatesIfLoaded(this.getBoundingBox().deflate(1.0E-6)).noneMatch(arg -> arg.is(BlockTags.FIRE) || arg.is(Blocks.LAVA))) {
            if (this.getRemainingFireTicks() <= 0) {
                this.setRemainingFireTicks(-this.getFireImmuneTicks());
            }
            if (this.wasOnFire && (this.isInPowderSnow || this.isInWaterRainOrBubble() || ForgeHelper.isInFluidThatCanExtinguish((Entity)this))) {
                this.playEntityOnFireExtinguishedSound();
            }
        }
        if (this.isOnFire() && (this.isInPowderSnow || this.isInWaterRainOrBubble() || ForgeHelper.isInFluidThatCanExtinguish((Entity)this))) {
            this.setRemainingFireTicks(-this.getFireImmuneTicks());
        }
    }

    public void move(MoverType moverType, Vec3 movement) {
        BlockHitResult bi;
        BlockPos hitPos;
        BlockState hitState;
        if (moverType != MoverType.SELF) {
            super.move(moverType, movement);
            return;
        }
        movement = this.maybeBackOffFromEdge(movement, moverType);
        Level level = this.level();
        Vec3 pos = this.position();
        ColliderType colliderType = this.getColliderType();
        BlockHitResult hitResult = switch (colliderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> level.clip(new ClipContext(pos, pos.add(movement), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            case 1 -> MthUtils.collideWithSweptAABB((Entity)this, movement, 2.0);
            case 2 -> {
                Vec3 vec3 = this.collide(movement);
                Vec3 sub = vec3.subtract(movement);
                if (vec3 == movement) {
                    yield BlockHitResult.miss((Vec3)pos.add(vec3), (Direction)Direction.UP, (BlockPos)BlockPos.containing((Position)pos.add(vec3)));
                }
                yield new BlockHitResult(pos.add(vec3), Direction.getNearest((double)sub.x, (double)sub.y, (double)sub.z), BlockPos.containing((Position)pos.add(vec3)), false);
            }
        };
        Vec3 newPos = hitResult.getLocation();
        Vec3 newMovement = newPos.subtract(pos);
        this.setPos(newPos.x, newPos.y, newPos.z);
        boolean bl = !Mth.equal((double)newMovement.x, (double)movement.x);
        boolean bl2 = !Mth.equal((double)newMovement.z, (double)movement.z);
        this.horizontalCollision = bl || bl2;
        this.verticalCollision = newMovement.y != movement.y;
        this.verticalCollisionBelow = this.verticalCollision && newMovement.y < 0.0;
        this.minorHorizontalCollision = this.horizontalCollision ? this.isHorizontalCollisionMinor(newMovement) : false;
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)level, (Entity)this, (Vec3)pos, (Vec3)newPos, (AABB)this.getBoundingBox().expandTowards(newPos.subtract(pos)).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0));
        if (entityHitResult != null) {
            hitResult = entityHitResult;
        }
        boolean portalHit = false;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult ei = (EntityHitResult)hitResult;
            Entity hitEntity = ei.getEntity();
            if (hitEntity == this.getOwner()) {
                if (!this.canHarmOwner()) {
                    hitResult = null;
                }
            } else if (hitEntity instanceof Player) {
                Player p2;
                Player p1 = (Player)hitEntity;
                Entity entity = this.getOwner();
                if (entity instanceof Player && !(p2 = (Player)entity).canHarmPlayer(p1)) {
                    hitResult = null;
                }
            }
        } else if (!(hitResult instanceof BlockHitResult) || (hitState = level.getBlockState(hitPos = (bi = hitResult).getBlockPos())).is(Blocks.NETHER_PORTAL) || hitState.is(Blocks.END_GATEWAY)) {
            // empty if block
        }
        if (!portalHit && hitResult != null && hitResult.getType() != HitResult.Type.MISS && !ForgeHelper.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.onHit((HitResult)hitResult);
        }
    }

    public boolean canHarmOwner() {
        if (this.getOwner() instanceof Player) {
            return this.level().getDifficulty().getId() >= 1;
        }
        return false;
    }

    protected float getInertia() {
        return 0.99f;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public boolean hasReachedEndOfLife() {
        return this.tickCount > this.maxAge || this.stuckTime > this.maxStuckTime;
    }

    public void reachedEndOfLife() {
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void spawnTrailParticles() {
        if (this.isInWater()) {
            Vec3 movement = this.getDeltaMovement();
            double velX = movement.x;
            double velY = movement.y;
            double velZ = movement.z;
            for (int j = 0; j < 4; ++j) {
                double pY = this.getEyeY();
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - velX * 0.25, pY - velY * 0.25, this.getZ() - velZ * 0.25, velX, velY, velZ);
            }
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("stuck", this.isStuck);
        tag.putInt("stuckTime", this.stuckTime);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.isStuck = tag.getBoolean("stuck");
        this.stuckTime = tag.getInt("stuckTime");
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        super.shootFromRotation(shooter, x, y, z, velocity, inaccuracy);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        super.shoot(x, y, z, velocity, inaccuracy);
    }

    public float getDefaultShootVelocity() {
        return 1.5f;
    }

    protected ColliderType getColliderType() {
        return ColliderType.AABB;
    }

    protected static enum ColliderType {
        RAY,
        AABB,
        ENTITY_COLLIDE;

    }
}

